<?php
/*
 * Google Plus Box Widget
 */
if ( ! class_exists( 'Sanfrancisco_Widget_Google_Plus_Box' ) ) {
	class Sanfrancisco_Widget_Google_Plus_Box extends WP_Widget {

		function __construct() {

			$widget_opts = array(
				'classname'   => 'sf-widget-google-plus-box',
				'description' => esc_html_x( 'Google+ Box', 'Google+ Box widget description', 'sanfrancisco' )
			);

			parent::__construct( 'sanfrancisco-gplus-box', sprintf( esc_html_x( '%s - Google+ Box', 'Google+ Box widget name', 'sanfrancisco' ), SANFRANCISCO_THEME_TITLE ), $widget_opts );

		}

		function widget( $args, $instance ) {

			echo wp_kses_post( $args['before_widget'] );

			if ( ! empty( $instance['title'] ) ) {
				echo wp_kses_post( $args['before_title'] ) . esc_html( $instance['title'] ) . wp_kses_post( $args['after_title'] );
			}

			// Define google+ box width
			$instance['width'] = 330;

			$opts_whitelist = array(
				'href',
				'layout',
				'theme',
				'showcoverphoto',
				'showtagline',
				'width',
				'rel'
			);

			echo '<div class="g-page-wrapper">';

			foreach( array( 'person', 'page', 'community' ) as $t ) {

				$instance['rel'] = ( $t == 'person' ) ? 'author' : 'publisher';

				echo '<div class="g-'. $t .'"';

				foreach ( $opts_whitelist as $k ) {
					if ( array_key_exists( $k, $instance ) ) {
						echo ' data-' . $k . '="' . esc_attr( $instance[ $k ] ) . '"';
					}
				}

				echo '></div>';

			}

			echo '</div>' . wp_kses_post( $args['after_widget'] );

		}

		function form( $instance ) {
			// the form fields defined in theme core (/library/admin/admin.php)
		}

	}
}