<?php
/*
 * Posts Widget
 */
if ( ! class_exists( 'Sanfrancisco_Widget_Fancy_Posts' ) ) {
	class Sanfrancisco_Widget_Fancy_Posts extends WP_Widget {

		public function __construct() {

			$widget_ops = array(
				'classname'   => 'sf-widget-posts',
				'description' => esc_html_x( 'Displays the posts with more stylish way', 'Posts widget description', 'sanfrancisco' )
			);

			parent::__construct( 'sanfrancisco-posts', sprintf( esc_html_x( '%s - Fancy Posts', 'Posts widget name', 'sanfrancisco' ), SANFRANCISCO_THEME_TITLE ), $widget_ops );

		}

		public function widget( $args, $instance ) {

			$instance['section_layout'] = 'widget';
			$instance['layout'] = ( preg_match( '#^(vertical|horizontal)_([0-9]{1})_col$#', $instance['posts_layout'] ) ) ? 'grid_posts' : 'featured_posts';

			echo wp_kses_post( $args['before_widget'] );

			if ( ! empty( $instance['title'] ) && $instance['layout'] != 'featured_posts' ) {
				echo wp_kses_post( $args['before_title'] ) . esc_html( $instance['title'] ) . wp_kses_post( $args['after_title'] );
				$instance['title'] = '';
			}

			$instance['class_name'] = 'sf-module-widget';
			$instance['paged'] = 1;

			ob_start();

			echo '<div class="'. esc_attr( sanfrancisco_module_class( $instance ) ) .'">';

			sanfrancisco_load_template( array(
				'template' => $instance['layout'],
				'args'     => $instance
			) );

			echo '</div>';

			ob_end_flush();

			echo wp_kses_post( $args['after_widget'] );

		}

		function form( $instance ) {
			// the form fields defined in theme core (/library/admin/admin.php)
		}

	}
}