<?php
/*
 * Facebook Box Widget
 */
if ( ! class_exists( 'Sanfrancisco_Widget_Facebook_Box' ) ) {
	class Sanfrancisco_Widget_Facebook_Box extends WP_Widget {

		function __construct() {

			$widget_ops = array(
				'classname'   => 'sf-widget-facebook-box',
				'description' => esc_html_x( 'Facebook Page Box', 'Facebook Box widget description', 'sanfrancisco' )
			);

			parent::__construct( 'sanfrancisco-facebook-box', sprintf( esc_html_x( '%s - Facebook Box', 'Facebook Box widget name', 'sanfrancisco' ), SANFRANCISCO_THEME_TITLE ), $widget_ops );

		}

		function widget( $args, $instance ) {

			if ( ! array_key_exists( 'href', $instance ) || empty( $instance['href'] ) ) {
				return;
			}

			echo wp_kses_post( $args['before_widget'] );

			if ( ! empty( $instance['title'] ) ) {
				echo wp_kses_post( $args['before_title'] ) . esc_html( $instance['title'] ) . wp_kses_post( $args['after_title'] );
			}

			// Define facebook box width
			$instance['width'] = 360;

			if ( ! array_key_exists( 'tabs', $instance ) || ! is_array( $instance['tabs'] ) ) {
				$instance['tabs'] = array( 'timeline' );
			}

			$instance['tabs'] = implode( ',', $instance['tabs'] );

			$opts_whitelist = array(
				'href',
				'hide_cover',
				'show_facepile',
				'show_posts',
				'small_header',
				'width',
				'tabs'
			);

			echo '<div class="fb-page-wrapper"><div class="fb-page"';

			foreach ( $opts_whitelist as $k ) {
				if ( array_key_exists( $k, $instance ) ) {
					echo ' data-' . str_replace( '_', '-', $k ) . '="' . esc_attr( $instance[ $k ] ) . '"';
				}
			}

			echo '></div></div>' . wp_kses_post( $args['after_widget'] );

		}

		function form( $instance ) {
			// the form fields defined in theme core (/library/admin/admin.php)
		}

	}
}