<?php
/*
 * About Me Widget
 */
if ( ! class_exists( 'Sanfrancisco_Widget_About_Me' ) ) {
	class Sanfrancisco_Widget_About_Me extends WP_Widget {

		function __construct() {

			$widget_ops = array(
				'classname'   => 'sf-widget-about-me',
				'description' => esc_html_x( 'A short description about you.', 'About Me widget description', 'sanfrancisco' )
			);

			parent::__construct( 'sanfrancisco-about-me', sprintf( esc_html_x( '%s - About Me', 'About Me widget name', 'sanfrancisco' ), SANFRANCISCO_THEME_TITLE ), $widget_ops );

		}

		function widget( $args, $instance ) {

			echo wp_kses_post( $args['before_widget'] );

			if ( ! empty( $instance['title'] ) ) {
				echo wp_kses_post( $args['before_title'] ) . esc_html( $instance['title'] ) . wp_kses_post( $args['after_title'] );
			}

			$image = is_numeric( $instance['image'] ) ? wp_get_attachment_image( $instance['image'] ) : '';

			?>
			<div class="sf-about-me">

				<?php

				if( ! empty( $image ) ) {
					echo '<p class="author-image">'. $image .'</p>';
				}

				if( ! empty( $instance['name'] ) ) {
					echo '<h2 class="author-name">'. esc_html( $instance['name'] ) .'</h2>';
				}

				if( ! empty( $instance['job_title'] ) ) {
					echo '<h4 class="author-title">'. esc_html( $instance['job_title'] ) .'</h4>';
				}

				if ( array_key_exists( 'social_url', $instance ) && ! is_array( $instance['social_url'] ) ) {
					$instance['social_url'] = array();
				}

				if ( ! empty( $instance['social'] ) ): ?>
					<ul class="author-social-icons">
						<?php foreach ( $instance['social'] as $k => $v ): ?>
							<li><a href="<?php echo esc_url( $v['url'] ); ?>" target="_blank"><span class="fa fa-<?php echo sanitize_html_class( $v['icon'] ); ?>"></span></a></li>
						<?php endforeach; ?>
					</ul>
					<?php
				endif;

				?>

				<p class="author-description">
					<?php echo wp_kses( nl2br( $instance['description'] ), array( 'br' => array() ) ); ?>
				</p>

			</div>
			<?php

			echo wp_kses_post( $args['after_widget'] );

		}

		function update( $new_instance, $old_instance ) {

			$instance = $old_instance;

			$instance['title']          = strip_tags( $new_instance['title'] );
			$instance['image']          = intval( $new_instance['image'] );
			$instance['name']           = strip_tags( $new_instance['name'] );
			$instance['job_title']      = strip_tags( $new_instance['job_title'] );
			$instance['description']    = strip_tags( $new_instance['description'] );
			$instance['social']         = array();

			if ( array_key_exists( 'social_url', $new_instance ) && is_array( $new_instance['social_url'] ) ) {

				foreach ( $new_instance['social_url'] as $k => $v ) {

					if ( ! empty( $v ) ) {

						$instance['social'][] = array(
							'icon' => sanitize_key( $new_instance['social_icon'][ $k ] ),
							'url'  => esc_url_raw( $v )
						);

					}

				}

			}

			return $instance;

		}

		function form( $instance ) {

			$title        = isset( $instance['title'] ) ? $instance['title'] : '';
			$name         = isset( $instance['name'] ) ? $instance['name'] : '';
			$job_title    = isset( $instance['job_title'] ) ? $instance['job_title'] : '';
			$description  = isset( $instance['description'] ) ? $instance['description'] : '';

			$image = '';
			if ( array_key_exists( 'image', $instance ) && is_numeric( $instance['image'] ) ) {
				$image = wp_get_attachment_image( $instance['image'] );
			}

			?>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'sanfrancisco' ); ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'name' ) ); ?>"><?php esc_html_e( 'Name:', 'sanfrancisco' ); ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'name' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'name' ) ); ?>" type="text" value="<?php echo esc_attr( $name ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'job_title' ) ); ?>"><?php esc_html_e( 'Job Title:', 'sanfrancisco' ); ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'job_title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'job_title' ) ); ?>" type="text" value="<?php echo esc_attr( $job_title ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'image' ) ); ?>"><?php esc_html_e( 'Profile Picture:', 'sanfrancisco' ); ?></label>
				<input type="hidden" class="sf-media" name="<?php echo esc_attr( $this->get_field_name( 'image' ) ); ?>"<?php if ( array_key_exists( 'image', $instance ) && is_numeric( $instance['image'] ) ) { echo ' value="'. esc_attr( $instance['image'] ) .'"'; } ?> />
				<span class="sf-media-holder">
					<?php echo trim( $image ); ?>
				</span>
				<button type="button" class="sf-btn-add-media button<?php echo empty( $image ) ? '' : ' sf-hide'; ?>" id="<?php echo esc_attr( $this->get_field_id( 'image' ) ); ?>" data-return="id"><?php esc_html_e( 'Select Image', 'sanfrancisco' ); ?></button>
				<button type="button" class="sf-btn-remove-media button<?php echo empty( $image ) ? ' sf-hide' : ''; ?>" id="<?php echo esc_attr( $this->get_field_id( 'image' ) ); ?>"><?php esc_html_e( 'Remove Image', 'sanfrancisco' ); ?></button>
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'description' ) ); ?>"><?php esc_html_e( 'About Text:', 'sanfrancisco' ); ?></label>
				<textarea class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'description' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'description' ) ); ?>" rows="16" cols="20"><?php echo esc_textarea( $description ); ?></textarea>
			</p>

			<p>
				<?php esc_html_e( 'Social Icons:', 'sanfrancisco' ); ?>
			</p>

			<?php
			if ( array_key_exists( 'social', $instance ) && is_array( $instance['social'] ) ) {
				foreach ( $instance['social'] as $k => $v ) {
					$this->social_icon_row( $v['icon'], $v['url'] );
				}
			}
			?>

			<p>
				<a href="#" class="sf-btn-add-social-icon button"><?php esc_html_e( 'Add Icon', 'sanfrancisco' ); ?></a>
			</p>

			<div class="sf-social-icon-row-instance" style="display:none;">
				<?php $this->social_icon_row(); ?>
			</div>
			<?php

		}

		function social_icon_row( $selected='', $value='' ) {

			$social = $this->get_social();

			?>
			<div class="sf-social-icon-row">
				<p>
					<label for="<?php echo esc_attr( $this->get_field_id( 'social_icon' ) ); ?>"><?php esc_html_e( 'Icon', 'sanfrancisco' ); ?></label>
					<select id="<?php echo esc_attr( $this->get_field_id( 'social_icon' ) ); ?>" class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'social_icon' ) ); ?>[]">
						<?php foreach ( $social as $k => $v ): ?>
							<option value="<?php echo esc_attr( $k ); ?>"<?php if ( $k == $selected ) { echo ' selected'; } ?>><?php echo esc_html( $v ); ?></option>
						<?php endforeach; ?>
					</select>
					<a href="#" class="sf-social-icon-row-rm">&times;</a>
				</p>
				<p>
					<label for="<?php echo esc_attr( $this->get_field_id( 'social_url' ) ); ?>"><?php esc_html_e( 'Url:', 'sanfrancisco' ); ?></label>
					<input id="<?php echo esc_attr( $this->get_field_id( 'social_url' ) ); ?>" class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'social_url' ) ); ?>[]" type="text" value="<?php echo esc_attr( $value ); ?>" />
				</p>
			</div>
			<?php

		}

		function get_social() {

			$social = array(
				'500px' => '500px',
				'android' => 'Android',
				'apple' => 'Apple',
				'behance' => 'Behance',
				'codepen' => 'Codepen',
				'delicious' => 'Delicious',
				'deviantart' => 'Deviantart',
				'digg' => 'Digg',
				'dribbble' => 'Dribble',
				'dropbox' => 'Dropbox',
				'facebook' => 'Facebook',
				'flickr' => 'Flickr',
				'foursquare' => 'Foursquare',
				'github' => 'Github',
				'google-plus' => 'Google Plus',
				'instagram' => 'Instagram',
				'lastfm' => 'Last FM',
				'linkedin' => 'Linkedin',
				'medium' => 'Medium',
				'odnoklassniki' => 'Odnoklassniki',
				'pinterest' => 'Pinterest',
				'reddit' => 'Reddit',
				'rss' => 'RSS',
				'skype' => 'Skype',
				'slideshare' => 'Slideshare',
				'strava' => 'Strava',
				'soundcloud' => 'Soundcloud',
				'spotify' => 'Spotify',
				'stumbleupon' => 'Stumbleupon',
				'tumblr' => 'Tumblr',
				'twitter' => 'Twitter',
				'vimeo' => 'Vimeo',
				'vine' => 'Vine',
				'vk' => 'VKontakte',
				'whatsapp' => 'Whatsapp',
				'wordpress' => 'Wordpress',
				'xing' => 'Xing',
				'yelp' => 'Yelp',
				'youtube' => 'Youtube'
			);

			return $social;

		}

	}
}