<?php

if ( ! isset( $sanfrancisco_args ) ) {
	return;
}

global $post;

if ( array_key_exists( 'post_id', $sanfrancisco_args ) && $args = sanfrancisco_get_singular_template_args( $sanfrancisco_args['post_id'] ) ) {

	$post = get_post( $sanfrancisco_args['post_id'] );

	foreach ( $args as $k => $v ) {
		$sanfrancisco_args = $v['modules'][ $k ];
	}

}

setup_postdata( $post );

echo '<article class="' . implode( ' ', get_post_class( 'sf-entry sf-entry-singular', $post ) ) . '" itemscope itemtype="https://schema.org/Article">';

sanfrancisco_singular_header( $sanfrancisco_args, 'header' );

if ( ! array_key_exists( 'display_content', $sanfrancisco_args ) || $sanfrancisco_args['display_content'] != 'false' ) {

	$sanfrancisco_entry_content_class = array(
		'sf-entry-content'
	);

	if ( array_key_exists( 'dropcap', $sanfrancisco_args ) && $sanfrancisco_args['dropcap'] == 'true' ) {
		$sanfrancisco_entry_content_class[] = 'sf-has-dropcap';
	}

	echo '<div class="' . esc_attr( implode( ' ', $sanfrancisco_entry_content_class ) ) . '">';

	the_content();

	wp_link_pages( array(
		'link_before' => '<span class="sf-pg-item">',
		'link_after'  => '</span>',
		'before'      => '<div class="sf-pagination"><div class="pagination">',
		'after'       => '</div></div>',
		'pagelink'    => '%'
	) );

	echo '</div>';

}

if ( array_key_exists( 'display_like_button', $sanfrancisco_args ) && $sanfrancisco_args['display_like_button'] == 'true' ) {

	sanfrancisco_like_button();

}

if ( is_single() && ( ! array_key_exists( 'display_tags', $sanfrancisco_args ) || $sanfrancisco_args['display_tags'] != 'false' ) ) {

	$sanfrancisco_post_tags_limit = ( array_key_exists( 'tag_limit', $sanfrancisco_args ) ? $sanfrancisco_args[ 'tag_limit' ] : 3 );

	echo '<div class="sf-entry-tags-box">' . sanfrancisco_post_tags( $post, $sanfrancisco_post_tags_limit, array( 'class' => 'sf-entry-tags sf-eb-item' ), false ) . '</div>';

}

if ( is_single() && ( ! array_key_exists( 'display_related_posts', $sanfrancisco_args ) || $sanfrancisco_args['display_related_posts'] != 'false' ) ) {

	sanfrancisco_related_posts( $post, $sanfrancisco_args );

}

if ( ! array_key_exists( 'display_author_info', $sanfrancisco_args ) || $sanfrancisco_args['display_author_info'] != 'false' ) {

	sanfrancisco_load_template( array(
		'template' => 'author_box',
		'args' => array(
			'author_id' => get_the_author_meta( 'ID' )
		)
	) );

}

do_action( 'sanfrancisco_place_ad', 'post' );

if ( ! array_key_exists( 'display_comments', $sanfrancisco_args ) || $sanfrancisco_args['display_comments'] != 'false' ) {

	comments_template();

}

echo '</article>';

wp_reset_postdata();