<?php

if ( ! isset( $sanfrancisco_args ) || ! is_array( $sanfrancisco_args ) ) {
	return;
}

if ( array_key_exists( 'gp_posts_layout', $sanfrancisco_args ) ) {
	$sanfrancisco_posts_layout = $sanfrancisco_args['gp_posts_layout'];
} else if ( array_key_exists( 'posts_layout', $sanfrancisco_args ) ) {
	$sanfrancisco_posts_layout = $sanfrancisco_args['posts_layout'];
} else {
	return;
}

if ( ! preg_match( '#^(vertical|horizontal)_([0-9]{1})_col$#', $sanfrancisco_posts_layout, $sanfrancisco_match ) ) {
	return;
}

global $wp_query;

$sanfrancisco_template_vars     = array();
$sanfrancisco_column            = $sanfrancisco_match[2];
$sanfrancisco_direction         = $sanfrancisco_match[1];
$sanfrancisco_meta_data         = ( array_key_exists( 'meta_data', $sanfrancisco_args ) && is_array( $sanfrancisco_args['meta_data'] ) ) ? $sanfrancisco_args['meta_data'] : array();
$sanfrancisco_meta_data_pos     = ( $sanfrancisco_direction == 'horizontal' || ( array_key_exists( 'meta_data_pos', $sanfrancisco_args ) && $sanfrancisco_args['meta_data_pos'] == 'bottom' ) ) ? 'bottom' : 'top';
$sanfrancisco_section_layout    = array_key_exists( 'section_layout', $sanfrancisco_args ) ? $sanfrancisco_args['section_layout'] : 'ws';

$sanfrancisco_map = array(
	'vertical' => array(
		'ws' => array(
			1 => array(
				'thumbnail_size' => 'sf-710-355',
				'column_class' => 'col-xs-12'
			),
			2 => array(
				'thumbnail_size' => 'sf-320-240',
				'column_class' => 'col-xs-12 col-sm-6'
			),
		    3 => array(
		    	'thumbnail_size' => 'post-thumbnail',
			    'column_class' => 'col-xs-12 col-sm-4 col-md-6 col-lg-4'
		    )
		),
		'full' => array(
			1 => array(
				'thumbnail_size' => 'sf-1140-570',
				'column_class' => 'col-xs-12'
			),
			2 => array(
				'thumbnail_size' => 'sf-570-300',
				'column_class' => 'col-xs-12 col-sm-6'
			),
			3 => array(
				'thumbnail_size' => 'sf-320-240',
				'column_class' => 'col-xs-12 col-sm-4'
			),
			4 => array(
				'thumbnail_size' => 'post-thumbnail',
				'column_class' => 'col-xs-12 col-sm-6 col-md-3'
			)
		),
		'widget' => array(
			1 => array(
				'thumbnail_size' => 'sf-320-160',
				'column_class' => 'col-xs-12'
			)
		)
	),
	'horizontal' => array(
		'ws' => array(
			1 => array(
				'thumbnail_size' => 'sf-320-240',
				'column_class' => 'col-xs-12'
			),
			2 => array(
				'thumbnail_size' => 'sf-160-120',
				'column_class' => 'col-xs-12 col-sm-6 col-md-12 col-lg-6'
			),
		),
		'full' => array(
			1 => array(
				'thumbnail_size' => 'sf-380-285',
				'column_class' => 'col-xs-12'
			),
			2 => array(
				'thumbnail_size' => 'post-thumbnail',
				'column_class' => 'col-xs-12 col-sm-6'
			),
			3 => array(
				'thumbnail_size' => 'sf-160-120',
				'column_class' => 'col-xs-12 col-sm-6 col-lg-4'
			)
		),
		'widget' => array(
			1 => array(
				'thumbnail_size' => 'sf-160-120',
				'column_class' => 'col-xs-12'
			)
		)
	)
);

if ( ! array_key_exists( $sanfrancisco_column, $sanfrancisco_map[ $sanfrancisco_direction ][ $sanfrancisco_section_layout ] ) ) {
	if ( is_user_logged_in() && current_user_can( 'edit_posts' ) ) {
		echo '<div class="alert alert-warning"><span class="fa fa-warning"></span> '. sprintf( esc_html__( 'The theme does not support %d columns grid posts layout in this section. Please, use this module in other section or choose another grid posts layout instead. %s', 'sanfrancisco' ), $sanfrancisco_column, sanfrancisco_documentation_link( 'grid_posts', esc_html__( 'Learn More', 'sanfrancisco' ), false ) ) .'</div>';
	}
	return;
}

foreach ( $sanfrancisco_map[ $sanfrancisco_direction ][ $sanfrancisco_section_layout ][ $sanfrancisco_column ] as $k => $v ) {
	$sanfrancisco_args[ $k ] = $v;
}

$sanfrancisco_template_vars['query'] = ( ! array_key_exists( 'wp_query', $sanfrancisco_args ) || ! $sanfrancisco_args['wp_query'] ) ? new WP_Query( sanfrancisco_get_post_query_args( $sanfrancisco_args ) ) : $wp_query;

if ( array_key_exists( 'title', $sanfrancisco_args ) && ! empty( $sanfrancisco_args['title'] ) ) {
	echo '<div class="'. esc_attr( sanfrancisco_module_title_class( $sanfrancisco_args ) ) .'"><h2 class="sf-title">'. esc_html( $sanfrancisco_args['title'] ) .'</h2></div>';
}

echo '<div class="sf-col-wrapper row">';

while ( $sanfrancisco_template_vars['query']->have_posts() ): $sanfrancisco_template_vars['query']->the_post();

	/* get post thumbnail id */
	$sanfrancisco_gif_image_id = get_post_meta( get_the_ID(), 'sanfrancisco_gif_featured_image', true );
	$sanfrancisco_post_thumbnail_id = empty( $sanfrancisco_gif_image_id ) ? get_post_thumbnail_id( get_the_ID() ) : $sanfrancisco_gif_image_id;

	/* entry classes */
	$sanfrancisco_entry_class = array(
		'sf-entry',
		sanitize_html_class( 'sf-entry-'. $sanfrancisco_direction )
	);

	if ( ! empty( $sanfrancisco_post_thumbnail_id ) ) {
		$sanfrancisco_entry_class[] = 'sf-entry-has-featured-media';
	}

	$sanfrancisco_tag_limit = array_key_exists( 'tag_limit', $sanfrancisco_args ) ? intval( $sanfrancisco_args['tag_limit'] ) : 3;
	$sanfrancisco_post_tags = sanfrancisco_post_tags( null, $sanfrancisco_tag_limit, array( 'class' => 'sf-entry-tags sf-eb-item' ), false );
	$sanfrancisco_has_tags  = ( ( ! array_key_exists( 'display_tags', $sanfrancisco_args ) || $sanfrancisco_args['display_tags'] != 'false' ) && ! empty( $sanfrancisco_post_tags ) );
	$sanfrancisco_tags_pos  = ( $sanfrancisco_direction == 'vertical' ) ? 'top' : 'bottom';
	$sanfrancisco_post_title = get_the_title();
	$sanfrancisco_header_html = '';

	if ( empty( $sanfrancisco_post_title ) ) {
		$sanfrancisco_post_title = esc_html__( '(no title)', 'sanfrancisco' );
	}

	if ( ! empty( $sanfrancisco_post_title ) ) {
		$sanfrancisco_header_html .= '<header class="sf-entry-header sf-eb-item"><h3 class="sf-entry-title"><a href="'. esc_url( get_the_permalink() ) .'" rel="bookmark">'. $sanfrancisco_post_title .'</a></h3></header>';
	}

	if ( in_array( 'excerpt', $sanfrancisco_meta_data ) ) {
		$sanfrancisco_header_html .= '<p class="sf-entry-excerpt sf-eb-item">'. sanfrancisco_get_excerpt( get_the_ID(), $sanfrancisco_args['excerpt_length'] ) .'</p>';
	}

?>
<div class="sf-col <?php echo esc_attr( $sanfrancisco_args['column_class'] ); ?>">
	<article <?php post_class( $sanfrancisco_entry_class ); ?>>
		<?php

		if ( $sanfrancisco_has_tags && $sanfrancisco_tags_pos == 'top' ) {
			echo trim( $sanfrancisco_post_tags );
		}

		$sanfrancisco_featured_image_args = array(
			'is_teaser'      => true,
			'zoom_on_hover'  => ( sanfrancisco_get_option( 'gp_zoom_hover' ) == 'true' ),
			'flags'          => array(),
			'thumbnail_size' => $sanfrancisco_args['thumbnail_size']
		);

		if ( sanfrancisco_post_is_trending() && in_array( 'trending_icon', $sanfrancisco_meta_data ) ) {
			$sanfrancisco_featured_image_args['flags'][] = 'trending_icon';
		}

		if ( $sanfrancisco_direction == 'vertical' && in_array( 'category', $sanfrancisco_meta_data ) ) {
			$sanfrancisco_featured_image_args['flags'][] = 'category';
		}

		sanfrancisco_featured_media( NULL, $sanfrancisco_featured_image_args );

		?>
		<div class="sf-entry-body">

			<?php

			if ( $sanfrancisco_has_tags && $sanfrancisco_tags_pos == 'bottom' ) {
				echo trim( $sanfrancisco_post_tags );
			}

			if ( $sanfrancisco_meta_data_pos == 'bottom' ) {
				echo trim( $sanfrancisco_header_html );
			}

			$sanfrancisco_post_footer_items = array( 'views', 'likes', 'comments', 'byline' );

			if ( empty( $sanfrancisco_post_thumbnail_id ) && $sanfrancisco_direction == 'vertical' ) {
				$sanfrancisco_post_footer_items[] = 'category';
			}

			$sanfrancisco_meta_data_int = array_intersect( $sanfrancisco_post_footer_items, $sanfrancisco_meta_data );

			if ( ! empty( $sanfrancisco_meta_data_int ) ): ?>
			<footer>
				<ul class="sf-entry-meta sf-eb-item clearfix">
					<?php if ( empty( $sanfrancisco_post_thumbnail_id ) && $sanfrancisco_direction == 'vertical' && in_array( 'category', $sanfrancisco_meta_data ) ): ?>
					<li class="sf-entry-category">
						<?php sanfrancisco_post_categories( null, array( 'class' => 'sf-btn sf-btn-gray' ) ); ?>
					</li>
					<?php endif; if ( in_array( 'views', $sanfrancisco_meta_data ) ): ?>
					<li class="sf-entry-meta-views">
						<span class="fa fa-eye"></span> <span class="sf-count"><?php sanfrancisco_post_views(); ?></span>
					</li>
					<?php endif; if ( in_array( 'likes', $sanfrancisco_meta_data ) ): ?>
					<li class="sf-entry-meta-likes">
						<span class="fa fa-heart-o"></span> <span class="sf-count"><?php sanfrancisco_post_likes(); ?></span>
					</li>
					<?php endif; if ( in_array( 'comments', $sanfrancisco_meta_data ) ): ?>
					<li class="sf-entry-meta-comments">
						<span class="fa fa-comment-o"></span> <span class="sf-count"><?php sanfrancisco_post_comment_count(); ?></span>
					</li>
					<?php endif; if ( in_array( 'byline', $sanfrancisco_meta_data ) ): ?>
					<li class="sf-entry-meta-byline">
						<?php sanfrancisco_byline(); ?>
					</li>
					<?php endif; ?>
				</ul>
			</footer>
			<?php endif; ?>

			<?php if ( $sanfrancisco_direction == 'horizontal' && in_array( 'category', $sanfrancisco_meta_data ) ): ?>
			<p class="sf-entry-category sf-eb-item">
				<?php sanfrancisco_post_categories( null, array( 'class' => 'sf-btn sf-btn-sm sf-btn-gray' ) ); ?>
			</p>
			<?php endif; if ( $sanfrancisco_meta_data_pos == 'top' ) {
				echo trim( $sanfrancisco_header_html );
			} ?>

		</div>

	</article>
</div>
<?php

endwhile;

if ( array_key_exists( 'gp_pagination_type', $sanfrancisco_args ) ) {
	sanfrancisco_pagination( $sanfrancisco_args['gp_pagination_type'], $sanfrancisco_template_vars['query'] );
}

echo '</div>';

wp_reset_postdata();