<?php

if ( ! isset( $sanfrancisco_args ) || ! is_array( $sanfrancisco_args ) ) {
	return;
}

if ( array_key_exists( 'fp_posts_layout', $sanfrancisco_args ) ) {
	$sanfrancisco_posts_layout = $sanfrancisco_args['fp_posts_layout'];
} else if ( array_key_exists( 'posts_layout', $sanfrancisco_args ) ) {
	$sanfrancisco_posts_layout = $sanfrancisco_args['posts_layout'];
} else {
	return;
}

if ( ! preg_match( '#^style_([a-z]{1})$#', $sanfrancisco_posts_layout, $sanfrancisco_match ) ) {
	return;
}

global $wp_query;

$sanfrancisco_template_vars     = array();
$sanfrancisco_fp_style          = end( $sanfrancisco_match );
$sanfrancisco_section_layout    = array_key_exists( 'section_layout', $sanfrancisco_args ) ? $sanfrancisco_args['section_layout'] : 'ws';

if ( $sanfrancisco_fp_style == 'f' && $sanfrancisco_section_layout == 'ws' ) {
	if ( is_user_logged_in() && current_user_can( 'edit_pages' ) ) {
		echo '<div class="alert alert-warning"><span class="fa fa-warning"></span> '. sprintf( esc_html__( 'The theme does not support this style of featured posts layout in section with sidebar. Please, use this module in full width section or choose another featured posts layout instead. %s', 'sanfrancisco' ), sanfrancisco_documentation_link( 'featured_posts', esc_html__( 'Learn More', 'sanfrancisco' ), false ) ) .'</div>';
	}
	return;
}

$sanfrancisco_meta_data         = ( array_key_exists( 'meta_data', $sanfrancisco_args ) && is_array( $sanfrancisco_args['meta_data'] ) ) ? $sanfrancisco_args['meta_data'] : array();
$sanfrancisco_pagination        = ( array_key_exists( 'fp_pagination_type', $sanfrancisco_args ) ) ? $sanfrancisco_args['fp_pagination_type'] : 'carousel';
$sanfrancisco_title_position    = ( array_key_exists( 'fp_entry_body_position', $sanfrancisco_args ) ) ? $sanfrancisco_args['fp_entry_body_position'] : 'bottom';
$sanfrancisco_visibility = array(
	'entry_body' => array(
		'desktop' => array_key_exists( 'fp_entry_body_visibility', $sanfrancisco_args ) ? $sanfrancisco_args[ 'fp_entry_body_visibility' ] : 'always',
		'mobile'  => array_key_exists( 'fp_entry_body_mobile_visibility', $sanfrancisco_args ) ? $sanfrancisco_args[ 'fp_entry_body_mobile_visibility' ] : 'always',
	),
	'carousel_buttons' => array(
		'desktop' => array_key_exists( 'fp_carousel_buttons_visibility', $sanfrancisco_args ) ? $sanfrancisco_args[ 'fp_carousel_buttons_visibility' ] : 'hover',
		'mobile'  => array_key_exists( 'fp_carousel_buttons_visibility', $sanfrancisco_args ) ? $sanfrancisco_args[ 'fp_carousel_buttons_visibility' ] : 'always'
	),
	'carousel_dots' => array(
		'desktop' => array_key_exists( 'fp_carousel_dots_visibility', $sanfrancisco_args ) ? $sanfrancisco_args[ 'fp_carousel_dots_visibility' ] : 'never',
		'mobile'  => array_key_exists( 'fp_carousel_dots_mobile_visibility', $sanfrancisco_args ) ? $sanfrancisco_args[ 'fp_carousel_dots_mobile_visibility' ] : 'never'
	)
);

if ( in_array( $sanfrancisco_fp_style, array( 'a', 'b' ) ) ) {
	$sanfrancisco_pagination = 'none';
	$sanfrancisco_args['posts_per_page'] = 3;
}

$sanfrancisco_wrap_class = array(
	'sf-entries-featured',
	sanitize_html_class( 'sf-entries-featured-'. $sanfrancisco_fp_style ),
	sanitize_html_class( 'sf-entry-body-'. $sanfrancisco_title_position ),
	sanitize_html_class( 'sf-eb-vb-'. $sanfrancisco_visibility['entry_body']['desktop'] ),
	sanitize_html_class( 'sf-eb-vb-touch-'. $sanfrancisco_visibility['entry_body']['mobile'] )
);

if ( $sanfrancisco_pagination == 'carousel' ) {

	$sanfrancisco_wrap_class[] = sanitize_html_class( 'sf-controls-vb-'. $sanfrancisco_visibility['carousel_buttons']['desktop'] );
	$sanfrancisco_wrap_class[] = sanitize_html_class( 'sf-controls-vb-touch-'. $sanfrancisco_visibility['carousel_buttons']['mobile'] );
	$sanfrancisco_wrap_class[] = sanitize_html_class( 'sf-dots-vb-'. $sanfrancisco_visibility['carousel_dots']['desktop'] );
	$sanfrancisco_wrap_class[] = sanitize_html_class( 'sf-dots-vb-touch-'. $sanfrancisco_visibility['carousel_dots']['mobile'] );
	$sanfrancisco_wrap_class[] = 'sf-carousel';

	switch ( $sanfrancisco_fp_style ) {
		case 'c':
			$sanfrancisco_carousel_items = 1;
			break;
		case 'd':
			$sanfrancisco_carousel_items = 2;
			break;
		case 'e':
			$sanfrancisco_carousel_items = 2;
			break;
		case 'f':
			$sanfrancisco_carousel_items = 3;
			break;
	}

}

$sanfrancisco_query = new WP_Query( sanfrancisco_get_post_query_args( $sanfrancisco_args ) );

echo '<div class="'. esc_attr( implode( ' ', $sanfrancisco_wrap_class ) ) .'">';

if ( $sanfrancisco_pagination == 'carousel' ) {

	$sanfrancisco_owl_responsive = '0:1,560:'. $sanfrancisco_carousel_items;
	if ( $sanfrancisco_fp_style == 'f' ) {
		$sanfrancisco_owl_responsive = '0:1,768:2,992:'. $sanfrancisco_carousel_items;
	}

	$sanfrancisco_autoplay = ( array_key_exists( 'fp_autoplay', $sanfrancisco_args ) ) ? $sanfrancisco_args['fp_autoplay'] : 'false';
	$sanfrancisco_autoplay_timeout = ( array_key_exists( 'fp_autoplay_timeout', $sanfrancisco_args ) ) ? $sanfrancisco_args['fp_autoplay_timeout'] : '5000';
	$sanfrancisco_autoplay_hover_pause = ( array_key_exists( 'fp_autoplay_hover_pause', $sanfrancisco_args ) ) ? $sanfrancisco_args['fp_autoplay_hover_pause'] : 'true';

	echo '<div class="owl-carousel" data-items="'. intval( $sanfrancisco_carousel_items ) .'" data-autoplay="'. esc_attr( $sanfrancisco_autoplay ) .'" data-autoplaytimeout="'. esc_attr( $sanfrancisco_autoplay_timeout ) .'" data-autoplayhoverpause="'. esc_attr( $sanfrancisco_autoplay_hover_pause ) .'" data-dots="true" data-loop="true" data-responsive="'. esc_attr( $sanfrancisco_owl_responsive ) .'" data-controls=".sf-carousel-controls">';

}

$sanfrancisco_counter = 1;
while ( $sanfrancisco_query->have_posts() ): $sanfrancisco_query->the_post();

	$sanfrancisco_gif_image_id = get_post_meta( get_the_ID(), 'sanfrancisco_gif_featured_image', true );
	$sanfrancisco_post_thumbnail_id = empty( $sanfrancisco_gif_image_id ) ? get_post_thumbnail_id( get_the_ID() ) : $sanfrancisco_gif_image_id;
	$sanfrancisco_post_title = get_the_title();

	if ( empty( $sanfrancisco_post_title ) ) {
		$sanfrancisco_post_title = esc_html__( '(no title)', 'sanfrancisco' );
	}

	/* entry classes */
	$sanfrancisco_entry_class = array(
		'sf-entry'
	);

	$sanfrancisco_thumbnail_size = 'sf-760-570';

	if ( in_array( $sanfrancisco_fp_style, array( 'a', 'b' ) ) ) {

		$sanfrancisco_lg_index = ( $sanfrancisco_fp_style == 'b' ) ? $sanfrancisco_query->post_count : 1;

		$sanfrancisco_entry_class[] = ( $sanfrancisco_counter == $sanfrancisco_lg_index ) ? 'sf-entry-lg' : 'sf-entry-md';

		if ( $sanfrancisco_section_layout == 'ws' ) {
			$sanfrancisco_thumbnail_size = ( $sanfrancisco_counter == $sanfrancisco_lg_index ) ? 'sf-570-570' : 'sf-380-285';
		} else {
			$sanfrancisco_thumbnail_size = ( $sanfrancisco_counter == $sanfrancisco_lg_index ) ? 'sf-760-570' : 'sf-380-285';
		}

	} else if ( $sanfrancisco_fp_style == 'c' ) {

		if ( $sanfrancisco_section_layout == 'ws' ) {
			$sanfrancisco_thumbnail_size = 'sf-750-655';
		} else if ( $sanfrancisco_section_layout == 'full' ) {
			$sanfrancisco_thumbnail_size = 'sf-1140-570';
		} else if ( $sanfrancisco_section_layout == 'widget' ) {
			$sanfrancisco_thumbnail_size = 'sf-380-570';
		}

	} else if ( $sanfrancisco_fp_style == 'd' ) {

		$sanfrancisco_thumbnail_size = 'sf-570-570';

	} else if ( $sanfrancisco_fp_style == 'e' ) {

		$sanfrancisco_thumbnail_size = ( $sanfrancisco_section_layout == 'ws' ) ? 'sf-570-570' : 'sf-570-285';

	}

	if ( ! empty( $sanfrancisco_gif_image_id ) ) {
		$sanfrancisco_thumbnail_size = 'full';
	}

	if ( ! empty( $sanfrancisco_post_thumbnail_id ) ) {
		$sanfrancisco_entry_class[] = 'sf-entry-has-featured-media';
	}

	$sanfrancisco_tag_limit = array_key_exists( 'tag_limit', $sanfrancisco_args ) ? intval( $sanfrancisco_args['tag_limit'] ) : 3;
	$sanfrancisco_post_tags = sanfrancisco_post_tags( null, $sanfrancisco_tag_limit, array( 'class' => 'sf-entry-tags sf-eb-item' ), false );
	$sanfrancisco_has_tags = ( ( ! array_key_exists( 'display_tags', $sanfrancisco_args ) || $sanfrancisco_args['display_tags'] != 'false' ) && ! empty( $sanfrancisco_post_tags ) );

	if ( $sanfrancisco_has_tags ) {
		$sanfrancisco_entry_class[] = 'sf-entry-has-tags';
	}

	$sanfrancisco_post_footer_items = array( 'views', 'likes', 'comments' );

	if ( $sanfrancisco_title_position == 'bottom' ) {
		$sanfrancisco_post_footer_items[] = 'category';
	}

?>
<article class="<?php echo esc_attr( implode( ' ', $sanfrancisco_entry_class ) ); ?>"<?php sanfrancisco_bg_srcset_attr( $sanfrancisco_post_thumbnail_id, $sanfrancisco_thumbnail_size ); ?>>

	<a href="<?php echo esc_url( get_the_permalink() ); ?>" class="sf-entry-body">

		<?php if ( sanfrancisco_post_is_trending() && in_array( 'trending_icon', $sanfrancisco_meta_data ) ): ?>
		<div class="sf-entry-flags">
			<span class="sf-entry-flag sf-entry-flag-trending"><i class="fa fa-bolt"></i></span>
		</div>
		<?php endif; ?>

		<?php if ( in_array( 'byline', $sanfrancisco_meta_data ) ): ?>
		<ul class="sf-entry-meta sf-eb-item">
			<li class="sf-entry-meta-byline">
				<?php sanfrancisco_byline( null, true, false ); ?>
			</li>
		</ul>
		<?php endif; ?>

		<?php if ( ! empty( $sanfrancisco_post_title ) ): ?>
		<div class="sf-entry-header sf-eb-item">
			<h3 class="sf-entry-title">
				<?php echo esc_html( $sanfrancisco_post_title ); ?>
			</h3>
		</div>
		<?php endif; ?>

		<?php if ( in_array( 'excerpt', $sanfrancisco_meta_data ) ): ?>
		<p class="sf-entry-excerpt sf-eb-item">
			<?php sanfrancisco_excerpt( null, $sanfrancisco_args['excerpt_length'] ); ?>
		</p>
		<?php endif; ?>

		<?php if ( $sanfrancisco_title_position == 'center' && in_array( 'category', $sanfrancisco_meta_data ) ): ?>
		<p class="sf-entry-category sf-eb-item">
			<?php sanfrancisco_post_categories( null, array(), true, 1, false ); ?>
		</p>
		<?php endif; ?>

		<?php

		$sanfrancisco_meta_data_int = array_intersect( $sanfrancisco_post_footer_items, $sanfrancisco_meta_data );

		if ( ! empty( $sanfrancisco_meta_data_int ) ): ?>
		<ul class="sf-entry-meta sf-eb-item clearfix">
			<?php if ( $sanfrancisco_title_position == 'bottom' && in_array( 'category', $sanfrancisco_meta_data ) ): ?>
				<li class="sf-entry-category">
					<?php sanfrancisco_post_categories( null, array(), true, 1, false, 'angle-right' ); ?>
				</li>
			<?php endif; if ( in_array( 'views', $sanfrancisco_meta_data ) ): ?>
				<li class="sf-entry-meta-views">
					<span class="fa fa-eye"></span> <span class="sf-count"><?php sanfrancisco_post_views(); ?></span>
				</li>
			<?php endif; if ( in_array( 'likes', $sanfrancisco_meta_data ) ): ?>
				<li class="sf-entry-meta-likes">
					<span class="fa fa-heart-o"></span> <span class="sf-count"><?php sanfrancisco_post_likes(); ?></span>
				</li>
			<?php endif; if ( in_array( 'comments', $sanfrancisco_meta_data ) ): ?>
				<li class="sf-entry-meta-comments">
					<span class="fa fa-comment-o"></span> <span class="sf-count"><?php sanfrancisco_post_comment_count(); ?></span>
				</li>
			<?php endif; ?>
		</ul>
		<?php endif; ?>

	</a>

</article>
<?php
$sanfrancisco_counter++;
endwhile;

if ( $sanfrancisco_pagination == 'carousel' ) {

	echo '</div><!-- .owl-carousel -->';

	?>
	<div class="sf-carousel-controls">
		<span class="sf-control"><span class="fa fa-angle-left"></span></span>
		<span class="sf-control"><span class="fa fa-angle-right"></span></span>
	</div>
	<?php

}

echo '</div><!-- .sf-entries-featured -->';

wp_reset_postdata();