<?php

if ( ! isset( $sanfrancisco_args ) ) {
	return;
}

$sanfrancisco_is_author_page = is_author();
$sanfrancisco_author_bio = get_the_author_meta( 'description', $sanfrancisco_args['author_id'] );

if ( empty( $sanfrancisco_author_bio ) ) {
	return;
}

$sanfrancisco_author_social = array(
	'facebook' => get_the_author_meta( 'mashsb_fb_author_url', $sanfrancisco_args[ 'author_id' ] ),
	'twitter'  => get_the_author_meta( 'mashsb_twitter_handle', $sanfrancisco_args[ 'author_id' ] ),
	'envelope' => get_the_author_meta( 'email', $sanfrancisco_args[ 'author_id' ] ),
	'globe'    => get_the_author_meta( 'url', $sanfrancisco_args[ 'author_id' ] )
);

if ( ! empty( $sanfrancisco_author_social['twitter'] ) ) {
	$sanfrancisco_author_social['twitter'] = 'https://twitter.com/'. $sanfrancisco_author_social['twitter'];
}

$sanfrancisco_author_job = get_the_author_meta( 'job', $sanfrancisco_args['author_id'] );

?>
<div class="sf-author-box" itemscope itemtype="https://schema.org/Person">
	<header class="sf-author-title">
		<h2 class="title">
			<?php
			if ( ! $sanfrancisco_is_author_page ) {
				echo '<a href="'. esc_url( get_author_posts_url( $sanfrancisco_args['author_id'] ) ) .'" rel="author">';
			}
			echo get_the_author_meta( 'display_name', $sanfrancisco_args['author_id'] );
			if ( ! $sanfrancisco_is_author_page ) {
				echo '</a>';
			}
			if ( ! empty( $sanfrancisco_author_job ) ) {
				echo '<small>('. esc_html( $sanfrancisco_author_job ) .')</small>';
			}
			?>
		</h2>
	</header>
	<figure class="sf-author-avatar">
		<?php
		if ( ! $sanfrancisco_is_author_page ) {
			echo '<a href="'. esc_url( get_author_posts_url( $sanfrancisco_args['author_id'] ) ) .'" rel="author">';
		}
		echo apply_filters( 'sanfrancisco_author_avatar', get_avatar( $sanfrancisco_args['author_id'], 120 ) );
		if ( ! $sanfrancisco_is_author_page ) {
			echo '</a>';
		}
		?>
	</figure>
	<div class="sf-author-bio" itemprop="description">
		<p><?php echo esc_html( $sanfrancisco_author_bio ); ?></p>
	</div>
	<div class="sf-author-social">
		<ul>
			<?php foreach ( $sanfrancisco_author_social as $k => $v ): if ( empty( $v ) ) { continue; } ?>
			<li><a href="<?php echo ( 'envelope' == $k ? 'mailto:' : '' ) . sanitize_email( $v ); ?>" target="_blank"><span class="fa fa-<?php echo sanitize_html_class( $k ); ?>" rel="nofollow"></span></a></li>
			<?php endforeach; ?>
		</ul>
	</div>
</div>