<?php

if ( ! isset( $sanfrancisco_args ) || ! is_array( $sanfrancisco_args ) ) {
	return;
}

foreach ( $sanfrancisco_args as $sanfrancisco_section ):

	do_action( 'sanfrancisco_before_section', $sanfrancisco_section );

	?>
	<div id="<?php echo esc_attr( sanfrancisco_section_id( $sanfrancisco_section ) ); ?>" class="<?php echo esc_attr( sanfrancisco_section_class( $sanfrancisco_section ) ); ?>">
		<div class="container">
			<?php

			$sanfrancisco_has_sidebar = ( $sanfrancisco_section['settings']['layout'] == 'ws' && $sanfrancisco_section['settings']['sidebar_position'] != 'none' );

			if ( $sanfrancisco_has_sidebar ) {

				echo '<aside class="'. esc_attr( sanfrancisco_sidebar_class() ) .'"><div class="sf-sidebar-wrapper">';

				dynamic_sidebar( $sanfrancisco_section['settings']['sidebar'] );

				echo '</div></aside><div class="sf-main" role="main">';

			}

			do_action( 'sanfrancisco_before_main', $sanfrancisco_section );

			$sanfrancisco_template_vars = sanfrancisco_load_template( array(
				'template' => 'module',
				'prefix'   => 'loop',
				'args'     => $sanfrancisco_section
			) );

			do_action( 'sanfrancisco_after_main', $sanfrancisco_section, $sanfrancisco_template_vars );

			echo ( true == $sanfrancisco_has_sidebar ) ? '</div>' : '';

			?>
		</div>
	</div>
	<?php

	do_action( 'sanfrancisco_after_section', $sanfrancisco_section, $sanfrancisco_template_vars );

endforeach;