<?php

if ( ! isset( $sanfrancisco_args ) ) {
	return;
}

if ( array_key_exists( 'modules', $sanfrancisco_args ) && is_array( $sanfrancisco_args['modules'] ) ):

	foreach ( $sanfrancisco_args['modules'] as $sanfrancisco_module ):

		$sanfrancisco_module['section_layout'] = $sanfrancisco_args['settings']['layout'];

		do_action( 'sanfrancisco_before_module', $sanfrancisco_module );

		?>
		<div id="<?php echo esc_attr( sanfrancisco_module_id( $sanfrancisco_module ) ); ?>" class="<?php echo esc_attr( sanfrancisco_module_class( $sanfrancisco_module ) ); ?>">
			<?php

			do_action( 'sanfrancisco_start_module', $sanfrancisco_module );

			$sanfrancisco_template_vars = sanfrancisco_load_template( array(
				'template' => $sanfrancisco_module['layout'],
				'args'     => $sanfrancisco_module
			) );

			do_action( 'sanfrancisco_end_module', $sanfrancisco_module, $sanfrancisco_template_vars );

			?>
		</div>
		<?php

		do_action( 'sanfrancisco_after_module', $sanfrancisco_module, $sanfrancisco_template_vars );

	endforeach;

endif;