var objectValues = function( obj ) {

    var arr = [],
        o;

    for(o in obj) {
        arr.push(obj[o]);
    }

    return arr;

};

window.jQuery(document).ready(function($) {

    $.fn.select2.defaults.set("width", "100%");

    /*
     * definitions & helper function
     */
    var _el = {
            root: $('html, body'),
            body: $('body'),
            modal: $('.mco-modal')
        },
        pb_id = $('#mco_pb_id').val() || 'mco_to',
        _i18n = ( typeof window.mcoI18nLocale != 'undefined' ) ? window.mcoI18nLocale : {},
        _guid = function() {

            var s4 = function() {
                return Math.floor((1 + Math.random()) * 0x10000)
                    .toString(16)
                    .substring(1);
            };

            return s4() + s4() + '-' + s4();

        },
        _ajax = function(data, callback, dataType) {

            if (typeof data != 'object' || ! data.action) {
                return;
            }

            if (!dataType) {
                dataType = 'json';
            }

            var p = {
                type: 'post',
                dataType: dataType,
                url: window.ajaxurl,
                data: data
            }, el_post_id = $('#post_ID');

            if (el_post_id.length) {
                data.post_id = el_post_id.val();
            }

            if (typeof callback == 'function') {
                p.success = callback;
            }

            $.ajax(p);

        },
        unset_data_changed = function() {
            $(window).unbind('beforeunload.'+pb_id);
        },
        set_data_changed = function() {
            $(window).bind('beforeunload.'+pb_id, function (e) {
                return _i18n.confirm_to_leave;
            });
            alert_msg(_i18n.changes_unsaved, 'warning');
        },
        fonts_map = _i18n.fonts_map,
        s2_font_family = [],
        s2_backup_font_family = [],
        z = ['standard', 'google'],
        i,j,k;

    for (i in z) {

        i = z[i];

        if ( ! fonts_map.hasOwnProperty(i) ) {
            continue;
        }

        k = {
            text: fonts_map[i].text,
            children: []
        };

        for (j in fonts_map[i].children) {
            if(i == 'standard') {
                j = fonts_map[i].children[j];
            }
            k.children.push({id:j, text: j});
        }

        s2_font_family.push(k);

        if ( i == 'standard' ) {
            s2_backup_font_family = k.children;
        }

    }

    var update_form_elements = function(container) {

            /*
             * form element: colorpicker
             */
            container.find('.mco-form-colorpicker .mco-form-control').each(function() {

                var t = this,
                    is_set = $(t).hasClass('mco-colorpicker-set');

                if(is_set) {
                    return;
                }

                $(t).spectrum({
                    color: $(t).val(),
                    showAlpha: true,
                    showInput: true,
                    clickoutFiresChange: true,
                    change: function(color) {
                        var c = color.toRgbString();
                        $(t).val(c);
                        ev_form_change.call(t, c);
                    }
                });

                $(t).addClass('mco-colorpicker-set');

            });

            /*
             * form element: range
             */
            container.find('.mco-form-range .mco-slider').each(function() {

                var t = this,
                    to,
                    d = {
                        min: 0,
                        max: 100,
                        step: 1,
                        value: 0,
                        disabled: false,
                        slide: function(e, ui) {
                            if(typeof to != 'undefined') {
                                clearTimeout(to);
                            }
                            $(t).parent().find('.mco-form-control').val(ui.value);
                            to = setTimeout(function() {
                                ev_form_change.call(t, ui.value);
                            }, 400);
                        }
                    },
                    i;

                for(i in d) {
                    if(typeof $(t).data(i) != 'undefined') {
                        d[i] = $(t).data(i);
                    }
                }

                $(t).slider(d);

            });

            /*
             * form element: checker
             */
            container.find('.mco-form-checker').each(function() {

                var pt = $(this),
                    lastChecked = null;

                $(this).find('.mco-form-control').on('change', function(e) {

                    var checked = [];
                    pt.find('.mco-form-control').each(function() {
                        var ct = $(this);
                        if(ct.prop('checked')) {
                            checked.push(ct.val());
                        }
                    });

                    ev_form_change.call(this, checked);

                });

                $(this).find('li > label').on('click', function(e) {

                    var t = $(this).find('.mco-form-control');

                    if (!lastChecked) {
                        lastChecked = t;
                        return;
                    }

                    if (e.shiftKey) {

                        var curStart = t.parents('li').index(),
                            curEnd = lastChecked.parents('li').index(),
                            startIndex = Math.min(curStart, curEnd),
                            endIndex = Math.max(curStart, curEnd) + 1,
                            i;

                        for(i=startIndex; i<endIndex; i++) {
                            if(t.parents('li').index() != i) {
                                pt.find('li').eq(i).find('.mco-form-control').prop('checked', lastChecked.prop('checked'));
                            }
                        }
                    }

                    lastChecked = t;

                });

            });

            /*
             * form element: sidebar_create
             */
            container.find('.mco-form-sidebar-create').each(function() {

                var t = $(this),
                    w = t.find('.mco-wrap'),
                    form_name = w.data('name'),
                    form_max_id = w.data('max-id'),
                    form_placeholder = w.data('placeholder'),
                    item_remove = function(e) {
                        e.preventDefault();
                        if( confirm(_i18n['press_ok_to_delete_sidebar']) !== true) {
                            return;
                        }
                        $(this).parents('.mco-item-block').remove();
                        ev_form_change.call(this);
                    };

                if (typeof form_max_id == 'undefined') {
                    form_max_id = 0;
                }

                t.find('.mco-btn-remove').on('click', item_remove);

                t.find('.mco-btn-new').on('click', function(e) {

                    e.preventDefault();

                    var el_item = $('<div>').addClass('mco-item-block'),
                        el_input = $('<input>').attr({
                            type: 'text',
                            autocomplete: 'off',
                            placeholder: form_placeholder,
                            name: form_name +'['+ (form_max_id + 1) +']'
                        }).addClass('mco-form-control'),
                        el_btn = $('<button>').addClass('mco-btn mco-btn-red mco-btn-remove').append($('<span>').addClass('fa fa-trash'));

                    form_max_id++;

                    el_btn.click(item_remove);

                    $(this).before(el_item.append(el_input).append(' ').append(el_btn));

                    el_input.focus();

                    ev_form_change.call(this);

                });


            });

            /*
             * form element: font (font family choice)
             */
            container.find('.mco-typo-font-family').each(function() {

                var t = $(this),
                    el_select = t.find('.mco-form-control'),
                    val = el_select.data('value') || '',
                    ev_select = function(e, type) {

                        var t = $(this),
                            d = e.params.data,
                            is_google_font = fonts_map.google.children.hasOwnProperty(d.id),
                            el_parent = t.parents('.mco-group-wrap'),
                            el_backup_font = el_parent.find('.mco-typo-backup-font-family'),
                            el_font_subsets = el_parent.find('.mco-typo-font-subsets'),
                            el_font_weight = el_parent.find('.mco-typo-font-weight-style'),
                            font_variants;

                        if (is_google_font) {

                            font_variants = fonts_map.google.children[d.id].variants;

                            el_backup_font.show();

                            el_font_subsets.show().find('.mco-form-control').html('').select2({
                                data: fonts_map.google.children[d.id].subsets
                            });

                        } else {

                            font_variants = fonts_map.standard.variants;

                            el_backup_font.hide();
                            el_font_subsets.hide();

                        }

                        el_font_weight.find('.mco-form-control').html('').select2({
                            data: font_variants
                        });

                        if(type != 'init') {
                            ev_form_change.call(this);
                        }

                    };

                ev_select.call(this, {
                    params: {
                        data: {
                            id: val
                        }
                    }
                }, 'init');

                el_select.select2({
                    data: s2_font_family
                }).on('select2:select', ev_select).val(val).trigger('change');

            });

            /*
             * form element: font (backup font family choice)
             */
            container.find('.mco-typo-backup-font-family').each(function() {

                var t = $(this),
                    el_select = t.find('.mco-form-control'),
                    val = el_select.data('value') || '';

                el_select.select2({
                    data: s2_backup_font_family
                }).on('select2:select', function() {
                    ev_form_change.call(this);
                }).val(val).trigger('change');

            });

            /*
             * form element: font (font subset choice)
             */
            container.find('.mco-typo-font-subsets').each(function() {

                var t = $(this),
                    el_select = t.find('.mco-form-control'),
                    val = el_select.data('value') || '';

                el_select.select2().on('select2:select', function() {
                    ev_form_change.call(this);
                }).val(val).trigger('change');

            });

            /*
             * form element: font (font weight & style choice)
             */
            container.find('.mco-typo-font-weight-style').each(function() {

                var t = $(this),
                    el_select = t.find('.mco-form-control'),
                    val = el_select.data('value') || '';

                el_select.select2({
                    data: fonts_map.standard.variants
                }).on('select2:select', function() {
                    ev_form_change.call(this);
                }).val(val).trigger('change');

            });

            /*
             * form element: code
             */
            container.find('.mco-code-editor').each(function() {

                var t = this,
                    id = $(t).attr('id'),
                    name = $(t).data('name'),
                    mode = $(t).data('mode'),
                    theme = $(t).data('theme'),
                    el_holder = $(t).siblings('textarea[name="'+name+'"]');

                if(!el_holder.length) {
                    el_holder = $('<textarea>').attr({name:name}).addClass('mco-form-control').hide();
                    $(t).before(el_holder);
                }

                var ace_editor = ace.edit(id);
                ace_editor.setTheme('ace/theme/'+ theme);
                ace_editor.getSession().setMode('ace/mode/'+ mode);

                ace_editor.on('change', function(ev, editor) {
                    var v = editor.getValue();
                    el_holder.text(v);
                    ev_form_change.call(t, v);
                });

            });

            /*
             * fix wp_editor on ajax call
             */
            container.find('.mco-form-wp-editor').each(function() {

                var t = $(this),
                    p = t.parents('.mco-form-block'),
                    p_is_hidden = p.hasClass('mco-hide'),
                    id = t.find('.wp-editor-area').attr('id'),
                    preloaded_wp_editor_id = 'mco_preloaded_editor_id';

                if ( typeof id == 'undefined'
                    || typeof quicktags == 'undefined'
                    || typeof tinyMCEPreInit != 'object'
                    || typeof tinyMCEPreInit.mceInit != 'object'
                    || ! tinyMCEPreInit.mceInit.hasOwnProperty(preloaded_wp_editor_id) ) {
                    return;
                }

                p.removeClass('mco-hide');

                var mceinit_params = jQuery.extend(true, {}, tinyMCEPreInit.mceInit[preloaded_wp_editor_id]);

                mceinit_params.selector = '#'+id;
                mceinit_params.resize = true;
                mceinit_params.toolbar1 = mceinit_params.toolbar1.replace( /(fullscreen)/g, '' );
                mceinit_params.toolbar2 = mceinit_params.toolbar2.replace( /(wp_help)/g, '' );

                if (mceinit_params.hasOwnProperty('body_class')) {
                    mceinit_params.body_class = mceinit_params.body_class.replace(preloaded_wp_editor_id, id);
                }

                tinyMCE.init(mceinit_params);
                tinyMCE.execCommand('mceAddEditor', false, id);
                quicktags({id : id});

                if (p_is_hidden) {
                    p.addClass('mco-hide');
                }

            });

            /*
             * Make sections sortable
             */
            container.find('.mco-section-wrapper').sortable({
                placeholder: 'mco-section-placeholder',
                items: '> .mco-section',
                handle: ".mco-section-header",
                start: function(e, ui) {
                    ui.placeholder.height(ui.item.height()-4);
                }
            });

            /*
             * Make section modules sortable
             */
            container.find('.mco-section-modules').sortable({
                placeholder: 'mco-module-placeholder',
                items: '> .mco-module',
                start: function(e, ui) {
                    ui.placeholder.height(ui.item.height()-4);
                }
            });

            /*
             * Make gallery images sortable
             */
            container.find('.mco-form-gallery .mco-preview').sortable({
                placeholder: 'mco-gallery-image-placeholder',
                items: '> .mco-gallery-image',
                start: function(e, ui) {
                    ui.placeholder.height(ui.item.height()-6);
                    ui.placeholder.width(ui.item.width()-6);
                },
                update: function(e, ui) {
                    var t = $(this),
                        form_name = t.parents('.mco-wrap').data('name'),
                        c = 0;
                    if(typeof form_name != 'undefined') {
                        t.find('.mco-gallery-image').each(function() {
                            $(this).find('.mco-form-control').attr('name', form_name +'['+ c +']').data('id', c);
                            c++;
                        });
                    }
                }
            });

            return container;

        },
        get_form_data = function(container) {

            var form_data = {},
                i;

            container.find('.mco-form-block').each(function() {

                var t = $(this),
                    id = t.data('id'),
                    type = t.data('type'),
                    fc = t.find('.mco-form-control');

                if ( fc.length == 0 ) {
                    return;
                }

                form_data[id] = {};

                if ( fc.length > 1 ) {

                    fc.each(function() {
                        var it = $(this),
                            i = it.data('id');
                        if(typeof i != 'undefined') {
                            if(type != 'checker' || it.prop('checked')) {
                                form_data[id][i] = it.val();
                            }
                        }
                    });

                } else if ( fc.length == 1 ) {
                    form_data[id] = fc.val();
                    if ( type == 'wp_editor' ) {
                        var ed = tinyMCE.editors[ fc.attr('id') ];
                        if(typeof ed != 'undefined') {
                            form_data[id] = ed.getContent();
                        }
                    }
                }

            });

            return form_data;

        },
        ev_form_change = function( value ) {

            set_data_changed();

            var el = $(this),
                el_form_block = el.parents('.mco-form-block');

            if (!el_form_block.length) {
                return;
            }

            var id = el_form_block.data('id');

            if (typeof id == 'undefined') {
                return;
            }

            var el_container = el.parents('.mco-container');

            if ( el.parents('.widget-content').length ) {
                el_container = el.parents('.widget-content');
            } else if ( el.parents('form#edittag').length ) {
                el_container = el.parents('form#edittag');
            } else if ( el.parents('form#addtag').length ) {
                el_container = el.parents('form#addtag');
            }

            var form_data = get_form_data(el_container);

            el_container.find('[data-condition]').each(function() {

                var t = $(this),
                    condition = t.data('condition'),
                    operator = t.data('operator');

                if (typeof condition == 'undefined') {
                    return;
                }

                if (typeof operator == 'undefined' || ['and','or'].indexOf(operator) == -1) {
                    operator = 'and';
                }

                var bool_arr = [],
                    cond_arr = condition.split('),'),
                    i;

                for(i in cond_arr) {

                    if (cond_arr[i].slice(-1) != ')') {
                        cond_arr[i] += ')';
                    }

                    var m = cond_arr[i].match(/^([a-z0-9_]+)\:(not|is|has|has_not|in|not_in)\(([a-z0-9_\,]+)\)$/i),
                        m_bool = false;

                    if (m != null) {

                        var m_id = m[1],
                            m_op = m[2],
                            m_val = m[3];

                        if (!form_data.hasOwnProperty(m_id)) {
                            form_data[m_id] = '';
                        }

                        if (['is','not'].indexOf(m_op) != -1) {

                            m_bool = ( form_data[m_id] == m_val );

                            if (m_op == 'not') {
                                m_bool = !m_bool;
                            }

                        } else if (['has','has_not'].indexOf(m_op) != -1) {

                            if (typeof form_data[m_id] == 'string') {
                                form_data[m_id] = form_data[m_id].split(',');
                            } else if (typeof form_data[m_id] != 'object') {
                                form_data[m_id] = [];
                            } else if ( ! ( form_data[m_id] instanceof Array ) ) {
                                form_data[m_id] = objectValues(form_data[m_id]);
                            }

                            m_val = m_val.split(',');

                            var j, k = [];
                            for(j in m_val) {
                                k.push(form_data[m_id].indexOf(m_val[j]) != -1);
                            }

                            m_bool = (k.indexOf(false) == -1);

                            if (m_op == 'has_not') {
                                m_bool = !m_bool;
                            }

                        } else if (['in','not_in'].indexOf(m_op) != -1) {

                            m_val = m_val.split(',');

                            m_bool = (m_val.indexOf(form_data[m_id]) != -1);

                            if (m_op == 'not_in') {
                                m_bool = !m_bool;
                            }

                        }

                    }

                    bool_arr.push(m_bool);

                }

                var is_hidden = false;
                if (operator == 'or') {
                    is_hidden = (bool_arr.indexOf(true) == -1);
                } else {
                    is_hidden = (bool_arr.indexOf(false) != -1);
                }

                if (is_hidden) {

                    if ( t.hasClass('mco-form-block') ) {
                        t.animate({opacity: 'hide', height: 'hide'}, 200, function () {
                            t.addClass('hide');
                        });
                    } else {
                        t.addClass('hide');
                    }

                } else {

                    if ( t.hasClass('mco-form-block') ) {
                        t.animate({opacity: 'show', height: 'show'}, 200, function () {
                            t.removeClass('hide');
                        });
                    } else {
                        t.removeClass('hide');
                    }

                }

            });

        },
        alert_msg = function(text, type) {

            if(typeof type == 'undefined') {
                type = 'success';
            }

            var p = $('.mco-settings-nav'),
                el = p.siblings('.mco-alert-msg'),
                el_anim = false;

            if(!el.length) {
                el = $('<div>');
                p.after(el.hide());
                el_anim = true;
            }

            el.html('').attr('class', 'mco-alert-msg mco-alert-'+type);

            if(type == 'success') {
                el.append($('<span>').addClass('fa fa-check mco-alert-icon'));
            } else if(type == 'warning') {
                el.append($('<span>').addClass('fa fa-warning mco-alert-icon'));
            }

            el.append(text).append($('<span>').addClass('fa fa-times mco-alert-close'));

            if(el_anim) {
                el.animate({opacity: 'show' , height: 'show'}, 200);
            }

        },
        get_pb_item_title = function(container) {

            var form_data = get_form_data(container),
                html = '';

            if(form_data.hasOwnProperty('title'))
                html += '<span class="name">'+ form_data.title +'</span>';
            if(form_data.hasOwnProperty('layout'))
                html += '<span class="subline">'+ form_data.layout +'</span>';

            return html;

        };

    /*
     * spectrum input focus issue on click
     */
    _el.body.on('focus', '.sp-container .sp-input', function(e) {
        e.stopPropagation();
    });

    /*
     * update theme options active section when navigate
     */
    _el.body.on('click', '.mco-nav-tabs ul a', function(e) {

        e.preventDefault();

        var t = $(this),
            el_to_form = $('#mco-theme-options-form'),
            id = t.attr('aria-controls'),
            section_active_tab = t.data('active-tab');

        el_to_form.find('input[name="active_section"]').val(id);
        el_to_form.find('input[name="active_tab"]').val(section_active_tab);

    });

    /*
     * update theme options active tab when navigate
     */
    _el.body.on('click', '.mco-panel-nav-tabs ul a', function(e) {

        e.preventDefault();

        var t = $(this),
            el_to_form = $('#mco-theme-options-form'),
            id = t.data('id'),
            section = t.data('section');

        el_to_form.find('input[name="active_tab"]').val(id);
        el_to_form.find('.mco-nav-tab-'+section+' a').data('active-tab', id);

    });

    /*
     * save/reset theme options
     */
    _el.body.on('click', '.mco-btn-submit-to', function(e) {

        e.preventDefault();

        var t = $(this),
            el_to = $('.mco-theme-options'),
            el_to_form = $('#mco-theme-options-form'),
            success_msg = t.data('success-msg'),
            btn_action = t.data('action'),
            btn_type = t.data('type'),
            form_data = {},
            i, n;

        if(btn_action == 'reset' && confirm(_i18n['confirm_reset_'+btn_type]) !== true) {
            return;
        }

        el_to.children('.mco-loader').addClass('in');

        var form_data_arr = el_to_form.serializeArray();
        for(i in form_data_arr) {
            n = form_data_arr[i].name;
            if(typeof n == 'undefined') {
                continue;
            }
            form_data[n] = form_data_arr[i].value;
        }

        form_data['action'] = btn_action +'_theme_options';
        if(btn_action == 'reset') {
            form_data['reset_type'] = btn_type;
        }

        _ajax(form_data, function(res) {

            el_to.children('.mco-loader').removeClass('in');

            if ( res != '' ) {
                var wrap = $('#mco-theme-options-wrapper');
                wrap.html(res);
                update_form_elements(wrap);
            }

            alert_msg(success_msg);

            unset_data_changed();

        }, 'html');

    });

    /*
     * close alert message
     */
    _el.body.on('click', '.mco-alert-close', function(e) {

        e.preventDefault();

        var p = $(this).parents('.mco-alert-msg');

        p.remove();

    });

    /*
     * save section/module
     */
    _el.body.on('click', '.mco-pb-modal .mco-btn-save', function(e) {

        e.preventDefault();

        var el_modal = $(this).parents('.mco-pb-modal'),
            modal_type = el_modal.data('type'),
            section_uid = el_modal.data('section-uid'),
            module_uid = el_modal.data('module-uid'),
            form_data = get_form_data(el_modal),
            item_title = get_pb_item_title(el_modal);

        if (modal_type == 'module' && typeof section_uid == 'undefined') {
            return;
        }

        if ( typeof section_uid == 'undefined' ) {
            section_uid = _guid();
        }

        if (modal_type == 'module' && typeof module_uid == 'undefined') {
            module_uid = _guid();
        }

        var item_uid = modal_type == 'module' ? module_uid : section_uid,
            el_item = $('.mco-'+ modal_type +'-'+ item_uid),
            el_item_container = modal_type == 'module' ? $('.mco-section-'+ section_uid +' ul.mco-section-modules') : $('.mco-pb .mco-section-wrapper');

        if (modal_type == 'section' && !el_item_container.length) {
            el_item_container = $('<div>').addClass('mco-section-wrapper');
            $('.mco-pb').append(el_item_container);
        }

        if (!el_item.length) {

            if (modal_type == 'module') {

                el_item = {
                    wrapper: $('<li>').addClass('mco-module mco-module-'+ module_uid),
                    header: $('<div>').addClass('mco-module-header').append($('<h3>').addClass('mco-title').append($('<span>').addClass('fa fa-angle-double-right')).append($('<span>').addClass('title'))),
                    actions: $('<ul>').addClass('mco-module-settings').append($('<li>').append($('<button>').attr('type','button').addClass('mco-btn btn-pb-edit').data({'type':'module', 'section-uid': section_uid, 'module-uid': module_uid}).append($('<span>').addClass('fa fa-edit')).append(_i18n.edit_module))).append($('<li>').append($('<button>').attr('type','button').addClass('mco-btn btn-pb-remove').data({'type':'module', 'section-uid': section_uid, 'module-uid': module_uid}).append($('<span>').addClass('fa fa-times')).append(_i18n.remove_module)))
                };

                el_item = el_item.wrapper.append(el_item.header).append(el_item.actions);

            } else {

                el_item = {
                    wrapper: $('<div>').addClass('mco-section mco-section-'+ section_uid),
                    header: $('<div>').addClass('mco-section-header clearfix'),
                    title: $('<h2>').addClass('mco-title').append($('<span>').addClass('fa fa-bars')).append($('<span>').addClass('title')),
                    actions: $('<ul>').addClass('mco-section-settings').append($('<li>').append($('<button>').attr('type','button').addClass('mco-btn btn-pb-edit').data({'type':'section', 'section-uid': section_uid}).append($('<span>').addClass('fa fa-edit')))).append($('<li>').append($('<button>').attr('type','button').addClass('mco-btn btn-pb-remove').data({'type':'section', 'section-uid': section_uid}).append($('<span>').addClass('fa fa-times')))),
                    body: $('<div>').addClass('mco-section-body'),
                    items: $('<ul>').addClass('mco-section-modules'),
                    item_btn: $('<div>').addClass('mco-btn-wrapper').append($('<button>').attr('type','button').addClass('mco-btn mco-btn-red mco-btn-add btn-pb-edit').data({'type':'module', 'section-uid': section_uid}).append($('<span>').addClass('fa fa-plus')).append(_i18n.add_new_module))
                };

                el_item = el_item.wrapper
                    .append(el_item.header.append(el_item.title).append(el_item.actions))
                    .append(el_item.body.append(el_item.items).append(el_item.item_btn));

            }

            el_item_container.append(el_item);

        }

        el_item.find('.mco-'+ modal_type +'-header .mco-title .title').html(item_title);

        var form_data_string = JSON.stringify(form_data),
            inp_name = modal_type == 'module' ? pb_id +'['+ section_uid +'][modules]['+ module_uid +']' : pb_id +'['+ section_uid +'][settings]',
            el_inp = el_item.find('input[name="'+ inp_name +'"]');

        if (!el_inp.length) {
            el_inp = $('<input>').attr({id: 'mco-'+ modal_type +'-'+ item_uid +'-values', type:'hidden', name: inp_name});
            el_item.append(el_inp);
        }

        el_inp.val(form_data_string);

        el_modal.modal('hide');

        set_data_changed();
        update_form_elements(el_item_container);

    });

    /*
     * remove section or module
     */
    _el.body.on('click', '.btn-pb-remove', function(e) {

        e.preventDefault();

        var t = $(this),
            type = t.data('type'),
            item_uid = type == 'module' ? t.data('module-uid') : t.data('section-uid'),
            el_item = $('.mco-'+type+'-'+item_uid);

        if( confirm(_i18n['press_ok_to_delete_'+type]) !== true) {
            return;
        }

        el_item.remove();

        set_data_changed();

    });

    /*
     * edit section or module
     */
    _el.body.on('click', '.btn-pb-edit', function(e) {

        e.preventDefault();

        var t = $(this),
            type = t.data('type'),
            section_uid = t.data('section-uid'),
            module_uid;

        if (typeof type == 'undefined') {
            return;
        } else if (type == 'module') {
            module_uid = t.data('module-uid');
        }

        var el_modal = $('.mco-pb-modal'),
            el_content = el_modal.find('.mco-modal-body').html('Loading...'), // @todo: add loader icon
            modal_title = _i18n['new_'+type],
            ajax_data = {
                action: 'edit_'+ type
            };

        if ((type == 'section' && typeof section_uid != 'undefined') || (type == 'module' && typeof module_uid != 'undefined')) {

            var key = 'mco-'+ type +'-'+ (type == 'module' ? module_uid : section_uid),
                el_item = $('.'+ key);

            modal_title = _i18n[type+'_settings'];

            if (el_item.length) {

                ajax_data.values = {};
                var v = JSON.parse( el_item.find('input[type=hidden]#'+ key +'-values').val() ),
                    av,
                    i;

                for(i in v) {
                    if(v.hasOwnProperty(i)) {
                        av = ( typeof v[i] == 'object' && v[i] != null && v[i].hasOwnProperty('value') ) ? v[i].value : v[i];
                        if (av instanceof Array && av.length == 0) {
                            av = '';
                        }
                        ajax_data.values[i] = av;
                    }
                }

            }

        }

        el_modal.data({
            'type': type,
            'section-uid': section_uid
        });

        if (type == 'module') {
            el_modal.data('module-uid', module_uid);
        }

        el_modal.find('.mco-modal-title').text(modal_title);

        el_modal.modal({
            backdrop: 'static',
            keyboard: false
        });

        _ajax(ajax_data, function(r) {
            update_form_elements(el_content.html(r));
        }, 'html');

        mcoUpdateElements('init');

    });

    /*
     * form element: select, text, textarea
     */
    _el.body.on('change', '.mco-form-select .mco-form-control,' +
        '.mco-form-text .mco-form-control,' +
        '.mco-form-textarea .mco-form-control', function() {

        ev_form_change.call(this, $(this).val());

    });

    /*
     * form element: range
     */
    _el.body.on('change', '.mco-form-range .mco-form-control', function() {

        var t = $(this),
            el_slider = t.parent().siblings('.mco-slider'),
            val = parseInt(t.val());

        el_slider.slider('value', val);

        ev_form_change.call(this, val);

    });

    /*
     * form element: toggle
     */
    _el.body.on('click', '.mco-form-toggle .mco-wrap', function(e) {

        e.preventDefault();

        var t = $(this),
            c = t.hasClass('on') ? ['on','off'] : ['off','on'],
            v = c[1] == 'on' ? 'true' : 'false';

        t.removeClass(c[0]).addClass(c[1]).find('.mco-form-control').val(v);

        ev_form_change.call(this, v);

    });

    /*
     * form element: media (upload button)
     */
    _el.body.on('click', '.mco-form-media .mco-btn-upload', function(e) {

        e.preventDefault();

        var t = this,
            p = $(t).parents('.mco-wrap'),
            type = p.data('type'),
            el_preview = p.siblings('.mco-preview'),
            el_url = $(t).siblings('.mco-url'),
            el_id = $(t).siblings('.mco-form-control');

        if (!el_preview.length) {
            el_preview = $('<div>').addClass('mco-preview').hide();
            p.after(el_preview);
        }

        if(typeof type == 'undefined') {
            type = 'image';
        }

        var frame = wp.media({
            title: _i18n['select_or_upload_'+ type],
            button: {
                text: _i18n['use_this_'+ type]
            },
            multiple: false
        });

        frame.on( 'select', function() {

            // Get media attachment details from the frame state
            var attachment = frame.state().get('selection').first().toJSON();

            el_url.val(attachment.url);
            el_id.val(attachment.id);

            if(type == 'image') {
                el_preview.html($('<img>').attr({src: attachment.url})).show();
            }

            ev_form_change.call(t, attachment.id);

        }).on( 'close', function() {

            if ( ! _el.modal.is(':hidden') ) {
                _el.body.addClass('modal-open');
            }

        }).open();

    });

    /*
     * form element: media (clear button)
     */
    _el.body.on('click', '.mco-form-media .mco-btn-clear', function(e) {

        e.preventDefault();

        $(this).siblings('.mco-url').val('').siblings('.mco-form-control').val('').parent().siblings('.mco-preview').remove();

        ev_form_change.call(this, '');

    });

    /*
     * form element: gallery (add images button)
     */
    _el.body.on('click', '.mco-form-gallery .mco-btn-upload', function(e) {

        e.preventDefault();

        var t = $(this),
            el_preview = t.siblings('.mco-preview'),
            form_name = t.parents('.mco-wrap').data('name');

        if(typeof form_name == 'undefined') {
            return;
        }

        if (!el_preview.length) {
            el_preview = $('<ul>').addClass('mco-preview').hide();
            t.before(el_preview);
        }

        var image_count = el_preview.find('.mco-gallery-image').length,
            frame = wp.media({
                title: _i18n['select_or_upload_images'],
                button: {
                    text: _i18n['use_this_images']
                },
                multiple: true
            });

        frame.on( 'select', function() {

            // Get media attachment details from the frame state
            var attachments = frame.state().get('selection').toJSON(),
                i;

            for(i in attachments) {

                var li = $('<li>').addClass('mco-gallery-image').html('<span class="mco-btn-remove"><i class="fa fa-times"></i></span>'),
                    img = $('<img>').attr({src: attachments[i].sizes.thumbnail.url}),
                    inp = $('<input>').attr({
                        type: 'hidden',
                        name: form_name +'['+ image_count +']',
                        value: attachments[i].id
                    }).addClass('mco-form-control').data('id', image_count);

                el_preview.append(li.append(img).append(inp)).show();

                image_count++;

            }

            update_form_elements(t.parents('.mco-form-wrapper'));
            ev_form_change.call(t, attachments);

        }).on( 'close', function() {

            if ( ! _el.modal.is(':hidden') ) {
                _el.body.addClass('modal-open');
            }

        }).open();

    });

    /*
     * form element: gallery (remove image button)
     */
    _el.body.on('click', '.mco-form-gallery .mco-btn-remove', function(e) {

        e.preventDefault();

        var t = $(this).parents('.mco-gallery-image'),
            p = t.parents('.mco-preview'),
            form_name = p.parents('.mco-wrap').data('name'),
            c = 0;

        if(typeof form_name == 'undefined') {
            return;
        }

        t.remove();

        p.find('.mco-gallery-image').each(function() {
            $(this).find('.mco-form-control').attr('name', form_name +'['+ c +']').data('id', c);
            c++;
        });

    });

    /*
     * form element: radio_select
     */
    _el.body.on('click', '.mco-form-radio-select li', function(e) {

        e.preventDefault();

        var t = $(this),
            v = t.data('value'),
            c = 'active';

        if(typeof v == 'undefined') {
           return;
        }

        t.addClass(c).siblings('li').removeClass(c);

        t.parents('ul').siblings('.mco-form-control').val(v);

        ev_form_change.call(this, v);

    });

    /*
     * modal hide event
     */
    _el.modal.on('hide.bs.modal', function() {
        $(this).removeData('type').removeData('section-uid').removeData('module-uid');
    });

    /*
     * Toggle meta boxes by post format
     */
    _el.body.on('change', 'input[name="post_format"]', function() {
        var v = $(this).val();
        if ( v == '0' ) {
            v = 'standard';
        }
        $('.postbox.cond-post-format').addClass('mco-hide');
        $('.postbox.visible-post-format-'+ v).removeClass('mco-hide');
    });

    /*
     * Toggle meta boxes by page template
     */
    _el.body.on('change', 'select#page_template', function() {
        var v = $(this).val();
        v = v.replace(/[.\_\s]+/g, '-');
        $('.postbox.cond-page-template').addClass('mco-hide');
        $('.postbox.visible-page-template-'+ v).removeClass('mco-hide');
    });

    /*
     * Fire unbind event on post, term & widget save
     */
    $('#post, #addtag, #edittag').on('submit', function() {
        unset_data_changed();
    });

    /*
     * Fire unbind event on widget save
     */
    _el.body.on('click', 'input[name="savewidget"]', function() {
        unset_data_changed();
    });

    /*
     * Update widget form elements on widget save
     */
    $(document).ajaxSuccess(function(e, xhr, settings) {

        var getParameterByName = function(name, url) {
                name = name.replace(/[\[\]]/g, "\\$&");
                var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
                    results = regex.exec(url);
                if (!results) return null;
                if (!results[2]) return '';
                return decodeURIComponent(results[2].replace(/\+/g, " "));
            },
            action = getParameterByName( 'action', settings.data );

        if (action == 'save-widget') {

            var widget_id = getParameterByName( 'widget-id', settings.data ),
                sidebar = getParameterByName( 'sidebar', settings.data );

            $('#'+ sidebar +' .widget').each(function() {

                var t = $(this),
                    id = t.attr('id');

                if (id.indexOf(widget_id) != -1) {
                    update_form_elements(t);
                }

            });

        }

    });

    /*
     * resize & scroll events
     */
    var mcoTicking = false;

    window.requestAnimFrame = (function() {
        return window.requestAnimationFrame    ||
            window.webkitRequestAnimationFrame ||
            window.mozRequestAnimationFrame    ||
            window.oRequestAnimationFrame      ||
            window.msRequestAnimationFrame     ||
            function( callback ){
                window.setTimeout(callback, 1000 / 60);
            };
    })();

    function mcoOnResize() {
        mcoUpdateElements('resize');
    }

    function mcoOnScroll() {

        if(!mcoTicking) {
            mcoTicking = true;
            requestAnimFrame(mcoUpdateElements);
        }

    }

    function mcoUpdateElements(ev) {

        var mcoWinHg = window.innerHeight,
            mcoWinWd = window.innerWidth;

        if(_el.body.hasClass('modal-open') || ev == 'init') {
            _el.modal.find('.mco-modal-body').css('height', mcoWinHg - 170);
        }

        mcoTicking = false;

    }

    window.addEventListener('resize', mcoOnResize, false);
    window.addEventListener('scroll', mcoOnScroll, false);

    _el.root.on('mousewheel DOMMouseScroll', function() {
        _el.root.stop();
    });

    mcoUpdateElements('init');
    update_form_elements(_el.body);

});