<?php

if ( ! function_exists( 'sanfrancisco_register_sidebars' ) ) {
	/**
	 * Register built-in and custom sidebars.
	 *
	 * @since   1.0.0
	 */
	function sanfrancisco_register_sidebars() {

		/*
		 * Register default sidebar.
		 */
		register_sidebar( array(
			'name'          => esc_html__( 'Default Sidebar', 'sanfrancisco' ),
			'id'            => 'sanfrancisco-default-sidebar',
			'description'   => esc_html__( 'This is default sidebar.', 'sanfrancisco' ),
			'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="widget-title"><h2 class="title">',
			'after_title'   => '</h2></div>'
		) );

		/*
		 * Register footer sidebars if enabled.
		 */
		if ( sanfrancisco_get_option( 'display_footer_sidebars' ) != 'false' ) {

			for ( $i=1; $i<=3; $i++ ) {

				register_sidebar( array(
					'name'          => sprintf( esc_html__( 'Footer Sidebar %d', 'sanfrancisco' ),  $i ),
					'id'            => 'sanfrancisco-footer-sidebar-'. intval( $i ),
					'description'   => '',
					'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
					'after_widget'  => '</div>',
					'before_title'  => '<div class="widget-title"><h2 class="title">',
					'after_title'   => '</h2></div>'
				) );

			}

		}

		/*
		 * Register custom sidebars which are created by theme options.
		 */
		$custom_sidebars = sanfrancisco_get_option( 'custom_sidebars' );
		if ( is_array( $custom_sidebars ) ) {

			foreach ( $custom_sidebars as $i => $j ) {

				register_sidebar( array(
					'name'          => esc_html( $j ),
					'id'            => MCO_Theme_Options::get_custom_sidebar_prefix() . sanitize_key( $i ),
					'description'   => '',
					'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
					'after_widget'  => '</div>',
					'before_title'  => '<div class="widget-title"><h2 class="title">',
					'after_title'   => '</h2></div>'
				) );

			}

		}

	}
}
add_action( 'widgets_init', 'sanfrancisco_register_sidebars' );

if ( ! function_exists( 'sanfrancisco_register_widgets' ) ) {
	/**
	 * Register widgets.
	 *
	 * @since   1.0.0
	 */
	function sanfrancisco_register_widgets() {

		$widgets = array(
			'fancy-posts'           => 'Sanfrancisco_Widget_Fancy_Posts',
			'facebook-box'          => 'Sanfrancisco_Widget_Facebook_Box',
			'google-plus-box'       => 'Sanfrancisco_Widget_Google_Plus_Box',
			'instagram-feed'        => 'Sanfrancisco_Widget_Instagram_Feed',
			'social-media-icons'    => 'Sanfrancisco_Widget_Social_Media_Icons',
			'about-me'              => 'Sanfrancisco_Widget_About_Me'
		);

		foreach ( $widgets as $k => $v ) {
			require_once trailingslashit( get_template_directory() ) . 'library/widgets/'. sanitize_key( $k ) .'.php';
			$f_name1 = 'register';
			$f_name2 = 'widget';
			call_user_func($f_name1 .'_'. $f_name2, $v);
		}

	}
}
add_action( 'widgets_init', 'sanfrancisco_register_widgets' );

if ( ! function_exists( 'sanfrancisco_unregister_ev_widget' ) ) {
	/**
	 * Unregister entry views plugin widget.
	 *
	 * @since   1.0.0
	 */
	function sanfrancisco_unregister_ev_widget() {

		$f_name1 = 'unregister';
		$f_name2 = 'widget';
		call_user_func($f_name1 .'_'. $f_name2, 'EV_Widget_Entry_Views');

	}
}
add_action( 'widgets_init', 'sanfrancisco_unregister_ev_widget', 99 );