<?php

if ( ! function_exists( 'sanfrancisco_theme_support' ) ) {
	/**
	 * Add theme support for some WordPress core functionalities
	 *
	 * @since   1.0.0
	 */
	function sanfrancisco_theme_support() {

		/*
		 * Make theme available for translation
		 * Translations can be filed in the /languages/ directory
		 */
		load_theme_textdomain( 'sanfrancisco', trailingslashit( get_template_directory() ) . 'languages' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 * Declare thumbnail sizes
		 */
		add_theme_support( 'post-thumbnails' );
		$image_sizes = sanfrancisco_get_image_sizes();
		foreach ( $image_sizes as $k => $v ) {
			if ( $k == 'post-thumbnail' ) {
				set_post_thumbnail_size( $v['width'], $v['height'], true );
			} else {
				add_image_size( $k, $v['width'], $v['height'], true );
			}
		}

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Add default posts and comments RSS feed links to head
		 */
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Enable support for Post Formats.
		 */
		add_theme_support( 'post-formats', array(
			'audio',
			'gallery',
			'video'
		) );

		/*
		 * Switch default core markup for search form, comment form, comments
		 * and gallery to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'comment-list',
			'comment-form',
			'search-form',
			'gallery'
		) );

		/*
		 * This theme uses wp_nav_menu() in one locations.
		 */
		register_nav_menus( array(
			'main'   => esc_html__( 'Main Navigation Menu', 'sanfrancisco' ),
			'footer' => esc_html__( 'Footer Menu', 'sanfrancisco' )
		) );

	}
}
add_action( 'after_setup_theme', 'sanfrancisco_theme_support' );