<?php

if ( ! function_exists( 'sanfrancisco_enqueue_scripts' ) ) {
	/**
	 * Enqueue Scripts & Styles.
	 *
	 * @since   1.0.0
	 */
	function sanfrancisco_enqueue_scripts() {

		wp_enqueue_script( 'jquery' );

		if ( ! is_admin() ) {

			$post_id = NULL;
			if ( is_singular() ) {
				global $post;
				$post_id = $post->ID;
			}

			/*
			 * Enqueue Styles
			 */
			$fonts_url = sanfrancisco_get_styles( 'fonts_url' );
			if ( ! empty( $fonts_url ) ) {
				wp_register_style( 'sanfrancisco-font', esc_url( $fonts_url ) );
				wp_enqueue_style( 'sanfrancisco-font' );
			}

			wp_register_style( 'bootstrap', sanfrancisco_locate_template_uri( 'library/assets/lib/bootstrap.css' ), array(), '3.3.6' );
			wp_enqueue_style( 'bootstrap' );

			wp_register_style( 'font-awesome', sanfrancisco_locate_template_uri( 'library/assets/lib/font-awesome-4.6.3/css/font-awesome.min.css' ), array(), '4.6.3' );
			wp_enqueue_style( 'font-awesome' );

			wp_register_style( 'owl-carousel', sanfrancisco_locate_template_uri( 'library/assets/lib/owl.carousel.2.0.0/assets/owl.carousel.css' ), array(), '2.0.0' );
			wp_enqueue_style( 'owl-carousel' );

			wp_register_style( 'sanfrancisco-stylesheet', trailingslashit( get_template_directory_uri() ) .'style.css', array(), SANFRANCISCO_THEME_VERSION );
			wp_enqueue_style( 'sanfrancisco-stylesheet' );

			if ( is_rtl() ) {
				wp_register_style( 'sanfrancisco-rtl', sanfrancisco_locate_template_uri( 'library/assets/css/sf-rtl.css' ), array(), SANFRANCISCO_THEME_VERSION );
				wp_enqueue_style( 'sanfrancisco-rtl' );
			}

			if ( sanfrancisco_get_option( 'responsive' ) == 'false' ) {
				wp_register_style( 'sanfrancisco-unres', sanfrancisco_locate_template_uri( 'library/assets/css/sf-unres.css' ), array(), SANFRANCISCO_THEME_VERSION );
				wp_enqueue_style( 'sanfrancisco-unres' );
			}

			/*
			 * Enqueue Scripts
			 */
			wp_register_script( 'bootstrap', sanfrancisco_locate_template_uri( 'library/assets/lib/bootstrap-3.3.6/js/bootstrap.min.js' ), array( 'jquery' ), '3.3.6', true );
			wp_enqueue_script( 'bootstrap' );

			wp_register_script( 'owl-carousel', sanfrancisco_locate_template_uri( 'library/assets/lib/owl.carousel.2.0.0/owl.carousel.min.js' ), array( 'jquery' ), '2.0.0', true );
			wp_enqueue_script( 'owl-carousel' );

			if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
				wp_enqueue_script( 'comment-reply' );
			}

			wp_register_script( 'sanfrancisco-main', sanfrancisco_locate_template_uri( 'library/assets/js/sf-main.js' ), array( 'jquery', 'owl-carousel', 'bootstrap' ), SANFRANCISCO_THEME_VERSION, true );
			wp_enqueue_script( 'sanfrancisco-main' );

			$l10n = array(
				'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
				'post_id' => $post_id
			);
			wp_localize_script( 'sanfrancisco-main', 'sf_l10n', $l10n );

		}

	}
}
add_action( 'wp_enqueue_scripts', 'sanfrancisco_enqueue_scripts', 99 );

if ( ! function_exists( 'sanfrancisco_header_custom_code' ) ) {
	/**
	 * Print custom code into the header.
	 *
	 * @since   1.0.0
	 */
	function sanfrancisco_header_custom_code() {

		// Get custom css code generated by theme options
		$header_css = sanfrancisco_get_styles( 'css' );

		// Get css custom code
		$header_css .= "\n" . sanfrancisco_get_option( 'css_custom_code' );

		// Output css custom code
		if ( ! empty( $header_css ) ) {
			echo "<style type=\"text/css\" media=\"screen\">\n" . trim( wp_unslash( $header_css ) ) . "\n</style>";
		}

		//@todo: call google platform script only when google+ box widget placed in current page.
		$locale = explode( '_', sanfrancisco_get_locale() );

		?>
		<script type="text/javascript">
			window.___gcfg = {lang: '<?php echo sanitize_key( $locale[0] ); ?>'};
			(function() {
				var po = document.createElement('script'); po.type = 'text/javascript'; po.async = true;
				po.src = '//apis.google.com/js/platform.js';
				var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(po, s);
			})();
		</script>
		<?php

		// Output header custom code
		echo wp_unslash( sanfrancisco_get_option( 'header_custom_code' ) );

	}
}
add_action( 'wp_head', 'sanfrancisco_header_custom_code', 99 );

if ( ! function_exists( 'sanfrancisco_footer_custom_code' ) ) {
	/**
	 * Add custom code into the footer.
	 *
	 * @since   1.0.0
	 */
	function sanfrancisco_footer_custom_code() {

		// Get footer custom code
		echo wp_unslash( sanfrancisco_get_option( 'footer_custom_code' ) );

	}
}
add_action( 'wp_footer', 'sanfrancisco_footer_custom_code', 999 );

if ( ! function_exists( 'sanfrancisco_body_start' ) ) {
	/**
	 * Fired immediately after <body> opening tag.
	 *
	 * @since   1.0.0
	 */
	function sanfrancisco_body_start() {

		if ( sanfrancisco_get_option( 'soft_transition' ) == 'true' ) {
			echo '<div class="sf-backdrop fade in hl light fl"></div>';
		}

		//@todo: call facebook sdk only when facebook box widget placed in current page and remove the option below.
		if ( sanfrancisco_get_option( 'facebook_sdk' ) == 'true' ) {

			$fb_sdk_query_args = array(
				'xfbml'   => '1',
				'version' => 'v2.8'
			);

			$mashsb_settings = get_option( 'mashsb_settings', array() );
			if ( is_array( $mashsb_settings )
				&& array_key_exists( 'fb_app_id', $mashsb_settings )
				&& ! empty( $mashsb_settings['fb_app_id'] ) ) {
				$fb_sdk_query_args['appId'] = $mashsb_settings['fb_app_id'];
			}

			?>
			<div id="fb-root"></div>
			<script>(function(d, s, id) {
					var js, fjs = d.getElementsByTagName(s)[0];
					if (d.getElementById(id)) return;
					js = d.createElement(s); js.id = id;
					js.src = "//connect.facebook.net/<?php echo sanfrancisco_get_locale(); ?>/sdk.js#<?php echo http_build_query( $fb_sdk_query_args ); ?>";
					fjs.parentNode.insertBefore(js, fjs);
				}(document, 'script', 'facebook-jssdk'));</script>
			<?php

		}

	}
}
add_action( 'sanfrancisco_body_start', 'sanfrancisco_body_start' );