<?php

// modify entry views plugin meta key.
add_filter( 'ev_meta_key', 'sanfrancisco_views_meta_key' );

// modify theme options option meta key.
add_filter( 'mco_to_id', 'sanfrancisco_get_to_id' );

// allow shortcodes to be work in the html module.
add_filter( 'sanfrancisco_html_module_output', 'do_shortcode' );

if ( ! function_exists( 'sanfrancisco_get_search_form' ) ) {
	/**
	 * Customize the default search form.
	 *
	 * @since   1.0.0
	 * @return  string output of search form
	 */
	function sanfrancisco_get_search_form() {

		static $search_form_index = 1;

		$form = '<form class="search-form" method="get" action="' . esc_url( home_url( '/' ) ) . '">
					 <span class="sf-close"><span class="fa fa-times"></span></span>
				    <div class="input-group">
				        <span class="input-group-addon" id="searchAddon'. intval( $search_form_index ) .'"><span class="fa fa-search"></span></span>
		                <input type="text" name="s" class="form-control" autocomplete="off" placeholder="'. esc_attr_x( 'Search...', 'placeholder', 'sanfrancisco' ) .'" title="' . esc_attr_x( 'Search for:', 'label', 'sanfrancisco' ) . '" value="'. esc_attr( get_search_query() ) .'" aria-describedby="searchAddon'. intval( $search_form_index ) .'" />
	                </div>
	            </form>';

		$search_form_index++;

		return $form;

	}
}
add_filter( 'get_search_form', 'sanfrancisco_get_search_form' );

if ( ! function_exists( 'sanfrancisco_body_class' ) ) {
	/**
	 * Add custom classes to the body tag.
	 *
	 * @since   1.0.0
	 * @param   array $classes default classes comes from wp core
	 * @return  array $classes
	 */
	function sanfrancisco_body_class( $classes ) {

		/* add unresponsive class */
		if ( sanfrancisco_get_option( 'responsive' ) == 'false' ) {
			$classes[] = 'sf-unres';
		}

		/* add soft transition navigation class */
		if ( sanfrancisco_get_option( 'soft_transition' ) == 'true' ) {
			$classes[] = 'sf-trs';
		}

		/* add boxed layout class */
		if ( sanfrancisco_get_option( 'boxed_layout' ) == 'true' ) {
			$classes[] = 'sf-boxed-layout';
		}

		return $classes;

	}
}
add_filter( 'body_class', 'sanfrancisco_body_class' );

if ( ! function_exists( 'sanfrancisco_search_form_fs' ) ) {
	/**
	 * Add full screen search form to the footer.
	 *
	 * @since   1.0.0
	 */
	function sanfrancisco_search_form_fs() {

		echo '<div class="sf-search-form-fs">' . get_search_form( false ) . '</div>';

	}
}
add_action( 'wp_footer', 'sanfrancisco_search_form_fs' );

if ( ! function_exists( 'sanfrancisco_get_the_archive_title' ) ) {
	/**
	 * Modify archive pages title.
	 *
	 * @since   1.0.0
	 * @param   string $title   default archive page title
	 * @return  string $title   modified archive page title
	 */
	function sanfrancisco_get_the_archive_title( $title ) {

		if ( is_category() ) {

			$title = sprintf( esc_html_x( '%s', 'Category archives title', 'sanfrancisco' ), esc_html( single_cat_title( '', false ) ) );

		} elseif ( is_tag() ) {

			$title = sprintf( esc_html__( 'Tag: %s', 'sanfrancisco' ), esc_html( single_tag_title( '', false ) ) );

		} elseif ( is_author() ) {

			$title = sprintf( esc_html__( 'Author: %s', 'sanfrancisco' ), '<span class="vcard">' . get_the_author() . '</span>' );

		} elseif ( is_year() ) {

			$title = sprintf( esc_html_x( 'Archive: %s', 'Yearly archives title', 'sanfrancisco' ), get_the_date( 'Y' ) );

		} elseif ( is_month() ) {

			$title = sprintf( esc_html_x( 'Archive: %s', 'Monthly archives title', 'sanfrancisco' ), get_the_date( 'F Y' ) );

		} elseif ( is_day() ) {

			$title = sprintf( esc_html_x( 'Archive: %s', 'Daily archives title', 'sanfrancisco' ), get_the_date( 'F j, Y' ) );

		} elseif ( is_tax( 'post_format' ) ) {

			if ( is_tax( 'post_format', 'post-format-aside' ) ) {

				$title = esc_html_x( 'Asides', 'post format archive title', 'sanfrancisco' );

			} elseif ( is_tax( 'post_format', 'post-format-gallery' ) ) {

				$title = esc_html_x( 'Galleries', 'post format archive title', 'sanfrancisco' );

			} elseif ( is_tax( 'post_format', 'post-format-image' ) ) {

				$title = esc_html_x( 'Images', 'post format archive title', 'sanfrancisco' );

			} elseif ( is_tax( 'post_format', 'post-format-video' ) ) {

				$title = esc_html_x( 'Videos', 'post format archive title', 'sanfrancisco' );

			} elseif ( is_tax( 'post_format', 'post-format-quote' ) ) {

				$title = esc_html_x( 'Quotes', 'post format archive title', 'sanfrancisco' );

			} elseif ( is_tax( 'post_format', 'post-format-link' ) ) {

				$title = esc_html_x( 'Links', 'post format archive title', 'sanfrancisco' );

			} elseif ( is_tax( 'post_format', 'post-format-status' ) ) {

				$title = esc_html_x( 'Statuses', 'post format archive title', 'sanfrancisco' );

			} elseif ( is_tax( 'post_format', 'post-format-audio' ) ) {

				$title = esc_html_x( 'Audio', 'post format archive title', 'sanfrancisco' );

			} elseif ( is_tax( 'post_format', 'post-format-chat' ) ) {

				$title = esc_html_x( 'Chats', 'post format archive title', 'sanfrancisco' );

			}

		} elseif ( is_post_type_archive() ) {

			$title = sprintf( esc_html__( 'Archives: %s', 'sanfrancisco' ), post_type_archive_title( '', false ) );

		} elseif ( is_tax() ) {

			$tax = get_taxonomy( get_queried_object()->taxonomy );
			/* translators: 1: Taxonomy singular name, 2: Current taxonomy term */
			$title = sprintf( esc_html_x( '%1$s: %2$s', '1: Taxonomy singular name, 2: Current taxonomy term', 'sanfrancisco' ), $tax->labels->singular_name, esc_html( single_term_title( '', false ) ) );

		} elseif ( is_search() ) {

			$title = sprintf( esc_html__( 'Search Results for "%s"', 'sanfrancisco' ), get_query_var( 's' ) );

		} else {

			$title = esc_html__( 'Archives', 'sanfrancisco' );

		}

		return $title;

	}
}
add_filter( 'get_the_archive_title', 'sanfrancisco_get_the_archive_title' );

if ( ! function_exists( 'sanfrancisco_widget_tagcloud_limit' ) ) {
	/**
	 * Limit number of tags in tag cloud widget.
	 *
	 * @since   1.0.0
	 * @param   array $args default tag cloud widget args
	 * @return  array $args modified tag cloud widget args
	 */
	function sanfrancisco_widget_tagcloud_limit( $args ) {

		$args['number'] = 20;

		return $args;

	}
}
add_filter( 'widget_tag_cloud_args', 'sanfrancisco_widget_tagcloud_limit' );

if ( ! function_exists( 'sanfrancisco_excerpt_more' ) ) {
	/**
	 * Modify excerpt more text.
	 *
	 * @since   1.0.0
	 * @return  string
	 */
	function sanfrancisco_excerpt_more() {

		return '';

	}
}
add_filter( 'excerpt_more', 'sanfrancisco_excerpt_more' );

if ( ! function_exists( 'sanfrancisco_image_credit_line_field' ) ) {
	/**
	 * Add Photographer Name and URL fields to media uploader.
	 *
	 * @since   1.0.0
	 * @param   array $form_fields  fields to include in attachment form
	 * @param   object $post        attachment record in database
	 * @return  array $form_fields  modified form fields
	 */
	function sanfrancisco_image_credit_line_field( $form_fields, $post ) {

		if ( wp_attachment_is_image( $post->ID ) ) {

			$form_fields['credit_line'] = array(
				'label' => esc_html__( 'Image Credit Line', 'sanfrancisco' ),
				'input' => 'text',
				'value' => get_post_meta( $post->ID, 'sanfrancisco_credit_line', true ),
				'helps' => esc_html__( 'If provided, image credit line will be displayed', 'sanfrancisco' )
			);

		}

		return $form_fields;

	}
}
add_filter( 'attachment_fields_to_edit', 'sanfrancisco_image_credit_line_field', 10, 2 );

if ( ! function_exists( 'sanfrancisco_image_credit_line_field_save' ) ) {
	/**
	 * Save values of Photographer Name and URL in media uploader.
	 *
	 * @since   1.0.0
	 * @param   array $post         the post data for database
	 * @param   array $attachment   attachment fields from $_POST form
	 * @return  array $post         modified post data
	 */
	function sanfrancisco_image_credit_line_field_save( $post, $attachment ) {

		if( isset( $attachment['credit_line'] ) ) {
			update_post_meta( $post['ID'], 'sanfrancisco_credit_line', $attachment['credit_line'] );
		}

		return $post;

	}
}
add_filter( 'attachment_fields_to_save', 'sanfrancisco_image_credit_line_field_save', 10, 2 );

if ( ! function_exists( 'sanfrancisco_category_tax_names' ) ) {
	/**
	 * Define category taxonomies of post types.
	 *
	 * @since   1.0.0
	 * @param   array $post_taxonomies
	 * @return  array $post_taxonomies
	 */
	function sanfrancisco_category_tax_names( $post_taxonomies ) {

		$post_taxonomies['post'] = 'category';
		$post_taxonomies['product'] = 'product_cat';

		return $post_taxonomies;

	}
}
add_filter( 'sanfrancisco_category_tax_names', 'sanfrancisco_category_tax_names' );

if ( ! function_exists( 'sanfrancisco_tag_tax_names' ) ) {
	/**
	 * Define tag taxonomies of post types.
	 *
	 * @since   1.0.0
	 * @param   array $post_taxonomies
	 * @return  array $post_taxonomies
	 */
	function sanfrancisco_tag_tax_names( $post_taxonomies ) {

		$post_taxonomies['post'] = 'post_tag';
		$post_taxonomies['product'] = 'product_tag';

		return $post_taxonomies;

	}
}
add_filter( 'sanfrancisco_tag_tax_names', 'sanfrancisco_tag_tax_names' );

if ( ! function_exists( 'sanfrancisco_filter_search_results' ) ) {
	/**
	 * Filter search results.
	 *
	 * @since   1.0.0
	 * @param   object $query
	 */
	function sanfrancisco_filter_search_results( $query ) {

		if ( $query->is_search ) {

			$args = sanfrancisco_get_options( array(
				'post_types__search',
				'post_taxonomies__search',
				'post_tags__search',
				'excluded_post_ids__search'
			) );

			foreach ( $args as $k => $v ) {
				$key = preg_replace( '#__search$#', '', $k );
				unset( $args[ $k ] );
				$args[ $key ] = $v;
			}

			$params = sanfrancisco_get_post_query_args( $args );

			foreach ( $params as $k => $v ) {
				/** @noinspection PhpUndefinedMethodInspection */
				$query->set( $k, $v );
			}

		}

	}
}
add_filter( 'pre_get_posts', 'sanfrancisco_filter_search_results' );

if ( ! function_exists( 'sanfrancisco_gif_credit_line' ) ) {
	/**
	 * Add credit line to the corner of the gif.
	 *
	 * @since   1.0.0
	 * @param   string $content
	 * @param   object $attachment
	 * @return  string
	 */
	function sanfrancisco_gif_credit_line( $content, $attachment ) {

		$credit_line = get_post_meta( $attachment->ID, 'sanfrancisco_credit_line', true );

		$content .= '<div class="sf-entry-flags"><span class="sf-entry-flag sf-entry-flag-creditline">'. esc_html( $credit_line ) .'</span></div>';

		return $content;

	}
}
add_action( 'agggif_after_gif', 'sanfrancisco_gif_credit_line', 10, 2 );

if ( ! function_exists( 'sanfrancisco_predefined_fonts' ) ) {
	/**
	 * Define default fonts for the theme.
	 *
	 * @since   1.0.0
	 * @return  array
	 */
	function sanfrancisco_predefined_fonts() {

		$fonts = array(
			array(
				'font_family' => 'Roboto',
				'font_weight_style' => array(
					'400',
					'900',
					'700',
					'500',
					'300',
					'400italic'
				),
				'font_subsets' => array(
					'latin',
					'latin-ext'
				)
			)
		);

		return $fonts;

	}
}
add_filter( 'sanfrancisco_predefined_fonts', 'sanfrancisco_predefined_fonts' );

if ( ! function_exists( 'sanfrancisco_ad_locations' ) ) {
	/**
	 * Add extra ad locations to the Flex Ads plugin.
	 *
	 * @since   1.0.0
	 * @param   $ad_locations
	 * @return  array $ad_locations
	 */
	function sanfrancisco_ad_locations( $ad_locations ) {

		$ad_locations = wp_parse_args( $ad_locations, array(
			'header'     => array(
				'location'      => 'header',
				'title'         => esc_html__( 'Header', 'sanfrancisco' ),
				'desc'          => '',
				'preview'       => false,
				'ad_types'      => true,
				'parameters'    => array(
					array(
						'id'      => 'position',
						'label'   => esc_html__( 'Ad Position', 'sanfrancisco' ),
						'desc'    => esc_html__( 'Choose where the ad will be placed.', 'sanfrancisco' ),
						'std'     => 'below',
						'type'    => 'radio_select',
						'choices' => array(
							array(
								'text'  => esc_html__( 'Below Header', 'sanfrancisco' ),
								'value' => 'below'
							),
							array(
								'text'  => esc_html__( 'Above Header', 'sanfrancisco' ),
								'value' => 'above'
							)
						)
					)
				)
			),
			'footer'     => array(
				'location'      => 'footer',
				'title'         => esc_html__( 'Footer', 'sanfrancisco' ),
				'desc'          => '',
				'preview'       => false,
				'ad_types'      => true,
				'parameters'    => array(
					array(
						'id'      => 'position',
						'label'   => esc_html__( 'Ad Position', 'sanfrancisco' ),
						'desc'    => esc_html__( 'Choose where the ad will be placed.', 'sanfrancisco' ),
						'std'     => 'above',
						'type'    => 'radio_select',
						'choices' => array(
							array(
								'text'  => esc_html__( 'Below Footer', 'sanfrancisco' ),
								'value' => 'below'
							),
							array(
								'text'  => esc_html__( 'Above Footer', 'sanfrancisco' ),
								'value' => 'above'
							)
						)
					)
				)
			),
			'background' => array(
				'location'      => 'background',
				'title'         => esc_html__( 'Background', 'sanfrancisco' ),
				'desc'          => '',
				'preview'       => false,
				'ad_types'      => false,
				'parameters'    => array(
					array(
						'id'         => 'background_ad_attachment_id',
						'label'      => esc_html__( 'Background Ad Image', 'sanfrancisco' ),
						'desc'       => sprintf( esc_html__( 'To see sample background ad images visit %s', 'sanfrancisco' ), SANFRANCISCO_DOCS_URI ),
						'type'       => 'media',
						'media_type' => 'image'
					),
					array(
						'id'      => 'background_ad_image_attachment',
						'label'   => esc_html__( 'Background Attachment', 'sanfrancisco' ),
						'desc'    => esc_html__( 'Choose how background ad will display on page scroll.', 'sanfrancisco' ),
						'type'    => 'radio_select',
						'std'     => 'fixed',
						'choices' => array(
							array(
								'text'  => esc_html__( 'Scroll', 'sanfrancisco' ),
								'value' => 'scroll'
							),
							array(
								'text'  => esc_html__( 'Fixed', 'sanfrancisco' ),
								'value' => 'fixed'
							)
						)
					),
					array(
						'id'      => 'background_ad_image_repeat',
						'label'   => esc_html__( 'Background Repeat', 'sanfrancisco' ),
						'desc'    => esc_html__( 'Choose how background will be placed.', 'sanfrancisco' ),
						'type'    => 'radio_select',
						'std'     => 'no_repeat',
						'choices' => array(
							array(
								'text'  => esc_html__( 'Tile Vertically', 'sanfrancisco' ),
								'value' => 'repeat_y'
							),
							array(
								'text'  => esc_html__( 'No Repeat', 'sanfrancisco' ),
								'value' => 'no_repeat'
							)
						)
					),
					array(
						'id'         => 'background_ad_url',
						'label'      => esc_html__( 'Ad Url', 'sanfrancisco' ),
						'desc'       => esc_html__( 'Type url of the ad.', 'sanfrancisco' ),
						'type'       => 'text',
						'input_type' => 'url',
						'input_size' => 'lg'
					),
					array(
						'id'      => 'background_ad_link_target',
						'label'   => esc_html__( 'Ad Link Target', 'sanfrancisco' ),
						'desc'    => esc_html__( 'Choose how to open ad link on click.', 'sanfrancisco' ),
						'std'     => '_blank',
						'type'    => 'radio_select',
						'choices' => array(
							array(
								'text'  => esc_html__( 'Same Window', 'sanfrancisco' ),
								'value' => '_self'
							),
							array(
								'text'  => esc_html__( 'New Tab', 'sanfrancisco' ),
								'value' => '_blank'
							)
						)
					),
					array(
						'id'    => 'background_ad_content_top_spacing',
						'label' => esc_html__( 'Page Content Top Spacing', 'sanfrancisco' ),
						'desc'  => esc_html__( 'If your background ad image has a place on top, you can add spacing to the page content.', 'sanfrancisco' ),
						'type'  => 'numeric_slider',
						'range' => '0,300',
						'unit'  => 'px',
						'std'   => '30'
					)
				)
			),
			'splash'     => array(
				'location'      => 'splash',
				'title'         => esc_html__( 'Splash', 'sanfrancisco' ),
				'desc'          => '',
				'preview'       => false,
				'ad_types'      => true,
				'parameters'    => array(
					array(
						'id'         => 'splash_ad_opening_delay',
						'label'      => esc_html__( 'Ad Opening Delay (in seconds)', 'sanfrancisco' ),
						'desc'       => esc_html__( 'The delay of opening of the splash ad in seconds. Type zero (0) if you want the ad to open immediately.', 'sanfrancisco' ),
						'type'       => 'text',
						'input_type' => 'number',
						'input_size' => 'xs',
						'unit'       => esc_html__( 'seconds', 'sanfrancisco' ),
						'std'        => '0'
					),
					array(
						'id'    => 'splash_ad_has_countdown',
						'label' => esc_html__( 'Add Countdown', 'sanfrancisco' ),
						'desc'  => esc_html__( 'You may want to add countdown to the splash ad. So user will not be able to close the ad until countdown completed.', 'sanfrancisco' ),
						'std'   => 'true',
						'type'  => 'toggle'
					),
					array(
						'id'         => 'splash_ad_countdown',
						'label'      => esc_html__( 'Countdown (in seconds)', 'sanfrancisco' ),
						'desc'       => esc_html__( 'Type the countdown in seconds.', 'sanfrancisco' ),
						'type'       => 'text',
						'input_type' => 'number',
						'input_size' => 'xs',
						'unit'       => esc_html__( 'seconds', 'sanfrancisco' ),
						'std'        => '10',
						'condition'  => 'splash_ad_has_countdown:is(true)'
					),
					array(
						'id'        => 'splash_ad_countdown_position',
						'label'     => esc_html__( 'Countdown Position', 'sanfrancisco' ),
						'desc'      => esc_html__( 'Choose the position of countdown around the ad.', 'sanfrancisco' ),
						'type'      => 'radio_select',
						'std'       => 'top_right',
						'choices'   => array(
							array(
								'text'  => esc_html__( 'Top Left', 'sanfrancisco' ),
								'value' => 'top_left'
							),
							array(
								'text'  => esc_html__( 'Top Right', 'sanfrancisco' ),
								'value' => 'top_right'
							),
							array(
								'text'  => esc_html__( 'Bottom Left', 'sanfrancisco' ),
								'value' => 'bottom_left'
							),
							array(
								'text'  => esc_html__( 'Bottom Right', 'sanfrancisco' ),
								'value' => 'bottom_right'
							)
						),
						'condition' => 'splash_ad_has_countdown:is(true)'
					),
					array(
						'id'         => 'splash_ad_close_btn_text',
						'label'      => esc_html__( 'Close Button Text', 'sanfrancisco' ),
						'desc'       => esc_html__( 'Type a close button text in order for the user to be able to close ad.', 'sanfrancisco' ),
						'type'       => 'text',
						'std'        => 'x',
						'input_size' => 'md'
					),
					array(
						'id'      => 'splash_ad_close_btn_position',
						'label'   => esc_html__( 'Close Button Position', 'sanfrancisco' ),
						'desc'    => esc_html__( 'Choose the position of close button around the ad.', 'sanfrancisco' ),
						'type'    => 'radio_select',
						'std'     => 'top_right',
						'choices' => array(
							array(
								'text'  => esc_html__( 'Top Left', 'sanfrancisco' ),
								'value' => 'top_left'
							),
							array(
								'text'  => esc_html__( 'Top Right', 'sanfrancisco' ),
								'value' => 'top_right'
							),
							array(
								'text'  => esc_html__( 'Bottom Left', 'sanfrancisco' ),
								'value' => 'bottom_left'
							),
							array(
								'text'  => esc_html__( 'Bottom Right', 'sanfrancisco' ),
								'value' => 'bottom_right'
							)
						)
					)
				)
			),
			'fixed'      => array(
				'location'      => 'fixed',
				'title'         => esc_html__( 'Fixed', 'sanfrancisco' ),
				'desc'          => '',
				'preview'       => false,
				'ad_types'      => true,
				'parameters'    => array(
					array(
						'id'      => 'position',
						'label'   => esc_html__( 'Ad Position', 'sanfrancisco' ),
						'desc'    => esc_html__( 'Choose where the ad will be placed.', 'sanfrancisco' ),
						'std'     => 'left',
						'type'    => 'radio_select',
						'choices' => array(
							array(
								'text'  => esc_html__( 'Fixed Left Side', 'sanfrancisco' ),
								'value' => 'left'
							),
							array(
								'text'  => esc_html__( 'Fixed Right Side', 'sanfrancisco' ),
								'value' => 'right'
							),
							array(
								'text'  => esc_html__( 'Fixed Bottom of the Window', 'sanfrancisco' ),
								'value' => 'bottom'
							)
						)
					),
					array(
						'id'    => 'fixed_ad_has_countdown',
						'label' => esc_html__( 'Add Countdown', 'sanfrancisco' ),
						'desc'  => esc_html__( 'You may want to add countdown to the fixed ad. So user will not be able to close the ad until countdown completed.', 'sanfrancisco' ),
						'std'   => 'false',
						'type'  => 'toggle'
					),
					array(
						'id'         => 'fixed_ad_countdown',
						'label'      => esc_html__( 'Countdown (in seconds)', 'sanfrancisco' ),
						'desc'       => esc_html__( 'Type the countdown in seconds.', 'sanfrancisco' ),
						'type'       => 'text',
						'input_type' => 'number',
						'input_size' => 'xs',
						'unit'       => esc_html__( 'seconds', 'sanfrancisco' ),
						'std'        => '10',
						'condition'  => 'fixed_ad_has_countdown:is(true)'
					),
					array(
						'id'        => 'fixed_ad_countdown_position',
						'label'     => esc_html__( 'Countdown Position', 'sanfrancisco' ),
						'desc'      => esc_html__( 'Choose the position of countdown around the ad.', 'sanfrancisco' ),
						'type'      => 'radio_select',
						'std'       => 'top_right',
						'choices'   => array(
							array(
								'text'  => esc_html__( 'Top Left', 'sanfrancisco' ),
								'value' => 'top_left'
							),
							array(
								'text'  => esc_html__( 'Top Right', 'sanfrancisco' ),
								'value' => 'top_right'
							),
							array(
								'text'  => esc_html__( 'Bottom Left', 'sanfrancisco' ),
								'value' => 'bottom_left'
							),
							array(
								'text'  => esc_html__( 'Bottom Right', 'sanfrancisco' ),
								'value' => 'bottom_right'
							)
						),
						'condition' => 'fixed_ad_has_countdown:is(true)'
					),
					array(
						'id'    => 'fixed_ad_has_close_btn',
						'label' => esc_html__( 'Add Close Button', 'sanfrancisco' ),
						'desc'  => esc_html__( 'You may let the user to be able to close the ad', 'sanfrancisco' ),
						'type'  => 'toggle',
						'std'   => 'false'
					),
					array(
						'id'        => 'fixed_ad_close_btn_text',
						'label'     => esc_html__( 'Close Button Text', 'sanfrancisco' ),
						'desc'      => esc_html__( 'Type a close button text in order for the user to be able to close ad.', 'sanfrancisco' ),
						'type'      => 'text',
						'std'       => 'x',
						'condition' => 'fixed_ad_has_close_btn:is(true)'
					),
					array(
						'id'        => 'fixed_ad_close_btn_position',
						'label'     => esc_html__( 'Close Button Position', 'sanfrancisco' ),
						'desc'      => esc_html__( 'Choose the position of close button around the ad.', 'sanfrancisco' ),
						'type'      => 'radio_select',
						'std'       => 'top_right',
						'choices'   => array(
							array(
								'text'  => esc_html__( 'Top Left', 'sanfrancisco' ),
								'value' => 'top_left'
							),
							array(
								'text'  => esc_html__( 'Top Right', 'sanfrancisco' ),
								'value' => 'top_right'
							),
							array(
								'text'  => esc_html__( 'Bottom Left', 'sanfrancisco' ),
								'value' => 'bottom_left'
							),
							array(
								'text'  => esc_html__( 'Bottom Right', 'sanfrancisco' ),
								'value' => 'bottom_right'
							)
						),
						'condition' => 'fixed_ad_has_close_btn:is(true)'
					)
				)
			)
		) );

		return $ad_locations;

	}
}
add_filter( 'aggads_ad_locations', 'sanfrancisco_ad_locations' );

if ( ! function_exists( 'sanfrancisco_ad_locations_instructions' ) ) {
	/**
	 * FlexAds ad instructions.
	 *
	 * @since   1.0.0
	 * @param   $content
	 * @param   $ad_obj
	 * @return  string
	 */
	function sanfrancisco_ad_locations_instructions( $content, $ad_obj ) {

		if ( ! class_exists( 'Agg_Flex_Ads_Plugin' ) ) {
			return '';
		}

		/** @noinspection HtmlUnknownTarget */
		$str = array(
			'header' => esc_html__( 'Follow these instructions in order to place this ad in your theme:', 'sanfrancisco' ),
			'or' => esc_html__( 'or', 'sanfrancisco' ),
			'alt' => array(
				'theme_options' => wp_kses( __( 'Go to <strong>Theme Options &rarr; General &rarr; Advertisement</strong> and choose the ad in this section.', 'sanfrancisco' ), array( 'strong' => array() ) ),
				'sidebar'       => wp_kses( __( 'Go to widgets page (<em>Appearance &rarr; Widgets</em>) use <strong>Flex Ads - Ad</strong> widget to place the ad into the sidebar.', 'sanfrancisco' ), array( 'strong' => array(), 'em' => array() ) ),
				'shortcode'     => esc_html__( 'Copy the shortcode below and use it in post content, page builder modules or widgets.', 'sanfrancisco' ),
			),
			'more' => sprintf( wp_kses( __( 'More info: <a href="%s" target="_blank">Check Documentation</a>', 'sanfrancisco' ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ), SANFRANCISCO_DOCS_URI )
		);

		if ( $ad_obj->location != 'sidebar' ) {
			unset( $str['alt']['sidebar'] );
		}

		if ( in_array( $ad_obj->location, array( 'background', 'splash' ) ) ) {
			unset( $str['alt']['shortcode'] );
		}

		$content .= '<div class="sf-ad-instructions" data-or-text="' . esc_attr( $str['or'] ) . '"><h2 class="sf-ai-title">'. $str['header'] .'</h2><ul>';

		foreach ( $str['alt'] as $i => $s ) {
			$content .= '<li>' . $s;
			if ( $i == 'shortcode' ) {
				$content .= '<p class="sf-ai-shortcode"><input type="text" onfocus="this.select();" readonly="readonly" value="['. Agg_Flex_Ads_Plugin::SHORTCODE_TAG .' id=&quot;'. $ad_obj->id .'&quot; align=&quot;none&quot;]" /></p>';
			}
			$content .= '</li>';
		}

		$content .= '</ul><p class="sf-ai-more">' . $str['more'] . '</p></div>';

		return $content;

	}
}
add_filter( 'aggads_ad_instructions', 'sanfrancisco_ad_locations_instructions', 10, 2 );

if ( ! function_exists( 'sanfrancisco_place_ad' ) ) {
	/**
	 * Action to output flex ads.
	 *
	 * @since   1.0.0
	 * @param   mixed $locations
	 */
	function sanfrancisco_place_ad( $locations ) {

		if ( is_string( $locations ) ) {
			$locations = array( $locations );
		}

		if ( ! is_array( $locations ) || ! class_exists( 'Agg_Flex_Ads' ) ) {
			return;
		}

		foreach ( $locations as $loc_pos ) {

			$ad_meta = sanfrancisco_get_option( 'advertisement' );

			if ( ! is_string( $loc_pos )
				|| ! preg_match( '#^([a-z]+)(?:_([a-z]+))?$#', $loc_pos, $match )
				|| ! is_array( $ad_meta )
				|| ! array_key_exists( $loc_pos, $ad_meta )
				|| ! is_array( $ad_meta[ $loc_pos ] ) ) {
				continue;
			}

			$location = $match[1];
			$position = ( count( $match ) > 2 ) ? $match[2] : '';

			foreach ( $ad_meta[ $loc_pos ] as $breakpoint_id => $ad_id ) {

				sanfrancisco_ad( $ad_id, 'center', $location, $position, $breakpoint_id );

			}

		}

	}
}
add_action( 'sanfrancisco_place_ad', 'sanfrancisco_place_ad' );

if ( ! function_exists( 'sanfrancisco_head_tags' ) ) {
	/**
	 * Add main tags to the header
	 *
	 * @since   1.0.1
	 */
	function sanfrancisco_head_tags() {

		echo '<meta charset="' . esc_attr( get_bloginfo( 'charset' ) ) . '">' . "\n";

		if ( sanfrancisco_get_option( 'responsive' ) != 'false' ) {
			echo '<meta name="viewport" content="user-scalable=yes,width=device-width,minimum-scale=1,initial-scale=1">' . "\n";
		}

		if ( sanfrancisco_get_option( 'responsive' ) != 'false' ) {
			echo '<!--[if IE]><meta http-equiv="X-UA-Compatible" content="IE=edge" /><![endif]-->' . "\n";
		}

		echo '<link rel="pingback" href="' . esc_url( get_bloginfo('pingback_url') ) . '">' . "\n";

	}
}
add_action( 'wp_head', 'sanfrancisco_head_tags', 0 );

if ( ! function_exists( 'sanfrancisco_save_theme_options' ) ) {
	/**
	 * Save options css map on theme options save
	 *
	 * @since   1.2.0
	 * @param	$options
	 */
	function sanfrancisco_save_theme_options( $options ) {

		$affixes = array( 'single', 'page', 'category', 'author', 'search', 'tag', 'home', 'archive' );

		foreach ( $affixes as $k ) {

			$options_css = sanfrancisco_get_options_css( $k );

			if ( is_array( $options_css ) ) {

				foreach ( $options_css as $i => $j ) {
					unset( $options_css[ $i ] );
					$i = preg_replace( '#__' . $k . '$#', '', $i );
					$options_css[ $i ] = $j;
				}

			}

			update_option( 'sanfrancisco_options_css__' . $k, $options_css );
		
		}

	}
}
add_action( 'mco_after_save_theme_options', 'sanfrancisco_save_theme_options', 999 );

if ( ! function_exists( 'sanfrancisco_edit_terms_options_css' ) ) {
	/**
	 * Save options css map for terms on term save
	 *
	 * @since   1.2.0
	 * @param	$term_id
	 */
	function sanfrancisco_edit_terms_options_css( $term_id ) {

		update_term_meta( $term_id, 'sanfrancisco_options_css', sanfrancisco_get_options_css() );

	}
}
add_action( 'edit_terms', 'sanfrancisco_edit_terms_options_css', 999 );
add_action( 'create_term', 'sanfrancisco_edit_terms_options_css', 999 );

if ( ! function_exists( 'sanfrancisco_save_post_options_css' ) ) {
	/**
	 * Save options css map for posts on post save
	 *
	 * @since   1.2.0
	 * @param	$post_id
	 */
	function sanfrancisco_save_post_options_css( $post_id ) {
		
		update_post_meta( $post_id, 'sanfrancisco_options_css', sanfrancisco_get_options_css() );

	}
}
add_action( 'save_post', 'sanfrancisco_save_post_options_css', 999 );

if ( ! function_exists( 'sanfrancisco_next_posts_link_attributes' ) ) {
	/**
	 * Add class to next post lint
	 * 
	 * @since 1.3.1
	 */
	function sanfrancisco_next_posts_link_attributes() {

		return ' class="pg-btn" rel="next"';

	}
}
add_filter( 'next_posts_link_attributes', 'sanfrancisco_next_posts_link_attributes' );

if ( ! function_exists( 'sanfrancisco_previous_posts_link_attributes' ) ) {
	/**
	 * Add class to previous post lint
	 * 
	 * @since 1.3.1
	 */
	function sanfrancisco_previous_posts_link_attributes() {

		return ' class="pg-btn" rel="prev"';

	}
}
add_filter( 'previous_posts_link_attributes', 'sanfrancisco_previous_posts_link_attributes' );

if ( ! function_exists( 'sanfrancisco_module_settings_js' ) ) {
	/**
	 * Add module seeings as json format
	 * 
	 * @since 1.3.1
	 */
	function sanfrancisco_module_settings_js( $settings ) {

		if ( array_key_exists( 'layout', $settings ) && $settings['layout'] == 'grid_posts' && is_page_template( 'page-sections.php' ) ) {

			$settings_js = $settings;
			if ( array_key_exists( 'query', $settings_js ) ) {
				unset( $settings_js[ 'query' ] );
			}

			echo "<script>\nvar sf_module_" . str_replace( '-', '_', $settings['id'] ) . "_settings = " . json_encode( $settings_js ) . ";\n</script>";

		}

	}
}
add_action( 'sanfrancisco_before_module', 'sanfrancisco_module_settings_js', 10, 1 );
