<?php
/**
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @version    2.6.1
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

/**
 * Include the TGM_Plugin_Activation class.
 */
require_once trailingslashit( get_template_directory() ) . 'library/admin/includes/TGM-Plugin-Activation/class-tgm-plugin-activation.php';

if ( ! function_exists( 'sanfrancisco_register_required_plugins' ) ) {
	/**
	 * Register the required plugins for this theme.
	 * This function is hooked into `tgmpa_register`, which is fired on the WP `init` action on priority 10.
	 *
	 * @since   1.0.0
	 */
	function sanfrancisco_register_required_plugins() {
		/*
		 * Array of plugin arrays. Required keys are name and slug.
		 * If the source is NOT from the .org repo, then source is also required.
		 */
		$plugins = array(
			
			// Entry Views (Required)
			array(
				'name'                  => esc_html__( 'Entry Views', 'sanfrancisco' ), // The plugin name
				'slug'                  => 'entry-views', // The plugin slug (typically the folder name)
				'source'                => 'https://minduction.co/plugins/downloads/entry-views.zip', // The plugin source
				'required'              => true, // If false, the plugin is only 'recommended' instead of required
				'version'               => '1.0.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
				'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
				'force_deactivation'    => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			),

			// Force Regenerate Thumbnails
			array(
				'name'      => esc_html__( 'Force Regenerate Thumbnails', 'sanfrancisco' ),
				'slug'      => 'force-regenerate-thumbnails',
				'required'  => false
			),

			// Flex Ads
			array(
				'name'                  => esc_html__( 'FlexAds', 'sanfrancisco' ), // The plugin name
				'slug'                  => 'agg-flex-ads', // The plugin slug (typically the folder name)
				'source'                => 'https://minduction.co/plugins/downloads/agg-flex-ads.zip', // The plugin source
				'required'              => false, // If false, the plugin is only 'recommended' instead of required
				'version'               => '1.0.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
				'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
				'force_deactivation'    => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			),

			// Minduction Shortcodes
			array(
				'name'                  => esc_html__( 'Minduction Shortcodes', 'sanfrancisco' ), // The plugin name
				'slug'                  => 'mco-shortcodes', // The plugin slug (typically the folder name)
				'source'                => 'https://minduction.co/plugins/downloads/mco-shortcodes.zip', // The plugin source
				'required'              => false, // If false, the plugin is only 'recommended' instead of required
				'version'               => '1.0.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
				'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
				'force_deactivation'    => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			),

			// Smart GIF
			array(
				'name'                  => esc_html__( 'SmartGIF', 'sanfrancisco' ), // The plugin name
				'slug'                  => 'agg-smart-gif', // The plugin slug (typically the folder name)
				'source'                => 'https://minduction.co/plugins/downloads/agg-smart-gif.zip', // The plugin source
				'required'              => false, // If false, the plugin is only 'recommended' instead of required
				'version'               => '1.0.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
				'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
				'force_deactivation'    => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			),

			// Social Media Share Buttons | MashShare
			array(
				'name'     => esc_html__( 'Social Media Share Buttons | MashShare', 'sanfrancisco' ),
				'slug'     => 'mashsharer',
				'required' => false,
			)

		);

		/*
		 * Array of configuration settings. Amend each line as needed.
		 *
		 * TGMPA will start providing localized text strings soon. If you already have translations of our standard
		 * strings available, please help us make TGMPA even better by giving us access to these translations or by
		 * sending in a pull-request with .po file(s) with the translations.
		 *
		 * Only uncomment the strings in the config array if you want to customize the strings.
		 */
		$config = array(
			'id'           => 'sanfrancisco',          // Unique ID for hashing notices for multiple instances of TGMPA.
			'default_path' => '',                      // Default absolute path to bundled plugins.
			'menu'         => 'tgmpa-install-plugins', // Menu slug.
			'parent_slug'  => 'themes.php',            // Parent menu slug.
			'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
			'has_notices'  => true,                    // Show admin notices or not.
			'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
			'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
			'is_automatic' => false,                   // Automatically activate plugins after installation or not.
			'message'      => ''                       // Message to output right before the plugins table.
		);

		tgmpa( $plugins, $config );
	}
}
add_action( 'tgmpa_register', 'sanfrancisco_register_required_plugins' );