jQuery(document).ready(function($) {

    var _el = {
            body: $('body')
        },
        wp_media;

    _el.body.on('click', '.sf-btn-remove-media', function(e) {

        e.preventDefault();

        var t = $(this),
            c = 'sf-hide';

        t.siblings('input.sf-media').val('');
        t.siblings('.sf-media-holder').html('');
        t.addClass(c).siblings('.sf-btn-add-media').removeClass(c);

    });

    _el.body.on('click', '.sf-btn-add-media', function(e) {

        e.preventDefault();

        var t = $(this),
            c = 'sf-hide',
            el_media = t.siblings('input.sf-media'),
            el_media_holder = t.siblings('.sf-media-holder');

        if ( wp_media ) {
            wp_media.open();
            return;
        }

        wp_media = wp.media({
            multiple: false  // Set to true to allow multiple files to be selected
        });

        // When an image is selected in the media frame...
        wp_media.on( 'select', function() {

            // Get media attachment details from the frame state
            var attachment = wp_media.state().get('selection').first().toJSON(),
                media_result = attachment.url;

            if(t.data('return') == 'id') {
                media_result = attachment.id;
            }

            el_media.val(media_result);
            el_media_holder.html($('<img>').attr({'src': attachment.url}));
            t.addClass(c).siblings('.sf-btn-remove-media').removeClass(c);

        });

        // Finally, open the modal on click
        wp_media.open();

    });

    /*
     * Adds social icon
     */
    _el.body.on('click', '.sf-btn-add-social-icon', function(e) {

        e.preventDefault();

        var i = $(this).parents('.widget').attr('id').split('-').pop(),
            p = $(this).parents('p'),
            c = 'sf-social-icon-row-instance',
            el = p.siblings('.'+c).clone(),
            sel_name = el.find('select').attr('name'),
            inp_name = el.find('input').attr('name');

        el.removeClass(c);

        p.before(el.show());

        el.find('select').attr('name',sel_name.replace('__i__',i));
        el.find('input').attr('name',inp_name.replace('__i__',i));

    });

    _el.body.on('click', '.sf-social-icon-row-rm', function(e) {

        e.preventDefault();

        $(this).parents('.sf-social-icon-row').remove();

    });

    $('.sf-ad-instructions ul li').each(function() {

        var t = $(this),
            p = t.parents('.sf-ad-instructions'),
            is_last = t.is(':last-child'),
            or_text = p.data('or-text');

        if(typeof or_text == 'undefined' || is_last) {
            return;
        }
        //<div class="sf-ai-or"><span class="sf-ai-or-inner">or</span></div>
        t.append($('<div>').addClass('sf-ai-or').html($('<span>').addClass('sf-ai-or-inner').text(or_text)));

    });

});