<?php

/*
 * Theme options, post options & page builder configuration
 */
if ( ! function_exists( 'sanfrancisco_admin' ) ) {
	function sanfrancisco_admin() {

		if ( ! is_admin() ) {
			return;
		}

		$post = null;
		if ( is_page_template( 'page-sections.php' ) ) {
			global $post;
		}

		/*
		 * This theme styles the visual editor to resemble the theme style
		 */
		add_editor_style( 'library/admin/css/sf-editor.css' );

		add_editor_style( 'library/assets/lib/font-awesome-4.6.3/css/font-awesome.min.css' );

		if ( is_rtl() ) {
			add_editor_style( 'library/admin/css/sf-editor-rtl.css' );
		}

		/* theme options key to get saved settings */
		$to_id = sanfrancisco_get_to_id();

		$gp_posts_layout_choices = array(
			array(
				'alt' => esc_html__( 'One Column Vertical', 'sanfrancisco' ),
				'value' => 'vertical_1_col',
				'image' => sanfrancisco_locate_template_uri( 'library/admin/images/grid-one-column-vertical.jpg' )
			),
			array(
				'alt' => esc_html__( 'Two Columns Vertical', 'sanfrancisco' ),
				'value' => 'vertical_2_col',
				'image' => sanfrancisco_locate_template_uri( 'library/admin/images/grid-two-columns-vertical.jpg' )
			),
			array(
				'alt' => esc_html__( 'Three Columns Vertical', 'sanfrancisco' ),
				'value' => 'vertical_3_col',
				'image' => sanfrancisco_locate_template_uri( 'library/admin/images/grid-three-columns-vertical.jpg' )
			),
			array(
				'alt' => esc_html__( 'Four Columns Vertical', 'sanfrancisco' ),
				'value' => 'vertical_4_col',
				'image' => sanfrancisco_locate_template_uri( 'library/admin/images/grid-four-columns-vertical.jpg' )
			),
			array(
				'alt' => esc_html__( 'One Column Horizontal', 'sanfrancisco' ),
				'value' => 'horizontal_1_col',
				'image' => sanfrancisco_locate_template_uri( 'library/admin/images/grid-one-column-horizontal.jpg' )
			),
			array(
				'alt' => esc_html__( 'Two Columns Horizontal', 'sanfrancisco' ),
				'value' => 'horizontal_2_col',
				'image' => sanfrancisco_locate_template_uri( 'library/admin/images/grid-two-columns-horizontal.jpg' )
			),
			array(
				'alt' => esc_html__( 'Three Columns Horizontal', 'sanfrancisco' ),
				'value' => 'horizontal_3_col',
				'image' => sanfrancisco_locate_template_uri( 'library/admin/images/grid-three-columns-horizontal.jpg' )
			)
		);

		$gp_pagination_choices = array(
			array(
				'label' => esc_html__( 'None', 'sanfrancisco' ),
				'value' => 'none'
			),
			array(
				'label' => esc_html__( 'Numeric Pagination Buttons', 'sanfrancisco' ),
				'value' => 'numeric'
			),
			array(
				'label' => esc_html__( 'Prev/Next Page Links', 'sanfrancisco' ),
				'value' => 'prev_next'
			),
			array(
				'label' => esc_html__( 'Load More Button', 'sanfrancisco' ),
				'value' => 'load_more'
			),
			array(
				'label' => esc_html__( 'Infinite Scroll', 'sanfrancisco' ),
				'value' => 'infinite_scroll'
			)
		);

		$text_transform_choices = array(
			array(
				'text' => 'None',
				'value' => 'none'
			),
			array(
				'text' => 'Uppercase',
				'value' => 'uppercase'
			),
			array(
				'text' => 'Lowercase',
				'value' => 'lowecase'
			),
			array(
				'text' => 'Capitalize',
				'value' => 'capitalize'
			)
		);

		$visibility_choices = array(
			array(
				'label' => esc_html__( 'Visible on Large Screens (Desktop)', 'sanfrancisco' ),
				'value' => 'visible-lg'
			),
			array(
				'label' => esc_html__( 'Visible on Small Screens (Desktop)', 'sanfrancisco' ),
				'value' => 'visible-md'
			),
			array(
				'label' => esc_html__( 'Visible on Tablets', 'sanfrancisco' ),
				'value' => 'visible-sm'
			),
			array(
				'label' => esc_html__( 'Visible on Phones', 'sanfrancisco' ),
				'value' => 'visible-xs'
			)
		);

		$orderby_choices = array(
			array(
				'label' => esc_html__( 'Date', 'sanfrancisco' ),
				'value' => 'date'
			),
			array(
				'label' => esc_html__( 'Number of Views', 'sanfrancisco' ),
				'value' => 'views'
			),
			array(
				'label' => esc_html__( 'Number of Comments', 'sanfrancisco' ),
				'value' => 'comments'
			),
			array(
				'label' => esc_html__( 'Random', 'sanfrancisco' ),
				'value' => 'random'
			),
			array(
				'label' => esc_html__( 'Filtered Post Id\'s', 'sanfrancisco' ),
				'value' => 'post_ids'
			)
		);

		$order_choices = array(
			array(
				'text' => esc_html__( 'Ascending', 'sanfrancisco' ),
				'value' => 'asc'
			),
			array(
				'text' => esc_html__( 'Descending', 'sanfrancisco' ),
				'value' => 'desc'
			)
		);

		$background_std = array(
			'background_color'      => '#f6f6f6',
			'background_image'      => '',
			'background_repeat'     => 'no_repeat',
			'background_position'   => 'top_center',
			'background_attachment' => 'scroll'
		);

		$ad_locations_with_positions = array(
			'header_below',
			'header_above',
			'footer_below',
			'footer_above',
			'background',
			'splash',
			'fixed_left',
			'fixed_right',
			'fixed_bottom',
			'popup'
		);

		/*
		 * Get a copy of the saved settings array.
		 */
		$to_saved_fields = get_option( $to_id .'_settings', array() );

		/*
		 * Theme options fields
		 */
		$to_fields = array(
			array(
				'id'    => 'general_settings',
				'label' => esc_html__( 'General', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Configure general options for the theme', 'sanfrancisco' ),
				'type'  => 'section',
				'icon'  => 'cogs'
			),
			array(
				'id'    => 'boxed_layout',
				'label' => esc_html__( 'Boxed Layout', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to be able to set background color to the full width page layout area.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'        => 'boxed_layout_background_color',
				'label'     => esc_html__( 'Boxed Layout Background Color', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Set background color to the full width page layout area.', 'sanfrancisco' ),
				'type'      => 'colorpicker',
				'alpha'     => true,
				'std'       => '#ffffff',
				'condition' => 'boxed_layout:is(true)'
			),
			array(
				'id' => 'responsive',
				'label' => esc_html__( 'Enable Responsive', 'sanfrancisco' ),
				'desc' => esc_html__( 'Disable this option if you don\'t want make the theme responsive.', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id'    => 'soft_transition',
				'label' => esc_html__( 'Soft Transition Effect on Navigate', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Disable this option if you don\'t want to add soft transition effect when navigate between pages', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'    => 'gp_zoom_hover',
				'label' => esc_html__( 'Zoom-in Grid Posts Image on Mouse Over', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Disable this option if you don\'t want to add zoom-in effect to the grid posts image on mouse over', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'        => 'advertisement',
				'label'     => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Select ads for any ad locations.', 'sanfrancisco' ),
				'type'      => 'advertisement',
				'locations' => $ad_locations_with_positions
			),
			array(
				'id'    => 'facebook_sdk',
				'label' => esc_html__( 'Add Facebook SDK to the header', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to use Facebook functionality in the theme. (i.e Facebook box widget)', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'true'
			),
			array(
				'id'    => 'amp_support',
				'label' => esc_html__( 'Native AMP Support', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to add native AMP support. More info: https://www.ampproject.org', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'true'
			),
			array(
				'id'    => 'header_settings',
				'label' => esc_html__( 'Header', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Configure header options for the theme', 'sanfrancisco' ),
				'type'  => 'section',
				'icon'  => 'graduation-cap'
			),
			array(
				'id' => 'header_style',
				'label' => esc_html__( 'Header Style', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'standard',
				'choices' => array(
					array(
						'text'  => esc_html__( 'Standard', 'sanfrancisco' ),
						'value' => 'standard'
					),
					array(
						'text'  => esc_html__( 'Centered', 'sanfrancisco' ),
						'value' => 'centered'
					),
					array(
						'text'  => esc_html__( 'Single Row (Logo + Nav Menu)', 'sanfrancisco' ),
						'value' => 'single_row'
					)
				)
			),
			array(
				'id' => 'sticky_header',
				'label' => esc_html__( 'Sticky Header', 'sanfrancisco' ),
				'desc' => esc_html__( 'Will make header stay in top of browser while scrolling down', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'display_header_logo_as_text',
				'label' => esc_html__( 'Display Logo as Text', 'sanfrancisco' ),
				'desc' => esc_html__( 'Using this option, you can make the logo either text or an image.', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'header_logo_text',
				'label' => esc_html__( 'Logo Text', 'sanfrancisco' ),
				'type' => 'text',
				'std' => SANFRANCISCO_THEME_TITLE,
				'condition' => 'display_header_logo_as_text:is(true)'
			),
			array(
				'id' => 'header_logo_url',
				'label' => esc_html__( 'Upload Logo', 'sanfrancisco' ),
				'type' => 'media',
				'media_type' => 'image',
				'condition' => 'display_header_logo_as_text:is(false)'
			),
			array(
				'id' => 'header_logo_retina_url',
				'label' => esc_html__( 'Upload Retina Logo', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use this option if you want your logo appear crystal clean in retina devices (eg. macbook retina, ipad, iphone).', 'sanfrancisco' ),
				'type' => 'media',
				'media_type' => 'image',
				'condition' => 'display_header_logo_as_text:is(false)'
			),
			array(
				'id' => 'header_logo_width',
				'label' => esc_html__( 'Logo Width', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use this option to set width of the logo.', 'sanfrancisco' ),
				'type' => 'range',
				'minmax' => '0,1140',
				'unit' => 'px',
				'std' => '240'
			),
			array(
				'id' => 'header_logo_padding_y',
				'label' => esc_html__( 'Logo Top & Bottom Spacing', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use this option to add spacing vertically for the logo.', 'sanfrancisco' ),
				'type' => 'range',
				'minmax' => '0,100',
				'unit' => 'px',
				'std' => '20'
			),
			array(
				'id' => 'display_header_logo_mobile_as_text',
				'label' => esc_html__( 'Display Header Mobile Logo as Text', 'sanfrancisco' ),
				'desc' => esc_html__( 'This option comes handy when your logo is just too long for a mobile device and you would like to upload a shorter and smaller logo just to fit the header area.', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'header_logo_mobile_text',
				'label' => esc_html__( 'Header Mobile Logo Text', 'sanfrancisco' ),
				'type' => 'text',
				'std' => SANFRANCISCO_THEME_TITLE,
				'condition' => 'display_header_logo_mobile_as_text:is(true)'
			),
			array(
				'id' => 'header_logo_mobile_url',
				'label' => esc_html__( 'Upload Header Mobile Logo', 'sanfrancisco' ),
				'type' => 'media',
				'media_type' => 'image',
				'condition' => 'display_header_logo_mobile_as_text:is(false)'
			),
			array(
				'id' => 'header_logo_mobile_retina_url',
				'label' => esc_html__( 'Upload Header Mobile Retina Logo', 'sanfrancisco' ),
				'type' => 'media',
				'media_type' => 'image',
				'condition' => 'display_header_logo_mobile_as_text:is(false)'
			),
			array(
				'id' => 'header_logo_mobile_width',
				'label' => esc_html__( 'Header Mobile Logo Width', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use this option to set width of the header mobile logo.', 'sanfrancisco' ),
				'type' => 'range',
				'minmax' => '0,768',
				'unit' => 'px',
				'std' => '240'
			),
			array(
				'id' => 'header_logo_mobile_padding_y',
				'label' => esc_html__( 'Header Mobile Logo Top & Bottom Spacing', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use this option to add spacing vertically for the header mobile logo.', 'sanfrancisco' ),
				'type' => 'range',
				'minmax' => '0,100',
				'unit' => 'px',
				'std' => '20'
			),
			array(
				'id' => 'display_header_search_icon',
				'label' => esc_html__( 'Display Search Icon', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id'    => 'display_trending_menu',
				'label' => esc_html__( 'Display Trending Menu', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'true'
			),
			array(
				'id' => 'footer_settings',
				'label' => esc_html__( 'Footer', 'sanfrancisco' ),
				'desc' => esc_html__( 'Configure footer options for the theme', 'sanfrancisco' ),
				'type' => 'section',
				'icon' => 'anchor'
			),
			array(
				'id' => 'display_footer',
				'label' => esc_html__( 'Display Footer', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to have footer section you can disable it.', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'display_footer_logo_as_text',
				'label' => esc_html__( 'Display Footer Logo as Text', 'sanfrancisco' ),
				'desc' => esc_html__( 'Using this option, you can make the footer logo either text or an image.', 'sanfrancisco' ),
				'type' => 'toggle',
				'condition' => 'display_footer:is(true),display_footer_branding:is(true)',
				'std' => 'true'
			),
			array(
				'id' => 'footer_logo_text',
				'label' => esc_html__( 'Footer Logo Text', 'sanfrancisco' ),
				'type' => 'text',
				'std' => SANFRANCISCO_THEME_TITLE,
				'condition' => 'display_footer:is(true),display_footer_branding:is(true),display_footer_logo_as_text:is(true)',
				'operator' => 'and'
			),
			array(
				'id' => 'footer_logo_url',
				'label' => esc_html__( 'Upload Footer Logo', 'sanfrancisco' ),
				'type' => 'media',
				'media_type' => 'image',
				'condition' => 'display_footer:is(true),display_footer_branding:is(true),display_footer_logo_as_text:is(false)',
				'operator' => 'and'
			),
			array(
				'id' => 'footer_logo_retina_url',
				'label' => esc_html__( 'Upload Retina Footer Logo', 'sanfrancisco' ),
				'desc' => 'Use this option if you want your footer logo appear crystal clean in retina devices (eg. macbook retina, ipad, iphone).',
				'type' => 'media',
				'media_type' => 'image',
				'condition' => 'display_footer:is(true),display_footer_branding:is(true),display_footer_logo_as_text:is(false)',
				'operator' => 'and'
			),
			array(
				'id' => 'display_footer_logo_mobile_as_text',
				'label' => esc_html__( 'Display Footer Mobile Logo as Text', 'sanfrancisco' ),
				'desc' => esc_html__( 'This option comes handy when your logo is just too long for a mobile device and you would like to upload a shorter and smaller logo just to fit the footer area.', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'footer_logo_mobile_text',
				'label' => esc_html__( 'Footer Mobile Logo Text', 'sanfrancisco' ),
				'type' => 'text',
				'std' => SANFRANCISCO_THEME_TITLE,
				'condition' => 'display_footer_logo_mobile_as_text:is(true)'
			),
			array(
				'id' => 'footer_logo_mobile_url',
				'label' => esc_html__( 'Upload Footer Mobile Logo', 'sanfrancisco' ),
				'type' => 'media',
				'media_type' => 'image',
				'condition' => 'display_footer_logo_mobile_as_text:is(false)'
			),
			array(
				'id' => 'footer_logo_mobile_retina_url',
				'label' => esc_html__( 'Upload Footer Mobile Retina Logo', 'sanfrancisco' ),
				'type' => 'media',
				'media_type' => 'image',
				'condition' => 'display_footer_logo_mobile_as_text:is(false)'
			),
			array(
				'id' => 'display_footer_branding',
				'label' => esc_html__( 'Display Footer Branding Area', 'sanfrancisco' ),
				'desc' => esc_html__( 'Using this option, you can disable branding area in the footer.', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true',
				'condition' => 'display_footer:is(true)'
			),
			array(
				'id' => 'footer_branding_description',
				'label' => esc_html__( 'Footer Branding Description', 'sanfrancisco' ),
				'type' => 'textarea',
				'condition' => 'display_footer:is(true),display_footer_branding:is(true)',
				'operator' => 'and'
			),
			array(
				'id' => 'display_footer_sidebars',
				'label' => esc_html__( 'Display Footer Widget Areas', 'sanfrancisco' ),
				'desc' => esc_html__( 'Using this option, you can disable widgetized areas in the footer.', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true',
			    'condition' => 'display_footer:is(true)'
			),
			array(
				'id' => 'display_sub_footer',
				'label' => esc_html__( 'Display Sub Footer', 'sanfrancisco' ),
				'desc' => esc_html__( 'Sub footer locates below footer. If you don\'t want to have sub footer section you can disable it.', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true',
				'condition' => 'display_footer:is(true)'
			),
			array(
				'id' => 'footer_copyright_text',
				'label' => esc_html__( 'Sub Footer Copyright Text', 'sanfrancisco' ),
				'desc' => esc_html__( 'You may write your site copyright information.', 'sanfrancisco' ),
				'type' => 'textarea',
				'condition' => 'display_footer:is(true),display_sub_footer:is(true)',
				'operator' => 'and'
			),
			array(
				'id' => 'display_footer_nav',
			    'label' => esc_html__( 'Display Footer Menu', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true',
				'condition' => 'display_footer:is(true),display_sub_footer:is(true)',
				'operator' => 'and'
			),
			array(
				'id' => 'sidebar_settings',
				'label' => esc_html__( 'Sidebars', 'sanfrancisco' ),
				'desc' => esc_html__( 'Set default sidebar for the theme or create one', 'sanfrancisco' ),
				'type' => 'section',
				'icon' => 'columns'
			),
			array(
				'id' => 'sidebar',
				'label' => esc_html__( 'Default Sidebar', 'sanfrancisco' ),
				'desc' => esc_html__( 'Please choose default sidebar for the theme', 'sanfrancisco' ),
				'type' => 'sidebar_select',
				'std' => 'sanfrancisco-default-sidebar'
			),
			array(
				'id' => 'sidebar_position',
				'label' => esc_html__( 'Sidebar Position', 'sanfrancisco' ),
				'desc' => esc_html__( 'Set default sidebar position for the pages', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => is_rtl() ? 'left' : 'right',
				'choices' => array(
					array(
						'text' => esc_html__( 'Left', 'sanfrancisco' ),
						'value' => 'left'
					),
					array(
						'text' => esc_html__( 'Right', 'sanfrancisco' ),
						'value' => 'right'
					)
				)
			),
			array(
				'id' => 'sticky_sidebar',
				'label' => esc_html__( 'Sticky Sidebar', 'sanfrancisco' ),
				'desc' => esc_html__( 'Will make header stay visible in viewport while scrolling down', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'custom_sidebars',
				'label' => esc_html__( 'Create Custom Sidebar', 'sanfrancisco' ),
				'desc' => esc_html__( 'You may create custom sidebars and use them in specific pages of the theme.', 'sanfrancisco' ),
				'type' => 'sidebar_create'
			),
			array(
				'id' => 'mega_menu',
				'label' => esc_html__( 'Mega Menu / Trending', 'sanfrancisco' ),
				'desc' => esc_html__( 'Configure options to how mega menu and trending posts will display', 'sanfrancisco' ),
				'type' => 'section',
				'icon' => 'map-signs'
			),
			array(
				'id' => 'trending_posts_tab',
				'label' => esc_html__( 'Trending Posts', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id'    => 'trending_auto_detect',
				'label' => esc_html__( 'Automatically Detect Trending Posts', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option in order for the theme to detect trending posts automatically. Alternatively you can mark any post/page as trending from post edit screen. Note: this option only works with JetPack\'s stats module.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'true'
			),
			array(
				'id'      => 'trending_posts_layout',
				'label'   => esc_html__( 'Trending Menu - Posts Layout', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Choose any layout to show posts in trending menu.', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'vertical_4_col',
				'choices' => array(
					array(
						'alt'   => esc_html__( 'Three Columns Vertical', 'sanfrancisco' ),
						'value' => 'vertical_3_col',
						'image' => sanfrancisco_locate_template_uri( 'library/admin/images/grid-three-columns-vertical.jpg' )
					),
					array(
						'alt'   => esc_html__( 'Four Columns Vertical', 'sanfrancisco' ),
						'value' => 'vertical_4_col',
						'image' => sanfrancisco_locate_template_uri( 'library/admin/images/grid-four-columns-vertical.jpg' )
					),
					array(
						'alt'   => esc_html__( 'Two Columns Horizontal', 'sanfrancisco' ),
						'value' => 'horizontal_2_col',
						'image' => sanfrancisco_locate_template_uri( 'library/admin/images/grid-two-columns-horizontal.jpg' )
					),
					array(
						'alt'   => esc_html__( 'Three Columns Horizontal', 'sanfrancisco' ),
						'value' => 'horizontal_3_col',
						'image' => sanfrancisco_locate_template_uri( 'library/admin/images/grid-three-columns-horizontal.jpg' )
					)
				)
			),
			array(
				'id'        => 'trending_posts_number',
				'label'     => esc_html__( 'Trending Menu - Number of Posts', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'    => '1,10',
				'std'       => '4'
			),
			array(
				'id'    => 'trending_posts_excluded_ids',
				'label' => esc_html__( 'Trending Menu - Excluded Post Id\'s', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Specify excluded post ids separated by comma. i.e. 45,73,132,19', 'sanfrancisco' ),
				'type'  => 'text'
			),
			array(
				'id'      => 'trending_posts_orderby',
				'label'   => esc_html__( 'Trending Menu - Order Posts by', 'sanfrancisco' ),
				'type'    => 'select',
				'std'     => 'views',
				'choices' => $orderby_choices
			),
			array(
				'id'      => 'trending_posts_order',
				'label'   => esc_html__( 'Trending Menu - Posts Order Type', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'desc',
				'choices' => $order_choices
			),
			array(
				'id'      => 'trending_posts_meta_data',
				'label'   => esc_html__( 'Trending Menu - Posts Meta Data', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Check which meta data to show for the posts in the trending menu', 'sanfrancisco' ),
				'type'    => 'checker',
				'std'     => array(
					'views',
					'likes',
					'comments',
					'trending_icon'
				),
				'choices' => array(
					array(
						'label' => esc_html__( 'Excerpt', 'sanfrancisco' ),
						'value' => 'excerpt'
					),
					array(
						'label' => esc_html__( 'Date', 'sanfrancisco' ),
						'value' => 'date'
					),
					array(
						'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
						'value' => 'byline'
					),
					array(
						'label' => esc_html__( 'Views', 'sanfrancisco' ),
						'value' => 'views'
					),
					array(
						'label' => esc_html__( 'Likes', 'sanfrancisco' ),
						'value' => 'likes'
					),
					array(
						'label' => esc_html__( 'Comments', 'sanfrancisco' ),
						'value' => 'comments'
					),
					array(
						'label' => esc_html__( 'Category Name', 'sanfrancisco' ),
						'value' => 'category'
					),
					array(
						'label' => esc_html__( 'Trending Icon', 'sanfrancisco' ),
						'value' => 'trending_icon'
					)
				)
			),
			array(
				'id'        => 'trending_posts_excerpt_length',
				'label'     => 'Trending Menu - Posts Excerpt Length',
				'desc'      => esc_html__( 'Choose how long will the excerpt be display for the trending menu posts', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'    => '0,100',
				'std'       => '30',
				'condition' => 'trending_posts_meta_data:has(excerpt)'
			),
			array(
				'id'    => 'trending_posts_display_tags',
				'label' => esc_html__( 'Trending Menu - Display Tags on Posts', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option if you want post tags to be shown on the trending menu posts.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'        => 'trending_posts_tag_limit',
				'label'     => esc_html__( 'Trending Menu - Posts Tag Limit', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose maximum number of tags to display on the trending menu posts.', 'sanfrancisco' ),
				'type'      => 'range',
				'std'       => 3,
				'minmax'    => '1,25',
				'condition' => 'trending_posts_display_tags:is(true)'
			),
			array(
				'id' => 'blog',
				'label' => esc_html__( 'Blog', 'sanfrancisco' ),
				'desc' => esc_html__( 'Configure default layout options for posts and archive pages', 'sanfrancisco' ),
				'type' => 'section',
				'icon' => 'pencil-square-o'
			),
			array(
				'id' => 'blog_single',
				'label' => esc_html__( 'Single Post', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id'    => 'boxed_layout__single',
				'label' => esc_html__( 'Boxed Layout', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to be able to set background color to the full width page layout area for blog single posts.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'        => 'boxed_layout_background_color__single',
				'label'     => esc_html__( 'Boxed Layout Background Color', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Set background color to the full width page layout area for blog single posts.', 'sanfrancisco' ),
				'type'      => 'colorpicker',
				'alpha'     => true,
				'std'       => '#ffffff',
				'condition' => 'boxed_layout__single:is(true)'
			),
			array(
				'id' => 'layout__single',
				'label' => esc_html__( 'Layout', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'ws',
				'choices' => array(
					array(
						'text' => esc_html__( 'Full Width Content', 'sanfrancisco' ),
						'value' => 'full'
					),
					array(
						'text' => esc_html__( 'Content with Sidebar', 'sanfrancisco' ),
						'value' => 'ws'
					)
				)
			),
			array(
				'id'      => 'background_inheritance__single',
				'label'   => esc_html__( 'Background', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Use global background settings (Skin &gt; Background) or set custom background for blog single posts', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Background', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'background__single',
				'label'     => esc_html__( 'Set Background', 'sanfrancisco' ),
				'type'      => 'background',
				'std'       => $background_std,
				'condition' => 'background_inheritance__single:is(custom)'
			),
			array(
				'id' => 'sidebar__single',
				'label' => esc_html__( 'Sidebar', 'sanfrancisco' ),
				'type' => 'sidebar_select',
				'std' => 'sanfrancisco-default-sidebar',
				'condition' => 'layout__single:is(ws)'
			),
			array(
				'id' => 'sidebar_position__single',
				'label' => esc_html__( 'Sidebar Position', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => is_rtl() ? 'left' : 'right',
				'choices' => array(
					array(
						'text' => esc_html__( 'Left', 'sanfrancisco' ),
						'value' => 'left'
					),
					array(
						'text' => esc_html__( 'Right', 'sanfrancisco' ),
						'value' => 'right'
					)
				),
				'condition' => 'layout__single:is(ws)'
			),
			array(
				'id' => 'display_breadcrumb__single',
				'label' => esc_html__( 'Display Breadcrumb', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show breadcrumb in blog single posts, disable this option.', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'display_title__single',
				'label' => esc_html__( 'Display Title', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show page title in blog single posts, disable this option.', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'display_title_subline__single',
				'label' => esc_html__( 'Display Title Subline', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show page title subline in blog single posts, disable this option', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id'    => 'display_featured_image__single',
				'label' => esc_html__( 'Display Featured Image', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show featured image in blog single posts, disable this option', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'true'
			),
			/*array(
				'id'        => 'featured_image_style__single',
				'label'     => esc_html__( 'Featured Image Style', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose how featured image will display in blog single posts.', 'sanfrancisco' ),
				'type'      => 'radio_select',
				'std'       => 'cl',
				'choices'   => array(
					array(
						'text'  => esc_html__( 'Classic', 'sanfrancisco' ),
						'value' => 'cl'
					),
					array(
						'text'  => esc_html__( 'Full Width', 'sanfrancisco' ),
						'value' => 'fw'
					),
					array(
						'text'  => esc_html__( 'Screen Width', 'sanfrancisco' ),
						'value' => 'sw'
					)
				),
				'condition' => 'display_featured_image__single:is(true)'
			),
			array(
				'id'        => 'featured_image_has_parallax__single',
				'label'     => esc_html__( 'Apply Parallax to the Featured Image', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Enable this option to apply parallax feature to the featured image in blog single posts.', 'sanfrancisco' ),
				'type'      => 'toggle',
				'std'       => 'false',
				'condition' => 'featured_image_style__single:not(cl)'
			),*/
			array(
				'id' => 'display_credit_line__single',
				'label' => esc_html__( 'Display Credit Line Over Featured Image', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show credit line over featured image in blog single posts, disable this option', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true',
				'condition' => 'display_featured_image__single:is(true)'
			),
			array(
				'id' => 'display_content__single',
				'label' => esc_html__( 'Display Content', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show page content in blog single posts, disable this option.', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id'    => 'dropcap__single',
				'label' => esc_html__( 'Apply Drop Cap', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Create a large dropped initial capital letter for the post content', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id' => 'meta_data__single',
				'label' => esc_html__( 'Meta Data', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose which meta data to show in blog single posts.', 'sanfrancisco' ),
				'type' => 'checker',
				'std' => array( 'date', 'byline', 'views', 'likes', 'comments', 'category', 'trending_icon' ),
				'choices' => array(
					array(
						'label' => esc_html__( 'Date', 'sanfrancisco' ),
						'value' => 'date'
					),
					array(
						'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
						'value' => 'byline'
					),
					array(
						'label' => esc_html__( 'Views', 'sanfrancisco' ),
						'value' => 'views'
					),
					array(
						'label' => esc_html__( 'Likes', 'sanfrancisco' ),
						'value' => 'likes'
					),
					array(
						'label' => esc_html__( 'Comments', 'sanfrancisco' ),
						'value' => 'comments'
					),
					array(
						'label' => esc_html__( 'Category Name', 'sanfrancisco' ),
						'value' => 'category'
					),
					array(
						'label' => esc_html__( 'Trending Icon', 'sanfrancisco' ),
						'value' => 'trending_icon'
					)
				)
			),
			array(
				'id'    => 'display_like_button__single',
				'label' => esc_html__( 'Display Like Button', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show like button in blog single posts, disable this option.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'true'
			),
			array(
				'id' => 'display_tags__single',
				'label' => esc_html__( 'Display Post Tags', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show post tags in blog single posts, disable this option.', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id'        => 'tag_limit__single',
				'label'     => esc_html__( 'Tag Limit', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose maximum number of tags to display', 'sanfrancisco' ),
				'type'      => 'range',
				'std'       => 3,
				'minmax'     => '1,25',
				'condition' => 'display_tags__single:is(true)'
			),
			array(
				'id' => 'display_related_posts__single',
				'label' => esc_html__( 'Display Related Posts', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show related posts in blog single posts, disable this option.', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'true'
			),
		    array(
		    	'id' => 'related_posts_layout__single',
			    'label' => esc_html__( 'Related Posts Layout', 'sanfrancisco' ),
			    'type' => 'radio_select',
			    'std' => 'vertical_3_col',
			    'choices' => $gp_posts_layout_choices,
			    'condition' => 'display_related_posts__single:is(true)'
			),
		    array(
		    	'id' => 'related_posts_per_page__single',
			    'label' => esc_html__( 'Number of Related Posts', 'sanfrancisco' ),
			    'type' => 'range',
			    'std' => '3',
			    'minmax' => '1,100',
			    'condition' => 'display_related_posts__single:is(true)'
			),
		    array(
		        'id' => 'related_posts_excluded_post_ids__single',
		        'label' => esc_html__( 'Excluded Related Post Id\'s', 'sanfrancisco' ),
		        'desc' => esc_html__( 'Specify excluded post ids separated by comma. i.e. 45,73,132,19', 'sanfrancisco' ),
				'type' => 'text',
		        'condition' => 'display_related_posts__single:is(true)'
			),
			array(
				'id'        => 'related_posts_orderby__single',
				'label'     => esc_html__( 'Order Related Posts by', 'sanfrancisco' ),
				'type'      => 'select',
				'std'       => 'date',
				'choices'   => $orderby_choices,
				'condition' => 'display_related_posts__single:is(true)'
			),
			array(
				'id'        => 'related_posts_order__single',
				'label'     => esc_html__( 'Related Posts Order Type', 'sanfrancisco' ),
				'type'      => 'radio_select',
				'std'       => 'desc',
				'choices'   => $order_choices,
				'condition' => 'display_related_posts__single:is(true)'
			),
			array(
				'id' => 'related_posts_meta_data__single',
				'label' => esc_html__( 'Related Posts Meta Data', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose which meta data to show in related posts', 'sanfrancisco' ),
				'type' => 'checker',
				'std' => array( 'views', 'likes', 'comments' ),
				'choices' => array(
					array(
						'label' => esc_html__( 'Excerpt', 'sanfrancisco' ),
						'value' => 'excerpt'
					),
					array(
						'label' => esc_html__( 'Date', 'sanfrancisco' ),
						'value' => 'date'
					),
					array(
						'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
						'value' => 'byline'
					),
					array(
						'label' => esc_html__( 'Views', 'sanfrancisco' ),
						'value' => 'views'
					),
					array(
						'label' => esc_html__( 'Likes', 'sanfrancisco' ),
						'value' => 'likes'
					),
					array(
						'label' => esc_html__( 'Comments', 'sanfrancisco' ),
						'value' => 'comments'
					),
					array(
						'label' => esc_html__( 'Category Name', 'sanfrancisco' ),
						'value' => 'category'
					),
					array(
						'label' => esc_html__( 'Trending Icon', 'sanfrancisco' ),
						'value' => 'trending_icon'
					)
				),
				'condition' => 'display_related_posts__single:is(true)'
			),
			array(
				'id'        => 'related_posts_excerpt_length__single',
				'label'     => 'Related Posts Excerpt Length',
				'desc'      => esc_html__( 'Choose how long will the excerpt be display for the related posts', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'     => '0,200',
				'std'       => '50',
				'condition' => 'display_related_posts__single:is(true)'
			),
			array(
				'id' => 'display_author_info__single',
				'label' => esc_html__( 'Display About Author Section', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show about author section in blog single posts, disable this option.', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id'    => 'display_comments__single',
				'label' => esc_html__( 'Display Comments', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show comments in blog single posts, disable this option.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'true'
			),
			array(
				'id'    => 'is_trending__single',
				'label' => esc_html__( 'Mark as Trending', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to mark blog single posts as "trending post" manually.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id' => 'advertisement_inheritance__single',
				'label' => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use global advertisement settings (General &gt; Advertisment) or select custom ads for single posts.', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Ads', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'advertisement__single',
				'label'     => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Select ads for any ad locations.', 'sanfrancisco' ),
				'type'      => 'advertisement',
				'locations' => array_merge( array( 'post' ), $ad_locations_with_positions ),
				'condition' => 'advertisement_inheritance__single:is(custom)'
			),
			array(
				'id' => 'override__single',
				'label' => esc_html__( 'Override these options for all posts', 'sanfrancisco' ),
				'desc' => esc_html__( 'Enable this option if you want to override these options for all blog single posts', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'false'
			),
			array(
				'id' => 'blog_page',
				'label' => esc_html__( 'Page', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id'    => 'boxed_layout__page',
				'label' => esc_html__( 'Boxed Layout', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to be able to set background color to the full width page layout area for pages.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'        => 'boxed_layout_background_color__page',
				'label'     => esc_html__( 'Boxed Layout Background Color', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Set background color to the full width page layout area for pages.', 'sanfrancisco' ),
				'type'      => 'colorpicker',
				'alpha'     => true,
				'std'       => '#ffffff',
				'condition' => 'boxed_layout__page:is(true)'
			),
			array(
				'id' => 'layout__page',
				'label' => esc_html__( 'Layout', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'ws',
				'choices' => array(
					array(
						'text' => esc_html__( 'Full Width Content', 'sanfrancisco' ),
						'value' => 'full'
					),
					array(
						'text' => esc_html__( 'Content with Sidebar', 'sanfrancisco' ),
						'value' => 'ws'
					)
				)
			),
			array(
				'id'      => 'background_inheritance__page',
				'label'   => esc_html__( 'Background', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Use global background settings (Skin &gt; Background) or set custom background for pages', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Background', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'background__page',
				'label'     => esc_html__( 'Set Background', 'sanfrancisco' ),
				'type'      => 'background',
				'std'       => $background_std,
				'condition' => 'background_inheritance__page:is(custom)'
			),
			array(
				'id' => 'sidebar__page',
				'label' => esc_html__( 'Sidebar', 'sanfrancisco' ),
				'type' => 'sidebar_select',
				'std' => 'sanfrancisco-default-sidebar',
				'condition' => 'layout__page:is(ws)'
			),
			array(
				'id' => 'sidebar_position__page',
				'label' => esc_html__( 'Sidebar Position', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => is_rtl() ? 'left' : 'right',
				'choices' => array(
					array(
						'text' => esc_html__( 'Left', 'sanfrancisco' ),
						'value' => 'left'
					),
					array(
						'text' => esc_html__( 'Right', 'sanfrancisco' ),
						'value' => 'right'
					)
				),
				'condition' => 'layout__page:is(ws)'
			),
			array(
				'id' => 'display_breadcrumb__page',
				'label' => esc_html__( 'Display Breadcrumb', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show breadcrumb in pages, disable this option.', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'false'
			),
			array(
				'id' => 'display_title__page',
				'label' => esc_html__( 'Display Title', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show page title in pages, disable this option.', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'display_title_subline__page',
				'label' => esc_html__( 'Display Title Subline', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show page title subline in pages, disable this option.', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id'    => 'display_featured_image__page',
				'label' => esc_html__( 'Display Featured Image', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show featured image in pages, disable this option', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'true'
			),
			/*array(
				'id'        => 'featured_image_style__page',
				'label'     => esc_html__( 'Featured Image Style', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose how featured image will display in pages.', 'sanfrancisco' ),
				'type'      => 'radio_select',
				'std'       => 'cl',
				'choices'   => array(
					array(
						'text'  => esc_html__( 'Classic', 'sanfrancisco' ),
						'value' => 'cl'
					),
					array(
						'text'  => esc_html__( 'Full Width', 'sanfrancisco' ),
						'value' => 'fw'
					),
					array(
						'text'  => esc_html__( 'Screen Width', 'sanfrancisco' ),
						'value' => 'sw'
					)
				),
				'condition' => 'display_featured_image__page:is(true)'
			),
			array(
				'id'        => 'featured_image_has_parallax__page',
				'label'     => esc_html__( 'Apply Parallax to the Featured Image', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Enable this option to apply parallax feature to the featured image in pages.', 'sanfrancisco' ),
				'type'      => 'toggle',
				'std'       => 'false',
				'condition' => 'featured_image_style__page:not(cl)'
			),*/
			array(
				'id' => 'display_credit_line__page',
				'label' => esc_html__( 'Display Credit Line Over Featured Image', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show credit line over featured image in pages, disable this option', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true',
				'condition' => 'display_featured_image__page:is(true)'
			),
			array(
				'id'    => 'display_content__page',
				'label' => esc_html__( 'Display Content', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show page content in pages, disable this option.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'true'
			),
			array(
				'id'    => 'dropcap__page',
				'label' => esc_html__( 'Apply Drop Cap', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Create a large dropped initial capital letter for the page content', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id' => 'meta_data__page',
				'label' => esc_html__( 'Meta Data', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose which meta data to show in pages', 'sanfrancisco' ),
				'type' => 'checker',
				'std' => array( 'date', 'byline', 'views', 'likes', 'comments' ),
				'choices' => array(
					array(
						'label' => esc_html__( 'Date', 'sanfrancisco' ),
						'value' => 'date'
					),
					array(
						'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
						'value' => 'byline'
					),
					array(
						'label' => esc_html__( 'Views', 'sanfrancisco' ),
						'value' => 'views'
					),
					array(
						'label' => esc_html__( 'Likes', 'sanfrancisco' ),
						'value' => 'likes'
					),
					array(
						'label' => esc_html__( 'Comments', 'sanfrancisco' ),
						'value' => 'comments'
					)
				)
			),
			array(
				'id'    => 'display_like_button__page',
				'label' => esc_html__( 'Display Like Button', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show like button in pages, disable this option.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id' => 'display_author_info__page',
				'label' => esc_html__( 'Display About Author Section', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show about author section in pages, disable this option.', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'false'
			),
			array(
				'id' => 'display_comments__page',
				'label' => esc_html__( 'Display Comments', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show comments in pages, disable this option.', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id'    => 'is_trending__page',
				'label' => esc_html__( 'Mark as Trending', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to mark pages as "trending post" manually.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id' => 'advertisement_inheritance__page',
				'label' => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use global advertisement settings (General &gt; Advertisment) or select custom ads for pages.', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Ads', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'advertisement__page',
				'label'     => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Select ads for any ad locations.', 'sanfrancisco' ),
				'type'      => 'advertisement',
				'locations' => array_merge( array( 'post' ), $ad_locations_with_positions ),
				'condition' => 'advertisement_inheritance__page:is(custom)'
			),
			array(
				'id' => 'override__page',
				'label' => esc_html__( 'Override these options for all pages', 'sanfrancisco' ),
				'desc' => esc_html__( 'Enable this option if you want to override these options for all pages', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'false'
			),
			array(
				'id' => 'blog_category',
				'label' => esc_html__( 'Category', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id'    => 'boxed_layout__category',
				'label' => esc_html__( 'Boxed Layout', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to be able to set background color to the full width page layout area for category pages.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'        => 'boxed_layout_background_color__category',
				'label'     => esc_html__( 'Boxed Layout Background Color', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Set background color to the full width page layout area for category pages.', 'sanfrancisco' ),
				'type'      => 'colorpicker',
				'alpha'     => true,
				'std'       => '#ffffff',
				'condition' => 'boxed_layout__category:is(true)'
			),
			array(
				'id' => 'layout__category',
				'label' => esc_html__( 'Layout', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'ws',
				'choices' => array(
					array(
						'text' => 'Full Width Posts',
						'value' => 'full'
					),
					array(
						'text' => 'Posts with Sidebar',
						'value' => 'ws'
					)
				)
			),
			array(
				'id'      => 'background_inheritance__category',
				'label'   => esc_html__( 'Background', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Use global background settings (Skin &gt; Background) or set custom background for category pages', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Background', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'background__category',
				'label'     => esc_html__( 'Set Background', 'sanfrancisco' ),
				'type'      => 'background',
				'std'       => $background_std,
				'condition' => 'background_inheritance__category:is(custom)'
			),
			array(
				'id' => 'posts_layout__category',
				'label' => esc_html__( 'Posts Layout', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose any layout to show posts in category pages.', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'vertical_1_col',
				'choices' => $gp_posts_layout_choices
			),
			array(
				'id' => 'pagination_type__category',
				'label' => esc_html__( 'Pagination Type', 'sanfrancisco' ),
				'type' => 'select',
				'std' => 'numeric',
				'choices' => $gp_pagination_choices
			),
			array(
				'id' => 'sidebar__category',
				'label' => esc_html__( 'Sidebar', 'sanfrancisco' ),
				'type' => 'sidebar_select',
				'std' => 'sanfrancisco-default-sidebar',
				'condition' => 'layout__category:is(ws)'
			),
			array(
				'id' => 'sidebar_position__category',
				'label' => esc_html__( 'Sidebar Position', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => is_rtl() ? 'left' : 'right',
				'choices' => array(
					array(
						'text' => esc_html__( 'Left', 'sanfrancisco' ),
						'value' => 'left'
					),
					array(
						'text' => esc_html__( 'Right', 'sanfrancisco' ),
						'value' => 'right'
					)
				),
				'condition' => 'layout__category:is(ws)'
			),
			array(
				'id' => 'display_title__category',
				'label' => esc_html__( 'Display Title', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show main title in category pages, disable this option.', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'display_breadcrumb__category',
				'label' => esc_html__( 'Display Breadcrumb', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show breadcrumb in category pages, disable this option.', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'meta_data__category',
				'label' => esc_html__( 'Meta Data', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose which meta data to show in category pages', 'sanfrancisco' ),
				'type' => 'checker',
				'std' => array( 'excerpt', 'date', 'byline', 'views', 'likes', 'comments', 'trending_icon' ),
				'choices' => array(
					array(
						'label' => esc_html__( 'Excerpt', 'sanfrancisco' ),
						'value' => 'excerpt'
					),
					array(
						'label' => esc_html__( 'Date', 'sanfrancisco' ),
						'value' => 'date'
					),
					array(
						'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
						'value' => 'byline'
					),
					array(
						'label' => esc_html__( 'Views', 'sanfrancisco' ),
						'value' => 'views'
					),
					array(
						'label' => esc_html__( 'Likes', 'sanfrancisco' ),
						'value' => 'likes'
					),
					array(
						'label' => esc_html__( 'Comments', 'sanfrancisco' ),
						'value' => 'comments'
					),
					array(
						'label' => esc_html__( 'Category Name', 'sanfrancisco' ),
						'value' => 'category'
					),
					array(
						'label' => esc_html__( 'Trending Icon', 'sanfrancisco' ),
						'value' => 'trending_icon'
					)
				)
			),
			array(
				'id'        => 'excerpt_length__category',
				'label'     => 'Excerpt Length',
				'desc'      => esc_html__( 'Choose how long will the excerpt be display for the posts in category pages', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'     => '0,200',
				'std'       => '50',
				'condition' => 'meta_data__category:has(excerpt)'
			),
			array(
				'id'        => 'display_tags__category',
				'label'     => esc_html__( 'Display Tags', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Enable this option if you want post tags to be shown in the posts in category pages.', 'sanfrancisco' ),
				'type'      => 'toggle',
				'std'       => 'true'
			),
			array(
				'id'        => 'tag_limit__category',
				'label'     => esc_html__( 'Tag Limit', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose maximum number of tags to display', 'sanfrancisco' ),
				'type'      => 'range',
				'std'       => 3,
				'minmax'     => '1,25',
				'condition' => 'display_tags__category:is(true)'
			),
			array(
				'id' => 'advertisement_inheritance__category',
				'label' => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use global advertisement settings (General &gt; Advertisment) or select custom ads for category pages.', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Ads', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'advertisement__category',
				'label'     => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Select ads for any ad locations.', 'sanfrancisco' ),
				'type'      => 'advertisement',
				'locations' => $ad_locations_with_positions,
				'condition' => 'advertisement_inheritance__category:is(custom)'
			),
			array(
				'id' => 'override__category',
				'label' => esc_html__( 'Override these options for all category pages', 'sanfrancisco' ),
				'desc' => esc_html__( 'Enable this option if you want to override these options for all category pages', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'false'
			),
			array(
				'id' => 'blog_author',
				'label' => esc_html__( 'Author', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id'    => 'boxed_layout__author',
				'label' => esc_html__( 'Boxed Layout', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to be able to set background color to the full width page layout area for author post pages.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'        => 'boxed_layout_background_color__author',
				'label'     => esc_html__( 'Boxed Layout Background Color', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Set background color to the full width page layout area for author post pages.', 'sanfrancisco' ),
				'type'      => 'colorpicker',
				'alpha'     => true,
				'std'       => '#ffffff',
				'condition' => 'boxed_layout__author:is(true)'
			),
			array(
				'id' => 'layout__author',
				'label' => esc_html__( 'Layout', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'ws',
				'choices' => array(
					array(
						'text' => 'Full Width Posts',
						'value' => 'full'
					),
					array(
						'text' => 'Posts with Sidebar',
						'value' => 'ws'
					)
				)
			),
			array(
				'id'      => 'background_inheritance__author',
				'label'   => esc_html__( 'Background', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Use global background settings (Skin &gt; Background) or set custom background for author posts pages', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Background', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'background__author',
				'label'     => esc_html__( 'Set Background', 'sanfrancisco' ),
				'type'      => 'background',
				'std'       => $background_std,
				'condition' => 'background_inheritance__author:is(custom)'
			),
			array(
				'id' => 'posts_layout__author',
				'label' => esc_html__( 'Posts Layout', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose any layout to show posts in author post pages.', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'vertical_1_col',
				'choices' => $gp_posts_layout_choices
			),
			array(
				'id' => 'pagination_type__author',
				'label' => esc_html__( 'Pagination Type', 'sanfrancisco' ),
				'type' => 'select',
				'std' => 'numeric',
				'choices' => $gp_pagination_choices
			),
			array(
				'id' => 'sidebar__author',
				'label' => esc_html__( 'Sidebar', 'sanfrancisco' ),
				'type' => 'sidebar_select',
				'std' => 'sanfrancisco-default-sidebar',
				'condition' => 'layout__author:is(ws)'
			),
			array(
				'id' => 'sidebar_position__author',
				'label' => esc_html__( 'Sidebar Position', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => is_rtl() ? 'left' : 'right',
				'choices' => array(
					array(
						'text' => esc_html__( 'Left', 'sanfrancisco' ),
						'value' => 'left'
					),
					array(
						'text' => esc_html__( 'Right', 'sanfrancisco' ),
						'value' => 'right'
					)
				),
				'condition' => 'layout__author:is(ws)'
			),
			array(
				'id' => 'display_title__author',
				'label' => esc_html__( 'Display Title', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show main title in author posts pages, disable this option.', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'display_breadcrumb__author',
				'label' => esc_html__( 'Display Breadcrumb', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show breadcrumb in author posts pages, disable this option', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'display_author_info__author',
				'label' => esc_html__( 'Display About Author Section', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show about author section in author posts pages, disable this option.', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'meta_data__author',
				'label' => esc_html__( 'Meta Data', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose which meta data to show in author posts pages', 'sanfrancisco' ),
				'type' => 'checker',
				'std' => array( 'excerpt', 'date', 'views', 'likes', 'comments', 'category', 'trending_icon' ),
				'choices' => array(
					array(
						'label' => esc_html__( 'Excerpt', 'sanfrancisco' ),
						'value' => 'excerpt'
					),
					array(
						'label' => esc_html__( 'Date', 'sanfrancisco' ),
						'value' => 'date'
					),
					array(
						'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
						'value' => 'byline'
					),
					array(
						'label' => esc_html__( 'Views', 'sanfrancisco' ),
						'value' => 'views'
					),
					array(
						'label' => esc_html__( 'Likes', 'sanfrancisco' ),
						'value' => 'likes'
					),
					array(
						'label' => esc_html__( 'Comments', 'sanfrancisco' ),
						'value' => 'comments'
					),
					array(
						'label' => esc_html__( 'Category Name', 'sanfrancisco' ),
						'value' => 'category'
					),
					array(
						'label' => esc_html__( 'Trending Icon', 'sanfrancisco' ),
						'value' => 'trending_icon'
					)
				)
			),
			array(
				'id'        => 'excerpt_length__author',
				'label'     => 'Excerpt Length',
				'desc'      => esc_html__( 'Choose how long will the excerpt be display for the posts in author pages', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'     => '0,200',
				'std'       => '50',
				'condition' => 'meta_data__author:has(excerpt)'
			),
			array(
				'id'        => 'display_tags__author',
				'label'     => esc_html__( 'Display Tags', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Enable this option if you want post tags to be shown in the posts in author pages.', 'sanfrancisco' ),
				'type'      => 'toggle',
				'std'       => 'true'
			),
			array(
				'id'        => 'tag_limit__author',
				'label'     => esc_html__( 'Tag Limit', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose maximum number of tags to display', 'sanfrancisco' ),
				'type'      => 'range',
				'std'       => 3,
				'minmax'     => '1,25',
				'condition' => 'display_tags__author:is(true)'
			),
			array(
				'id' => 'advertisement_inheritance__author',
				'label' => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use global advertisement settings (General &gt; Advertisment) or select custom ads for author pages.', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Ads', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'advertisement__author',
				'label'     => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Select ads for any ad locations.', 'sanfrancisco' ),
				'type'      => 'advertisement',
				'locations' => $ad_locations_with_positions,
				'condition' => 'advertisement_inheritance__author:is(custom)'
			),
			array(
				'id' => 'blog_search',
				'label' => esc_html__( 'Search Results', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id'    => 'boxed_layout__search',
				'label' => esc_html__( 'Boxed Layout', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to be able to set background color to the full width page layout area for search results page.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'        => 'boxed_layout_background_color__search',
				'label'     => esc_html__( 'Boxed Layout Background Color', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Set background color to the full width page layout area for search results page.', 'sanfrancisco' ),
				'type'      => 'colorpicker',
				'alpha'     => true,
				'std'       => '#ffffff',
				'condition' => 'boxed_layout__search:is(true)'
			),
			array(
				'id' => 'layout__search',
				'label' => esc_html__( 'Layout', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'ws',
				'choices' => array(
					array(
						'text' => 'Full Width Posts',
						'value' => 'full'
					),
					array(
						'text' => 'Posts with Sidebar',
						'value' => 'ws'
					)
				)
			),
			array(
				'id'      => 'background_inheritance__search',
				'label'   => esc_html__( 'Background', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Use global background settings (Skin &gt; Background) or set custom background for search results page', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Background', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'background__search',
				'label'     => esc_html__( 'Set Background', 'sanfrancisco' ),
				'type'      => 'background',
				'std'       => $background_std,
				'condition' => 'background_inheritance__search:is(custom)'
			),
			array(
				'id' => 'posts_layout__search',
				'label' => esc_html__( 'Posts Layout', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose any layout to show posts in search results page', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'vertical_1_col',
				'choices' => $gp_posts_layout_choices
			),
			array(
				'id' => 'pagination_type__search',
				'label' => esc_html__( 'Pagination Type', 'sanfrancisco' ),
				'type' => 'select',
				'std' => 'numeric',
				'choices' => $gp_pagination_choices
			),
			array(
				'id' => 'sidebar__search',
				'label' => esc_html__( 'Sidebar', 'sanfrancisco' ),
				'type' => 'sidebar_select',
				'std' => 'sanfrancisco-default-sidebar',
				'condition' => 'layout__search:is(ws)'
			),
			array(
				'id' => 'sidebar_position__search',
				'label' => esc_html__( 'Sidebar Position', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => is_rtl() ? 'left' : 'right',
				'choices' => array(
					array(
						'text' => esc_html__( 'Left', 'sanfrancisco' ),
						'value' => 'left'
					),
					array(
						'text' => esc_html__( 'Right', 'sanfrancisco' ),
						'value' => 'right'
					)
				),
				'condition' => 'layout__search:is(ws)'
			),
			array(
				'id' => 'display_title__search',
				'label' => esc_html__( 'Display Title', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show main title in search results page, disable this option.', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'display_breadcrumb__search',
				'label' => esc_html__( 'Display Breadcrumb', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show breadcrumb in search results page, disable this option', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id'    => 'post_types__search',
				'label' => esc_html__( 'Filter Search Results by Post Types', 'sanfrancisco' ),
				'type'  => 'post_type_checker',
				'std'   => 'all'
			),
			array(
				'id'    => 'post_taxonomies__search',
				'label' => esc_html__( 'Filter Search Results by Taxonomies', 'sanfrancisco' ),
				'type'  => 'taxonomy_checker',
				'std'   => 'all'
			),
			array(
				'id'    => 'post_tags__search',
				'label' => esc_html__( 'Filter Search Results by Tag Names', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Add tag(s) seperated by comma. i.e. sports, cooking', 'sanfrancisco' ),
				'type'  => 'text'
			),
			array(
				'id'    => 'excluded_post_ids__search',
				'label' => esc_html__( 'Excluded Post Id\'s', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Specify excluded post ids separated by comma. i.e. 45,73,132,19', 'sanfrancisco' ),
				'type'  => 'text'
			),
			array(
				'id' => 'meta_data__search',
				'label' => esc_html__( 'Meta Data', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose which meta data to show in search results page', 'sanfrancisco' ),
				'type' => 'checker',
				'std' => array( 'excerpt', 'date', 'byline', 'views', 'likes', 'comments', 'category', 'trending_icon' ),
				'choices' => array(
					array(
						'label' => esc_html__( 'Excerpt', 'sanfrancisco' ),
						'value' => 'excerpt'
					),
					array(
						'label' => esc_html__( 'Date', 'sanfrancisco' ),
						'value' => 'date'
					),
					array(
						'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
						'value' => 'byline'
					),
					array(
						'label' => esc_html__( 'Views', 'sanfrancisco' ),
						'value' => 'views'
					),
					array(
						'label' => esc_html__( 'Likes', 'sanfrancisco' ),
						'value' => 'likes'
					),
					array(
						'label' => esc_html__( 'Comments', 'sanfrancisco' ),
						'value' => 'comments'
					),
					array(
						'label' => esc_html__( 'Category Name', 'sanfrancisco' ),
						'value' => 'category'
					),
					array(
						'label' => esc_html__( 'Trending Icon', 'sanfrancisco' ),
						'value' => 'trending_icon'
					)
				)
			),
			array(
				'id'        => 'excerpt_length__search',
				'label'     => 'Excerpt Length',
				'desc'      => esc_html__( 'Choose how long will the excerpt be display for the posts in search results', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'     => '0,200',
				'std'       => '50',
				'condition' => 'meta_data__search:has(excerpt)'
			),
			array(
				'id'        => 'display_tags__search',
				'label'     => esc_html__( 'Display Tags', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Enable this option if you want post tags to be shown in the posts in search results', 'sanfrancisco' ),
				'type'      => 'toggle',
				'std'       => 'true'
			),
			array(
				'id'        => 'tag_limit__search',
				'label'     => esc_html__( 'Tag Limit', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose maximum number of tags to display', 'sanfrancisco' ),
				'type'      => 'range',
				'std'       => 3,
				'minmax'     => '1,25',
				'condition' => 'display_tags__search:is(true)'
			),
			array(
				'id' => 'advertisement_inheritance__search',
				'label' => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use global advertisement settings (General &gt; Advertisment) or select custom ads for search result page.', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Ads', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'advertisement__search',
				'label'     => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Select ads for any ad locations.', 'sanfrancisco' ),
				'type'      => 'advertisement',
				'locations' => $ad_locations_with_positions,
				'condition' => 'advertisement_inheritance__search:is(custom)'
			),
			array(
				'id' => 'blog_tag',
				'label' => esc_html__( 'Tag', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id'    => 'boxed_layout__tag',
				'label' => esc_html__( 'Boxed Layout', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to be able to set background color to the full width page layout area for tag pages.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'        => 'boxed_layout_background_color__tag',
				'label'     => esc_html__( 'Boxed Layout Background Color', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Set background color to the full width page layout area for tag pages.', 'sanfrancisco' ),
				'type'      => 'colorpicker',
				'alpha'     => true,
				'std'       => '#ffffff',
				'condition' => 'boxed_layout__tag:is(true)'
			),
			array(
				'id' => 'layout__tag',
				'label' => esc_html__( 'Layout', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'ws',
				'choices' => array(
					array(
						'text' => 'Full Width Posts',
						'value' => 'full'
					),
					array(
						'text' => 'Posts with Sidebar',
						'value' => 'ws'
					)
				)
			),
			array(
				'id'      => 'background_inheritance__tag',
				'label'   => esc_html__( 'Background', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Use global background settings (Skin &gt; Background) or set custom background for tag pages', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Background', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'background__tag',
				'label'     => esc_html__( 'Set Background', 'sanfrancisco' ),
				'type'      => 'background',
				'std'       => $background_std,
				'condition' => 'background_inheritance__tag:is(custom)'
			),
			array(
				'id' => 'posts_layout__tag',
				'label' => esc_html__( 'Posts Layout', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose any layout to show posts in tag pages', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'vertical_1_col',
				'choices' => $gp_posts_layout_choices
			),
			array(
				'id' => 'pagination_type__tag',
				'label' => esc_html__( 'Pagination Type', 'sanfrancisco' ),
				'type' => 'select',
				'std' => 'numeric',
				'choices' => $gp_pagination_choices
			),
			array(
				'id' => 'sidebar__tag',
				'label' => esc_html__( 'Sidebar', 'sanfrancisco' ),
				'type' => 'sidebar_select',
				'std' => 'sanfrancisco-default-sidebar',
				'condition' => 'layout__tag:is(ws)'
			),
			array(
				'id' => 'sidebar_position__tag',
				'label' => esc_html__( 'Sidebar Position', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => is_rtl() ? 'left' : 'right',
				'choices' => array(
					array(
						'text' => esc_html__( 'Left', 'sanfrancisco' ),
						'value' => 'left'
					),
					array(
						'text' => esc_html__( 'Right', 'sanfrancisco' ),
						'value' => 'right'
					)
				),
				'condition' => 'layout__tag:is(ws)'
			),
			array(
				'id' => 'display_title__tag',
				'label' => esc_html__( 'Display Title', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show main title in tag pages, disable this option.', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'display_breadcrumb__tag',
				'label' => esc_html__( 'Display Breadcrumb', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show breadcrumb in tag pages, disable this option', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'meta_data__tag',
				'label' => esc_html__( 'Meta Data', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose which meta data to show in tag pages', 'sanfrancisco' ),
				'type' => 'checker',
				'std' => array( 'excerpt', 'date', 'byline', 'views', 'likes', 'comments', 'category', 'trending_icon' ),
				'choices' => array(
					array(
						'label' => esc_html__( 'Excerpt', 'sanfrancisco' ),
						'value' => 'excerpt'
					),
					array(
						'label' => esc_html__( 'Date', 'sanfrancisco' ),
						'value' => 'date'
					),
					array(
						'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
						'value' => 'byline'
					),
					array(
						'label' => esc_html__( 'Views', 'sanfrancisco' ),
						'value' => 'views'
					),
					array(
						'label' => esc_html__( 'Likes', 'sanfrancisco' ),
						'value' => 'likes'
					),
					array(
						'label' => esc_html__( 'Comments', 'sanfrancisco' ),
						'value' => 'comments'
					),
					array(
						'label' => esc_html__( 'Category Name', 'sanfrancisco' ),
						'value' => 'category'
					),
					array(
						'label' => esc_html__( 'Trending Icon', 'sanfrancisco' ),
						'value' => 'trending_icon'
					)
				)
			),
			array(
				'id'        => 'excerpt_length__tag',
				'label'     => 'Excerpt Length',
				'desc'      => esc_html__( 'Choose how long will the excerpt be display for the posts in tag pages', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'     => '0,200',
				'std'       => '50',
				'condition' => 'meta_data__tag:has(excerpt)'
			),
			array(
				'id'        => 'display_tags__tag',
				'label'     => esc_html__( 'Display Tags', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Enable this option if you want post tags to be shown in the posts in tag pages', 'sanfrancisco' ),
				'type'      => 'toggle',
				'std'       => 'true'
			),
			array(
				'id'        => 'tag_limit__tag',
				'label'     => esc_html__( 'Tag Limit', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose maximum number of tags to display', 'sanfrancisco' ),
				'type'      => 'range',
				'std'       => 3,
				'minmax'     => '1,25',
				'condition' => 'display_tags__tag:is(true)'
			),
			array(
				'id' => 'advertisement_inheritance__tag',
				'label' => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use global advertisement settings (General &gt; Advertisment) or select custom ads for tag pages.', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Ads', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'advertisement__tag',
				'label'     => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Select ads for any ad locations.', 'sanfrancisco' ),
				'type'      => 'advertisement',
				'locations' => $ad_locations_with_positions,
				'condition' => 'advertisement_inheritance__tag:is(custom)'
			),
			array(
				'id' => 'override__tag',
				'label' => esc_html__( 'Override these options for all tag pages', 'sanfrancisco' ),
				'desc' => esc_html__( 'Enable this option if you want to override these options for all tag pages', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'false'
			),
			array(
				'id' => 'blog_home',
				'label' => esc_html__( 'Posts Page', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id'    => 'boxed_layout__home',
				'label' => esc_html__( 'Boxed Layout', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to be able to set background color to the full width page layout area for posts page.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'        => 'boxed_layout_background_color__home',
				'label'     => esc_html__( 'Boxed Layout Background Color', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Set background color to the full width page layout area for posts page.', 'sanfrancisco' ),
				'type'      => 'colorpicker',
				'alpha'     => true,
				'std'       => '#ffffff',
				'condition' => 'boxed_layout__home:is(true)'
			),
			array(
				'id' => 'layout__home',
				'label' => esc_html__( 'Layout', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'ws',
				'choices' => array(
					array(
						'text' => 'Full Width Posts',
						'value' => 'full'
					),
					array(
						'text' => 'Posts with Sidebar',
						'value' => 'ws'
					)
				)
			),
			array(
				'id'      => 'background_inheritance__home',
				'label'   => esc_html__( 'Background', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Use global background settings (Skin &gt; Background) or set custom background for posts page', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Background', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'background__home',
				'label'     => esc_html__( 'Set Background', 'sanfrancisco' ),
				'type'      => 'background',
				'std'       => $background_std,
				'condition' => 'background_inheritance__home:is(custom)'
			),
			array(
				'id' => 'posts_layout__home',
				'label' => esc_html__( 'Posts Layout', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose any layout to show posts in posts page', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'vertical_1_col',
				'choices' => $gp_posts_layout_choices
			),
			array(
				'id' => 'pagination_type__home',
				'label' => esc_html__( 'Pagination Type', 'sanfrancisco' ),
				'type' => 'select',
				'std' => 'numeric',
				'choices' => $gp_pagination_choices
			),
			array(
				'id' => 'sidebar__home',
				'label' => esc_html__( 'Sidebar', 'sanfrancisco' ),
				'type' => 'sidebar_select',
				'std' => 'sanfrancisco-default-sidebar',
				'condition' => 'layout__home:is(ws)'
			),
			array(
				'id' => 'sidebar_position__home',
				'label' => esc_html__( 'Sidebar Position', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => is_rtl() ? 'left' : 'right',
				'choices' => array(
					array(
						'text' => esc_html__( 'Left', 'sanfrancisco' ),
						'value' => 'left'
					),
					array(
						'text' => esc_html__( 'Right', 'sanfrancisco' ),
						'value' => 'right'
					)
				),
				'condition' => 'layout__home:is(ws)'
			),
			array(
				'id' => 'meta_data__home',
				'label' => esc_html__( 'Meta Data', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose which meta data to show in posts page', 'sanfrancisco' ),
				'type' => 'checker',
				'std' => array( 'excerpt', 'date', 'byline', 'views', 'likes', 'comments', 'category', 'trending_icon' ),
				'choices' => array(
					array(
						'label' => esc_html__( 'Excerpt', 'sanfrancisco' ),
						'value' => 'excerpt'
					),
					array(
						'label' => esc_html__( 'Date', 'sanfrancisco' ),
						'value' => 'date'
					),
					array(
						'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
						'value' => 'byline'
					),
					array(
						'label' => esc_html__( 'Views', 'sanfrancisco' ),
						'value' => 'views'
					),
					array(
						'label' => esc_html__( 'Likes', 'sanfrancisco' ),
						'value' => 'likes'
					),
					array(
						'label' => esc_html__( 'Comments', 'sanfrancisco' ),
						'value' => 'comments'
					),
					array(
						'label' => esc_html__( 'Category Name', 'sanfrancisco' ),
						'value' => 'category'
					),
					array(
						'label' => esc_html__( 'Trending Icon', 'sanfrancisco' ),
						'value' => 'trending_icon'
					)
				)
			),
			array(
				'id'        => 'excerpt_length__home',
				'label'     => 'Excerpt Length',
				'desc'      => esc_html__( 'Choose how long will the excerpt be display for the posts in posts page', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'     => '0,200',
				'std'       => '50',
				'condition' => 'meta_data__home:has(excerpt)'
			),
			array(
				'id'        => 'display_tags__home',
				'label'     => esc_html__( 'Display Tags', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Enable this option if you want post tags to be shown in the posts in posts page', 'sanfrancisco' ),
				'type'      => 'toggle',
				'std'       => 'true'
			),
			array(
				'id'        => 'tag_limit__home',
				'label'     => esc_html__( 'Tag Limit', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose maximum number of tags to display', 'sanfrancisco' ),
				'type'      => 'range',
				'std'       => 3,
				'minmax'     => '1,25',
				'condition' => 'display_tags__home:is(true)'
			),
			array(
				'id' => 'advertisement_inheritance__home',
				'label' => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use global advertisement settings (General &gt; Advertisment) or select custom ads for posts page.', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Ads', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'advertisement__home',
				'label'     => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Select ads for any ad locations.', 'sanfrancisco' ),
				'type'      => 'advertisement',
				'locations' => $ad_locations_with_positions,
				'condition' => 'advertisement_inheritance__home:is(custom)'
			),
			array(
				'id' => 'blog_archive',
				'label' => esc_html__( 'Archives', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id'    => 'boxed_layout__archive',
				'label' => esc_html__( 'Boxed Layout', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to be able to set background color to the full width page layout area for archive pages.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'        => 'boxed_layout_background_color__archive',
				'label'     => esc_html__( 'Boxed Layout Background Color', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Set background color to the full width page layout area for archive pages.', 'sanfrancisco' ),
				'type'      => 'colorpicker',
				'alpha'     => true,
				'std'       => '#ffffff',
				'condition' => 'boxed_layout__archive:is(true)'
			),
			array(
				'id' => 'layout__archive',
				'label' => esc_html__( 'Layout', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'ws',
				'choices' => array(
					array(
						'text' => 'Full Width Posts',
						'value' => 'full'
					),
					array(
						'text' => 'Posts with Sidebar',
						'value' => 'ws'
					)
				)
			),
			array(
				'id'      => 'background_inheritance__archive',
				'label'   => esc_html__( 'Background', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Use global background settings (Skin &gt; Background) or set custom background for archive pages', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Background', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'background__archive',
				'label'     => esc_html__( 'Set Background', 'sanfrancisco' ),
				'type'      => 'background',
				'std'       => $background_std,
				'condition' => 'background_inheritance__archive:is(custom)'
			),
			array(
				'id' => 'posts_layout__archive',
				'label' => esc_html__( 'Posts Layout', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose any layout to show posts in archive pages', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'vertical_1_col',
				'choices' => $gp_posts_layout_choices
			),
			array(
				'id' => 'pagination_type__archive',
				'label' => esc_html__( 'Pagination Type', 'sanfrancisco' ),
				'type' => 'select',
				'std' => 'numeric',
				'choices' => $gp_pagination_choices
			),
			array(
				'id' => 'sidebar__archive',
				'label' => esc_html__( 'Sidebar', 'sanfrancisco' ),
				'type' => 'sidebar_select',
				'std' => 'sanfrancisco-default-sidebar',
				'condition' => 'layout__archive:is(ws)'
			),
			array(
				'id' => 'sidebar_position__archive',
				'label' => esc_html__( 'Sidebar Position', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => is_rtl() ? 'left' : 'right',
				'choices' => array(
					array(
						'text' => esc_html__( 'Left', 'sanfrancisco' ),
						'value' => 'left'
					),
					array(
						'text' => esc_html__( 'Right', 'sanfrancisco' ),
						'value' => 'right'
					)
				),
				'condition' => 'layout__archive:is(ws)'
			),
			array(
				'id' => 'display_title__archive',
				'label' => esc_html__( 'Display Title', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show main title in archive pages, disable this option.', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'display_breadcrumb__archive',
				'label' => esc_html__( 'Display Breadcrumb', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show breadcrumb in archive pages, disable this option', 'sanfrancisco'  ),
				'type' => 'toggle',
				'std' => 'true'
			),
			array(
				'id' => 'meta_data__archive',
				'label' => esc_html__( 'Meta Data', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose which meta data to show in archive pages', 'sanfrancisco' ),
				'type' => 'checker',
				'std' => array( 'excerpt', 'date', 'byline', 'views', 'likes', 'comments', 'category', 'trending_icon' ),
				'choices' => array(
					array(
						'label' => esc_html__( 'Excerpt', 'sanfrancisco' ),
						'value' => 'excerpt'
					),
					array(
						'label' => esc_html__( 'Date', 'sanfrancisco' ),
						'value' => 'date'
					),
					array(
						'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
						'value' => 'byline'
					),
					array(
						'label' => esc_html__( 'Views', 'sanfrancisco' ),
						'value' => 'views'
					),
					array(
						'label' => esc_html__( 'Likes', 'sanfrancisco' ),
						'value' => 'likes'
					),
					array(
						'label' => esc_html__( 'Comments', 'sanfrancisco' ),
						'value' => 'comments'
					),
					array(
						'label' => esc_html__( 'Category Name', 'sanfrancisco' ),
						'value' => 'category'
					),
					array(
						'label' => esc_html__( 'Trending Icon', 'sanfrancisco' ),
						'value' => 'trending_icon'
					)
				)
			),
			array(
				'id'        => 'excerpt_length__archive',
				'label'     => 'Excerpt Length',
				'desc'      => esc_html__( 'Choose how long will the excerpt be display for the posts in archive pages', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'     => '0,200',
				'std'       => '50',
				'condition' => 'meta_data__archive:has(excerpt)'
			),
			array(
				'id'        => 'display_tags__archive',
				'label'     => esc_html__( 'Display Tags', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Enable this option if you want post tags to be shown in the posts in archive pages', 'sanfrancisco' ),
				'type'      => 'toggle',
				'std'       => 'true'
			),
			array(
				'id'        => 'tag_limit__archive',
				'label'     => esc_html__( 'Tag Limit', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose maximum number of tags to display', 'sanfrancisco' ),
				'type'      => 'range',
				'std'       => 3,
				'minmax'     => '1,25',
				'condition' => 'display_tags__archive:is(true)'
			),
			array(
				'id' => 'advertisement_inheritance__archive',
				'label' => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use global advertisement settings (General &gt; Advertisment) or select custom ads for archive pages.', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Ads', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'advertisement__archive',
				'label'     => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Select ads for any ad locations.', 'sanfrancisco' ),
				'type'      => 'advertisement',
				'locations' => $ad_locations_with_positions,
				'condition' => 'advertisement_inheritance__archive:is(custom)'
			),
			array(
				'id' => 'typography',
				'label' => esc_html__( 'Typography', 'sanfrancisco' ),
				'desc' => esc_html__( 'Set font properties for custom parts of the theme', 'sanfrancisco' ),
				'type' => 'section',
				'icon' => 'font'
			),
			array(
				'id' => 'typo_general',
				'label' => esc_html__( 'General', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id' => 'body_font',
				'label' => esc_html__( 'Body Font', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose your body font properties.', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_family' => 'Roboto',
					'backup_font_family' => 'Arial, Helvetica, sans-serif',
					'font_weight_style' => '400',
					'font_subsets' => 'latin-ext',
					'font_size' => '14'
				)
			),
			array(
				'id' => 'headings_font',
				'label' => esc_html__( 'Headings Font', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose your Heading fonts properties. (will affect H1, H2, H3, H4, H5, H6)', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_family' => 'Roboto',
					'font_weight_style' => '900',
					'font_subsets' => 'latin-ext'
				),
				'properties' => array(
					'font_family',
					'font_weight_style',
					'font_subsets'
				)
			),
			array(
				'id' => 'widgets_title_font',
				'label' => esc_html__( 'Widgets Title Font', 'sanfrancisco' ),
				'desc' => esc_html__( 'This will apply to all widget areas title including footer and sidebar', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_family' => 'Roboto',
					'font_weight_style' => '700',
					'font_subsets' => 'latin-ext',
					'font_size' => '14'
				),
				'properties' => array(
					'font_family',
					'font_weight_style',
					'font_subsets',
					'font_size'
				)
			),
			array(
				'id' => 'archive_title_font',
				'label' => esc_html__( 'Archive Title Font', 'sanfrancisco' ),
				'desc' => esc_html__( 'This will apply to the title of all archive pages. (Category, tag, author, yearly archive pages etc.)', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_family' => 'Roboto',
					'font_weight_style' => '900',
					'font_subsets' => 'latin-ext',
					'font_size' => '22'
				),
				'properties' => array(
					'font_family',
					'font_weight_style',
					'font_subsets',
					'font_size'
				)
			),
			array(
				'id' => 'breadcrumb_font',
				'label' => esc_html__( 'Breadcrumb Font', 'sanfrancisco' ),
				'desc' => esc_html__( 'This will apply to all breadcrumb in various pages. (Category, post, tag, author, archive pages etc.)', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_family' => 'Roboto',
					'font_weight_style' => '400',
					'font_subsets' => 'latin-ext',
					'font_size' => '14'
				),
				'properties' => array(
					'font_family',
					'font_weight_style',
					'font_subsets',
					'font_size'
				)
			),
			array(
				'id' => 'typo_branding',
				'label' => esc_html__( 'Logos & Branding', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id' => 'header_logo_font',
				'label' => esc_html__( 'Header Logo Font', 'sanfrancisco' ),
				'desc' => esc_html__( 'This option can only be applied if you choose your header logo as text', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_family' => 'Montserrat',
					'font_weight_style' => '700',
					'font_subsets' => 'latin',
					'font_size' => '28'
				),
				'properties' => array(
					'font_family',
					'font_weight_style',
					'font_subsets',
					'font_size'
				)
			),
			array(
				'id' => 'header_logo_mobile_font',
				'label' => esc_html__( 'Header Mobile Logo Font', 'sanfrancisco' ),
				'desc' => esc_html__( 'This option can only be applied if you choose your header mobile logo as text', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_family' => 'Montserrat',
					'font_weight_style' => '700',
					'font_subsets' => 'latin',
					'font_size' => '28'
				),
				'properties' => array(
					'font_family',
					'font_weight_style',
					'font_subsets',
					'font_size'
				)
			),
			array(
				'id' => 'footer_logo_font',
				'label' => esc_html__( 'Footer Logo Font', 'sanfrancisco' ),
				'desc' => esc_html__( 'This option can only be applied if you choose your footer logo as text', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_family' => 'Montserrat',
					'font_weight_style' => '700',
					'font_subsets' => 'latin',
					'font_size' => '28'
				),
				'properties' => array(
					'font_family',
					'font_weight_style',
					'font_subsets',
					'font_size'
				)
			),
			array(
				'id' => 'footer_logo_mobile_font',
				'label' => esc_html__( 'Footer Mobile Logo Font', 'sanfrancisco' ),
				'desc' => esc_html__( 'This option can only be applied if you choose your footer mobile logo as text', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_family' => 'Montserrat',
					'font_weight_style' => '700',
					'font_subsets' => 'latin',
					'font_size' => '28'
				),
				'properties' => array(
					'font_family',
					'font_weight_style',
					'font_subsets',
					'font_size'
				)
			),
			array(
				'id' => 'footer_branding_desc_font',
				'label' => esc_html__( 'Footer Branding Description Font', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_family' => 'Georgia, serif',
					'font_weight_style' => '400',
					'font_size' => '13'
				),
				'properties' => array(
					'font_family',
					'font_weight_style',
					'font_subsets',
					'font_size'
				)
			),
			array(
				'id' => 'typo_main_nav',
				'label' => esc_html__( 'Main Menu', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id' => 'main_menu_font',
				'label' => esc_html__( 'Main Menu Font', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_family' => 'Roboto',
					'font_weight_style' => '300',
					'font_subsets' => 'latin-ext',
					'font_size' => '14'
				),
				'properties' => array(
					'font_family',
					'font_weight_style',
					'font_subsets',
					'font_size'
				)
			),
			array(
				'id' => 'main_menu_top_text_transform',
				'label' => esc_html__( 'Main Menu Text Transform', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'none',
				'choices' => $text_transform_choices
			),
			array(
				'id' => 'main_menu_top_current_item_font_weight',
				'label' => esc_html__( 'Current Menu Item Font Weight', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_weight_style' => '700'
				),
				'properties' => array(
					'font_weight_style'
				)
			),
			array(
				'id' => 'main_menu_sub_font_size',
				'label' => esc_html__( 'Main Menu Sub Level Font Size', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_size' => '14'
				),
				'properties' => array(
					'font_size'
				)
			),
			array(
				'id' => 'main_menu_sub_text_transform',
				'label' => esc_html__( 'Main Menu Sub Level Text Transform', 'sanfrancisco' ),
				'type' => 'radio_select',
				'std' => 'none',
				'choices' => $text_transform_choices
			),
			array(
				'id' => 'main_menu_sub_current_item_font_weight',
				'label' => esc_html__( 'Current Sub Menu Item Font Weight', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_weight_style' => '700'
				),
				'properties' => array(
					'font_weight_style'
				)
			),
			array(
				'id' => 'main_menu_trending_item_font',
				'label' => esc_html__( 'Trending Menu Item Font', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_family' => 'Montserrat',
					'font_weight_style' => '700',
					'font_subsets' => 'latin',
					'font_size' => '14'
				),
				'properties' => array(
					'font_family',
					'font_weight_style',
					'font_subsets',
					'font_size'
				)
			),
			array(
				'id' => 'typo_singular',
				'label' => esc_html__( 'Post & Page', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id' => 'singular_title_font',
				'label' => esc_html__( 'Page Title Font', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_family' => 'Roboto',
					'font_weight_style' => '900',
					'font_subsets' => 'latin-ext',
					'font_size' => '48'
				),
				'properties' => array(
					'font_family',
					'font_weight_style',
					'font_subsets',
					'font_size'
				)
			),
			array(
				'id' => 'singular_subtitle_font',
				'label' => esc_html__( 'Page Subtitle Font', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_family' => 'Georgia, serif',
					'font_weight_style' => '400',
					'font_size' => '16'
				),
				'properties' => array(
					'font_family',
					'font_weight_style',
					'font_subsets',
					'font_size'
				)
			),
			array(
				'id' => 'singular_content_font',
				'label' => esc_html__( 'Page Content Font', 'sanfrancisco' ),
				'type' => 'font',
				'std' => array(
					'font_family' => 'Roboto',
					'font_weight_style' => '400',
					'font_subsets' => 'latin-ext',
					'font_size' => '16'
				),
				'properties' => array(
					'font_family',
					'font_weight_style',
					'font_subsets',
					'font_size'
				)
			),
			array(
				'id' => 'singular_content_line_height',
				'label' => esc_html__( 'Page Content Line Height', 'sanfrancisco' ),
				'type' => 'range',
				'minmax' => '14,100',
				'std' => '28'
			),
			array(
				'id' => 'skin',
				'label' => esc_html__( 'Skin', 'sanfrancisco' ),
				'desc' => esc_html__( 'Configure color scheme of the theme', 'sanfrancisco' ),
				'type' => 'section',
				'icon' => 'paint-brush'
			),
			array(
				'id' => 'skin_general',
				'label' => esc_html__( 'General', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id'         => 'background',
				'label'      => esc_html__( 'Background', 'sanfrancisco' ),
				'type'       => 'background',
				'std'        => array(
					'background_color'      => '#f6f6f6',
					'background_image'      => '',
					'background_repeat'     => 'no_repeat',
					'background_position'   => 'top_center',
					'background_attachment' => 'scroll'
				)
			),
			array(
				'id' => 'selection_color',
				'label' => esc_html__( 'Selection Color', 'sanfrancisco' ),
				'desc' => esc_html__( 'Main selection color of the theme', 'sanfrancisco' ),
				'type' => 'colorpicker',
				'labels' => array(
					'text_background_color' => esc_html__( 'Background Color', 'sanfrancisco' ),
					'text_color' => esc_html__( 'Text Color', 'sanfrancisco' )
				),
				'std' => array(
					'text_background_color' => '#000000',
					'text_color' => '#ffffff'
				)
			),
			array(
				'id' => 'trending_icon_skin',
				'label' => esc_html__( 'Trending Icon Color', 'sanfrancisco' ),
				'type' => 'select',
				'std' => 'custom_color',
				'choices' => array(
					array(
						'label' => esc_html__( 'Category Accent Color', 'sanfrancisco' ),
						'value' => 'category_accent'
					),
					array(
						'label' => esc_html__( 'Custom Color', 'sanfrancisco' ),
						'value' => 'custom_color'
					)
				)
			),
			array(
				'id'        => 'trending_icon_background_color',
				'label'     => esc_html__( 'Custom Trending Icon Color', 'sanfrancisco' ),
				'type'      => 'colorpicker',
				'alpha'     => true,
				'std'       => '#e91e63',
				'condition' => 'trending_icon_skin:is(custom_color)'
			),
			array(
				'id' => 'skin_header',
				'label' => esc_html__( 'Header', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id' => 'header_background',
				'label' => esc_html__( 'Header Background', 'sanfrancisco' ),
				'type' => 'background',
				'alpha' => true,
				'std' => array(
					'background_color' => '#ffffff'
				)
			),
			array(
				'id' => 'header_logo_color',
				'label' => esc_html__( 'Header Logo Color', 'sanfrancisco' ),
				'desc' => esc_html__( 'This option can only be applied if you choose your header logo as text.', 'sanfrancisco' ),
				'type' => 'colorpicker',
				'labels' => array(
					'regular_color' => esc_html__( 'Regular', 'sanfrancisco' ),
					'hover_color' => esc_html__( 'Hover', 'sanfrancisco' ),
					'active_color' => esc_html__( 'Active', 'sanfrancisco' )
				),
				'std' => array(
					'regular_color' => '#000000',
					'hover_color' => '#000000',
					'active_color' => '#000000'
				)
			),
			array(
				'id' => 'header_logo_mobile_color',
				'label' => esc_html__( 'Header Mobile Logo Color', 'sanfrancisco' ),
				'desc' => esc_html__( 'This option can only be applied if you choose your header mobile logo as text.', 'sanfrancisco' ),
				'type' => 'colorpicker',
				'std' => '#000000'
			),
			array(
				'id' => 'header_line_border_color',
				'label' => esc_html__( 'Header Line Color', 'sanfrancisco' ),
				'type' => 'colorpicker',
				'std' => 'rgba(0,0,0,0.05)',
				'alpha' => true
			),
			array(
				'id' => 'main_menu_top_color',
				'label' => esc_html__( 'Main Menu Links Color', 'sanfrancisco' ),
				'desc' => esc_html__( 'Will affect main navigation top level links.', 'sanfrancisco' ),
				'type' => 'colorpicker',
				'labels' => array(
					'regular_color' => esc_html__( 'Regular', 'sanfrancisco' ),
					'hover_color' => esc_html__( 'Hover', 'sanfrancisco' ),
					'active_color' => esc_html__( 'Active', 'sanfrancisco' )
				),
				'std' => array(
					'regular_color' => 'rgba(0,0,0,0.6)',
					'hover_color' => '#000000',
					'active_color' => '#000000'
				),
				'alpha' => true
			),
			array(
				'id' => 'main_menu_sub_box_background_color',
				'label' => esc_html__( 'Sub Menu Background Color', 'sanfrancisco' ),
				'desc' => esc_html__( 'Will affect sub menu box.', 'sanfrancisco' ),
				'type' => 'colorpicker',
				'std' => '#ffffff',
				'alpha' => true
			),
			array(
				'id' => 'main_menu_sub_color',
				'label' => esc_html__( 'Sub Menu Links Color', 'sanfrancisco' ),
				'desc' => esc_html__( 'Will affect main navigation sub level links.', 'sanfrancisco' ),
				'type' => 'colorpicker',
				'labels' => array(
					'regular_color' => esc_html__( 'Regular', 'sanfrancisco' ),
					'hover_color' => esc_html__( 'Hover', 'sanfrancisco' ),
					'active_color' => esc_html__( 'Active', 'sanfrancisco' )
				),
				'std' => array(
					'regular_color' => 'rgba(0,0,0,0.6)',
					'hover_color' => '#000000',
					'active_color' => '#000000'
				),
				'alpha' => true
			),
			array(
				'id'    => 'main_menu_sub_arrow_color',
				'label' => esc_html__( 'Sub Menu Arrow Color', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Will affect arrow icon over sub menu.', 'sanfrancisco' ),
				'type'  => 'colorpicker',
				'std'   => 'rgba(0,0,0,0.08)',
				'alpha' => true
			),
			array(
				'id' => 'main_menu_trending_item_color',
				'label' => esc_html__( 'Trending Menu Item Color', 'sanfrancisco' ),
				'type' => 'colorpicker',
				'labels' => array(
					'regular_color' => esc_html__( 'Regular', 'sanfrancisco' ),
					'hover_color' => esc_html__( 'Hover', 'sanfrancisco' ),
					'active_color' => esc_html__( 'Active', 'sanfrancisco' )
				),
				'std' => array(
					'regular_color' => '#000000',
					'hover_color' => '#000000',
					'active_color' => '#000000'
				),
				'alpha' => true
			),
			array(
				'id' => 'search_icon_color',
				'label' => esc_html__( 'Search Icon Color', 'sanfrancisco' ),
				'desc' => esc_html__( 'Will affect search icon in the header.', 'sanfrancisco' ),
				'type' => 'colorpicker',
				'labels' => array(
					'regular_color' => esc_html__( 'Regular', 'sanfrancisco' ),
					'hover_color' => esc_html__( 'Hover', 'sanfrancisco' ),
					'active_color' => esc_html__( 'Active', 'sanfrancisco' )
				),
				'std' => array(
					'regular_color' => '#000000',
					'hover_color' => '#000000',
					'active_color' => '#000000'
				),
				'alpha' => true
			),
			array(
				'id'    => 'skin_footer',
				'label' => esc_html__( 'Footer', 'sanfrancisco' ),
				'type'  => 'tab'
			),
			array(
				'id'    => 'footer_background_color',
				'label' => esc_html__( 'Footer Background Color', 'sanfrancisco' ),
				'type'  => 'colorpicker',
				'alpha' => true,
				'std'   => '#ffffff'
			),
			array(
				'id'    => 'footer_lines_background_color',
				'label' => esc_html__( 'Footer Lines Color', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Will affect all horizontal lines in footer.', 'sanfrancisco' ),
				'type'  => 'colorpicker',
				'std'   => 'rgba(0,0,0,0.08)',
				'alpha' => true
			),
			array(
				'id'     => 'footer_logo_color',
				'label'  => esc_html__( 'Footer Logo Color', 'sanfrancisco' ),
				'desc'   => esc_html__( 'This option can only be applied if you choose your footer logo as text.', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'labels' => array(
					'regular_color' => esc_html__( 'Regular', 'sanfrancisco' ),
					'hover_color'   => esc_html__( 'Hover', 'sanfrancisco' ),
					'active_color'  => esc_html__( 'Active', 'sanfrancisco' )
				),
				'std'    => array(
					'regular_color' => '#000000',
					'hover_color'   => '#000000',
					'active_color'  => '#000000'
				)
			),
			array(
				'id'    => 'footer_logo_mobile_color',
				'label' => esc_html__( 'Footer Mobile Logo Color', 'sanfrancisco' ),
				'desc'  => esc_html__( 'This option can only be applied if you choose your footer mobile logo as text.', 'sanfrancisco' ),
				'type'  => 'colorpicker',
				'std'   => '#000000'
			),
			array(
				'id'    => 'footer_branding_desc_color',
				'label' => esc_html__( 'Footer Branding Description Color', 'sanfrancisco' ),
				'type'  => 'colorpicker',
				'std'   => '#525252'
			),
			array(
				'id'    => 'footer_copyright_text_color',
				'label' => esc_html__( 'Footer Copyright Text Color', 'sanfrancisco' ),
				'type'  => 'colorpicker',
				'std'   => '#000000'
			),
			array(
				'id'     => 'footer_nav_color',
				'label'  => esc_html__( 'Footer Menu Links Color', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'labels' => array(
					'regular_color' => esc_html__( 'Regular', 'sanfrancisco' ),
					'hover_color'   => esc_html__( 'Hover', 'sanfrancisco' ),
					'active_color'  => esc_html__( 'Active', 'sanfrancisco' )
				),
				'std'    => array(
					'regular_color' => '#000000',
					'hover_color'   => '#000000',
					'active_color'  => '#000000'
				)
			),
			array(
				'id' => 'footer_widgets_title_color',
				'label' => esc_html__( 'Footer Widgets Title Color', 'sanfrancisco' ),
				'type' => 'colorpicker',
				'std' => '#000000'
			),
			array(
				'id' => 'footer_widgets_text_color',
				'label' => esc_html__( 'Footer Widgets Text Color', 'sanfrancisco' ),
				'desc' => esc_html__( 'Will affect all texts in footer widget (unless there is a color value for the specific option in theme styles)', 'sanfrancisco' ),
				'type' => 'colorpicker',
				'std' => '#000000'
			),
			array(
				'id' => 'footer_widgets_links_color',
				'label' => esc_html__( 'Footer Widgets Links Color', 'sanfrancisco' ),
				'desc' => esc_html__( 'Will affect all links in footer section.', 'sanfrancisco' ),
				'type' => 'colorpicker',
				'labels' => array(
					'regular_color' => esc_html__( 'Regular', 'sanfrancisco' ),
					'hover_color' => esc_html__( 'Hover', 'sanfrancisco' ),
					'active_color' => esc_html__( 'Active', 'sanfrancisco' )
				),
				'std' => array(
					'regular_color' => '#000000',
					'hover_color' => '#e72132',
					'active_color' => '#e72132'
				)
			),
			array(
				'id'    => 'grid_posts',
				'label' => esc_html__( 'Grid Posts', 'sanfrancisco' ),
				'type'  => 'tab'
			),
			array(
				'id'    => 'gp_box_background_color',
				'label' => esc_html__( 'Grid Posts Box Background Color', 'sanfrancisco' ),
				'type'  => 'colorpicker',
				'alpha' => true,
				'std'   => '#ffffff'
			),
			array(
				'id'     => 'gp_primary_color',
				'label'  => esc_html__( 'Grid Posts Primary Text/Links Color', 'sanfrancisco' ),
				'desc'   => esc_html__( 'Will affect post title, post meta data and tags label.', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'alpha'  => true,
				'labels' => array(
					'regular_color' => esc_html__( 'Regular Color (Links & text)', 'sanfrancisco' ),
					'hover_color'   => esc_html__( 'Hover Color (Links only)', 'sanfrancisco' ),
					'active_color'  => esc_html__( 'Active Color (Links only)', 'sanfrancisco' )
				),
				'std'    => array(
					'regular_color' => '#000000',
					'hover_color'   => '#e72132',
					'active_color'  => '#e72132'
				)
			),
			array(
				'id'     => 'gp_secondary_color',
				'label'  => esc_html__( 'Grid Posts Secondary Text/Links Color', 'sanfrancisco' ),
				'desc'   => esc_html__( 'Will affect post excerpt and tag links.', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'alpha'  => true,
				'labels' => array(
					'regular_color' => esc_html__( 'Regular Color (Links & text)', 'sanfrancisco' ),
					'hover_color'   => esc_html__( 'Hover Color (Links only)', 'sanfrancisco' ),
					'active_color'  => esc_html__( 'Active Color (Links only)', 'sanfrancisco' )
				),
				'std'    => array(
					'regular_color' => 'rgba(0,0,0,0.5)',
					'hover_color'   => '#000000',
					'active_color'  => '#000000'
				)
			),
			array(
				'id'     => 'gp_button_color',
				'label'  => esc_html__( 'Grid Posts Button Color', 'sanfrancisco' ),
				'desc'   => esc_html__( 'Will affect category button in horizontal grid posts.', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'labels' => array(
					'regular_background_color' => esc_html__( 'Regular Background Color', 'sanfrancisco' ),
					'regular_color'            => esc_html__( 'Regular Text Color', 'sanfrancisco' ),
					'hover_background_color'   => esc_html__( 'Hover Background Color', 'sanfrancisco' ),
					'hover_color'              => esc_html__( 'Hover Text Color', 'sanfrancisco' )
				),
				'std'    => array(
					'regular_background_color' => '#d4d4d4',
					'regular_color'            => '#ffffff',
					'hover_background_color'   => '#000000',
					'hover_color'              => '#ffffff'
				)
			),
			array(
				'id'     => 'gp_image_color',
				'label'  => esc_html__( 'Grid Posts Image Overlay Color', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'alpha'  => true,
				'labels' => array(
					'overlay_background_color'        => esc_html__( 'Overlay Color on Desktop', 'sanfrancisco' ),
					'overlay_hover_background_color'  => esc_html__( 'Overlay Hover Color on Desktop', 'sanfrancisco' ),
					'overlay_mobile_background_color' => esc_html__( 'Overlay Color on Mobile', 'sanfrancisco' )
				),
				'std'    => array(
					'overlay_background_color'        => 'rgba(0,0,0,0)',
					'overlay_hover_background_color'  => 'rgba(0,0,0,0.2)',
					'overlay_mobile_background_color' => 'rgba(0,0,0,0)'
				)
			),
			array(
				'id'    => 'skin_widgets',
				'label' => esc_html__( 'Widgets', 'sanfrancisco' ),
				'type'  => 'tab'
			),
			array(
				'id'     => 'sidebar_widgets_primary_color',
				'label'  => esc_html__( 'Sidebar Widgets Primary Color', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'alpha' => true,
				'labels' => array(
					'box_background_color' => esc_html__( 'Box Background Color', 'sanfrancisco' ),
					'regular_color'        => esc_html__( 'Text/Links Color', 'sanfrancisco' ),
					'hover_color'          => esc_html__( 'Links Hover Color', 'sanfrancisco' ),
					'active_color'         => esc_html__( 'Links Active Color', 'sanfrancisco' )
				),
				'std'    => array(
					'box_background_color' => '#ffffff',
					'regular_color'        => '#000000',
					'hover_color'          => '#e72132',
					'active_color'         => '#e72132'
				)
			),
			array(
				'id'     => 'sidebar_widgets_secondary_color',
				'label'  => esc_html__( 'Sidebar Widgets Secondary Color', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'alpha'  => true,
				'labels' => array(
					'box_background_color' => esc_html__( 'Box Background Color', 'sanfrancisco' ),
					'regular_color'        => esc_html__( 'Text/Links Color', 'sanfrancisco' ),
					'hover_color'          => esc_html__( 'Links Hover Color', 'sanfrancisco' ),
					'active_color'         => esc_html__( 'Links Active Color', 'sanfrancisco' )
				),
				'std'    => array(
					'box_background_color' => 'rgba(0,0,0,0.02)',
					'regular_color'        => '#a3a3a3',
					'hover_color'          => '#000000',
					'active_color'         => '#000000'
				)
			),
			array(
				'id'     => 'sidebar_widgets_button_color',
				'label'  => esc_html__( 'Sidebar Widgets Button Color', 'sanfrancisco' ),
				'desc'   => esc_html__( 'Will affect buttons in tag cloud widget.', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'labels' => array(
					'regular_background_color' => esc_html__( 'Regular Background Color', 'sanfrancisco' ),
					'regular_color'            => esc_html__( 'Regular Text Color', 'sanfrancisco' ),
					'hover_background_color'   => esc_html__( 'Hover Background Color', 'sanfrancisco' ),
					'hover_color'              => esc_html__( 'Hover Text Color', 'sanfrancisco' )
				),
				'std'    => array(
					'regular_background_color' => '#ffffff',
					'regular_color'            => '#cccccc',
					'hover_background_color'   => '#000000',
					'hover_color'              => '#ffffff'
				)
			),
			array(
				'id'    => 'sidebar_widgets_title_color',
				'label' => esc_html__( 'Sidebar Widgets Title Color', 'sanfrancisco' ),
				'type'  => 'colorpicker',
				'std'   => '#000000'
			),
			array(
				'id'    => 'sidebar_widgets_title_line_background_color',
				'label' => esc_html__( 'Sidebar Widgets Title Line Color', 'sanfrancisco' ),
				'type'  => 'colorpicker',
				'std'   => 'rgba(0,0,0,0.15)',
				'alpha' => true
			),
			array(
				'id' => 'skin_singular',
				'label' => esc_html__( 'Post & Page', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id'     => 'singular_primary_color',
				'label'  => esc_html__( 'Post & Page Primary Color', 'sanfrancisco' ),
				'desc'   => esc_html__( 'Configure primary color scheme of the elements in single post & page.', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'alpha'  => true,
				'labels' => array(
					'box_background_color' => esc_html__( 'Box Background Color', 'sanfrancisco' ),
					'regular_color'        => esc_html__( 'Text/Links Color', 'sanfrancisco' ),
					'hover_color'          => esc_html__( 'Links Hover Color', 'sanfrancisco' ),
					'active_color'         => esc_html__( 'Links Active Color', 'sanfrancisco' )
				),
				'std'    => array(
					'box_background_color' => '#ffffff',
					'regular_color'        => '#000000',
					'hover_color'          => '#e72132',
					'active_color'         => '#e72132'
				)
			),
			array(
				'id'     => 'singular_secondary_color',
				'label'  => esc_html__( 'Post & Page Secondary Color', 'sanfrancisco' ),
				'desc'   => esc_html__( 'Configure secondary color scheme of the elements in single post & page.', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'alpha'  => true,
				'labels' => array(
					'box_background_color' => esc_html__( 'Box Background Color', 'sanfrancisco' ),
					'regular_color'        => esc_html__( 'Text/Links Color', 'sanfrancisco' ),
					'hover_color'          => esc_html__( 'Links Hover Color', 'sanfrancisco' ),
					'active_color'         => esc_html__( 'Links Active Color', 'sanfrancisco' )
				),
				'std'    => array(
					'box_background_color' => '#fafafa',
					'regular_color'        => '#8c8c8c',
					'hover_color'          => '#000000',
					'active_color'         => '#000000'
				)
			),
			array(
				'id'     => 'singular_content_color',
				'label'  => esc_html__( 'Post & Page Content Color', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'labels' => array(
					'text_color'          => esc_html__( 'Text Color', 'sanfrancisco' ),
					'headings_color'      => esc_html__( 'Headings Color', 'sanfrancisco' ),
					'links_regular_color' => esc_html__( 'Links Regular Color', 'sanfrancisco' ),
					'links_hover_color'   => esc_html__( 'Links Hover Color', 'sanfrancisco' ),
					'links_active_color'  => esc_html__( 'Links Active Color', 'sanfrancisco' )
				),
				'std'    => array(
					'text_color'          => '#000000',
					'headings_color'      => '#000000',
					'links_regular_color' => '#007acc',
					'links_hover_color'   => '#e72132',
					'links_active_color'  => '#e72132'
				)
			),
			array(
				'id'     => 'singular_category_button_color',
				'label'  => esc_html__( 'Post & Page Category Button Color', 'sanfrancisco' ),
				'desc'   => esc_html__( 'Will affect category button in single post & page.', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'labels' => array(
					'regular_background_color' => esc_html__( 'Regular Background Color', 'sanfrancisco' ),
					'regular_color'            => esc_html__( 'Regular Text Color', 'sanfrancisco' ),
					'hover_background_color'   => esc_html__( 'Hover Background Color', 'sanfrancisco' ),
					'hover_color'              => esc_html__( 'Hover Text Color', 'sanfrancisco' )
				),
				'std'    => array(
					'regular_background_color' => '#000000',
					'regular_color'            => '#ffffff',
					'hover_background_color'   => '#000000',
					'hover_color'              => '#ffffff'
				)
			),
			array(
				'id'     => 'singular_comment_button_color',
				'label'  => esc_html__( 'Post & Page Comment Button Color', 'sanfrancisco' ),
				'desc'   => esc_html__( 'Will affect comment button in single post & page.', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'labels' => array(
					'regular_background_color' => esc_html__( 'Regular Background Color', 'sanfrancisco' ),
					'regular_color'            => esc_html__( 'Regular Text Color', 'sanfrancisco' ),
					'hover_background_color'   => esc_html__( 'Hover Background Color', 'sanfrancisco' ),
					'hover_color'              => esc_html__( 'Hover Text Color', 'sanfrancisco' )
				),
				'std'    => array(
					'regular_background_color' => '#30ae42',
					'regular_color'            => '#ffffff',
					'hover_background_color'   => '#30ae42',
					'hover_color'              => '#ffffff'
				)
			),
			array(
				'id'    => 'singular_lines_border_color',
				'label' => esc_html__( 'Post & Page Lines Color', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Will affect related posts title line, comment form border color, elements seperator lines etc.', 'sanfrancisco' ),
				'type'  => 'colorpicker',
				'alpha' => true,
				'std'   => 'rgba(0, 0, 0, 0.04)'
			),
			array(
				'id' => 'skin_misc',
				'label' => esc_html__( 'Misc.', 'sanfrancisco' ),
				'type' => 'tab'
			),
			array(
				'id'     => 'mm_color',
				'label'  => esc_html__( 'Trending/Mega Menu Color', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'alpha'  => true,
				'labels' => array(
					'box_background_color'    => esc_html__( 'Box Background Color', 'sanfrancisco' ),
					'primary_regular_color'   => esc_html__( 'Primary Text/Links Color', 'sanfrancisco' ),
					'primary_hover_color'     => esc_html__( 'Primary Links Hover Color', 'sanfrancisco' ),
					'primary_active_color'    => esc_html__( 'Primary Links Active Color', 'sanfrancisco' ),
					'secondary_regular_color' => esc_html__( 'Secondary Text/Links Color', 'sanfrancisco' ),
					'secondary_hover_color'   => esc_html__( 'Secondary Links Hover Color', 'sanfrancisco' ),
					'secondary_active_color'  => esc_html__( 'Secondary Links Active Color', 'sanfrancisco' )
				),
				'std' => array(
					'box_background_color'    => '#ffffff',
					'primary_regular_color'   => '#000000',
					'primary_hover_color'     => '#e72132',
					'primary_active_color'    => '#e72132',
					'secondary_regular_color' => '#a3a3a3',
					'secondary_hover_color'   => '#000000',
					'secondary_active_color'  => '#000000'
				)
			),
			array(
				'id'     => 'fancy_title_color',
				'label'  => esc_html__( 'Archive Title Box Color', 'sanfrancisco' ),
				'desc'   => esc_html__( 'Will affect title box including breadcrumb in archive pages.', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'alpha'  => true,
				'labels' => array(
					'box_background_color' => esc_html__( 'Box Background Color', 'sanfrancisco' ),
					'title_color'          => esc_html__( 'Title Color', 'sanfrancisco' ),
					'links_regular_color'  => esc_html__( 'Links Regular Color', 'sanfrancisco' ),
					'links_hover_color'    => esc_html__( 'Links Hover Color', 'sanfrancisco' ),
					'links_active_color'   => esc_html__( 'Links Active Color', 'sanfrancisco' )
				),
				'std'    => array(
					'box_background_color' => '#ffffff',
					'title_color'          => '#000000',
					'links_regular_color'  => '#000000',
					'links_hover_color'    => '#e72132',
					'links_active_color'   => '#000000'
				)
			),
			array(
				'id'     => 'author_box_color',
				'label'  => esc_html__( 'Author Box Color', 'sanfrancisco' ),
				'desc'   => esc_html__( 'Will affect author box in author posts page.', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'alpha'  => true,
				'labels' => array(
					'box_background_color' => esc_html__( 'Box Background Color', 'sanfrancisco' ),
					'title_color'          => esc_html__( 'Author Title Color', 'sanfrancisco' ),
					'bio_color'            => esc_html__( 'Author Bio Color', 'sanfrancisco' ),
					'links_regular_color'  => esc_html__( 'Links Regular Color', 'sanfrancisco' ),
					'links_hover_color'    => esc_html__( 'Links Hover Color', 'sanfrancisco' ),
					'links_active_color'   => esc_html__( 'Links Active Color', 'sanfrancisco' )
				),
				'std'    => array(
					'box_background_color' => '#ffffff',
					'title_color'          => '#000000',
					'bio_color'            => '#8c8c8c',
					'links_regular_color'  => '#a3a3a3',
					'links_hover_color'    => '#000000',
					'links_active_color'   => '#000000'
				)
			),
			array(
				'id'     => 'pagination_color',
				'label'  => esc_html__( 'Pagination Box Color', 'sanfrancisco' ),
				'desc'   => esc_html__( 'Will affect pagination box in archive or page builder pages.', 'sanfrancisco' ),
				'type'   => 'colorpicker',
				'alpha'  => true,
				'labels' => array(
					'box_background_color' => esc_html__( 'Box Background Color', 'sanfrancisco' ),
					'links_regular_color'  => esc_html__( 'Links Regular Color', 'sanfrancisco' ),
					'links_hover_color'    => esc_html__( 'Links Hover Color', 'sanfrancisco' ),
					'links_active_color'   => esc_html__( 'Links Active Color', 'sanfrancisco' )
				),
				'std'    => array(
					'box_background_color' => '#ffffff',
					'links_regular_color'  => '#bfbfbf',
					'links_hover_color'    => '#000000',
					'links_active_color'   => '#000000'
				)
			),
			array(
				'id'    => 'custom_codes',
				'label' => esc_html__( 'Custom Codes', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Add your custom code into specific parts of the theme', 'sanfrancisco' ),
				'type'  => 'section',
				'icon'  => 'code'
			),
			array(
				'id'     => 'css_custom_code',
				'label'  => esc_html__( 'Custom CSS', 'sanfrancisco' ),
				'desc'   => esc_html__( 'Add some quick css into this box.', 'sanfrancisco' ),
				'type'   => 'code',
				'editor' => 'css'
			),
			array(
				'id'     => 'header_custom_code',
				'label'  => esc_html__( 'Header Custom Code', 'sanfrancisco' ),
				'desc'   => esc_html__( 'Add some custom code into the header. The code will be placed between &lt;head&gt; tags.', 'sanfrancisco' ),
				'type'   => 'code',
				'editor' => 'html'
			),
			array(
				'id'     => 'footer_custom_code',
				'label'  => esc_html__( 'Footer Custom Code', 'sanfrancisco' ),
				'desc'   => esc_html__( 'Add some custom code info the footer. The code will be placed right above &lt;/body&gt; closing tag.', 'sanfrancisco' ),
				'type'   => 'code',
				'editor' => 'html'
			)
		);

		// @todo: These options will be enabled in the upcoming update
		$disabled_fields = array(
			'responsive',
			'prevent_duplication'
		);
		$disabled_meta_data = array(
			'date'
		);
		foreach ( $to_fields as $k => $v ) {
			if ( in_array( $v['id'], $disabled_fields ) ) {
				unset( $to_fields[ $k ] );
			} else if ( preg_match( '#^meta_data#', $v['id'] ) && array_key_exists( 'choices', $v ) ) {
				foreach ( $v['choices'] as $i => $j ) {
					if ( in_array( $j['value'], $disabled_meta_data ) ) {
						unset( $to_fields[ $k ]['choices'][ $i ] );
					}
				}
			}
		}

		/*
		 * Allow theme options fields to be filtered before building
		 */
		$to_fields = apply_filters( 'sanfrancisco_theme_options_fields_args', $to_fields );

		/*
		 * If settings are not the same update the DB
		 */
		if ( $to_saved_fields !== $to_fields ) {
			update_option( $to_id .'_settings', $to_fields );
		}

		// Get FlexAds ad choices
		$pb_module_advertisement_choice = array();
		$pb_module_ad_select = array();
		if ( class_exists( 'Agg_Flex_Ads' ) ) {

			$pb_module_advertisement_choice = array(
				'alt'   => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'value' => 'advertisement',
				'image' => sanfrancisco_locate_template_uri( 'library/admin/images/advertisement.jpg' )
			);

			$pb_module_ad_select = array(
				'id'        => 'ad_id',
				'label'     => esc_html__( 'Choose Ad', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose the ad created with FlexAds to display in this module.', 'sanfrancisco' ),
				'type'      => 'select',
				'choices'   => array(),
				'condition' => 'layout:is(advertisement)'
			);

			$ads_by_locations = agg_flex_ads_get_ads( array(), array(
				'ad_types' => true
			) );

			foreach ( $ads_by_locations as $location ) {

				$opt_group = array(
					'type'  => 'optgroup',
					'label' => $location[ 'title' ],
					'value' => array()
				);

				foreach ( $location['ads'] as $location_ad ) {
					$opt_group['value'][] = array(
						'label' => $location_ad['title'],
						'value' => $location_ad['id']
					);
				}

				$pb_module_ad_select['choices'][] = $opt_group;

			}

		}

		// Module layout choices
		$pb_module_layout_choices = array(
			array(
				'alt' => esc_html__( 'Grid Posts', 'sanfrancisco' ),
				'value' => 'grid_posts',
				'image' => sanfrancisco_locate_template_uri( 'library/admin/images/grid-posts.jpg' )
			),
			array(
				'alt' => esc_html__( 'Featured Posts', 'sanfrancisco' ),
				'value' => 'featured_posts',
				'image' => sanfrancisco_locate_template_uri( 'library/admin/images/featured-posts.jpg' )
			),
			$pb_module_advertisement_choice,
			array(
				'alt' => esc_html__( 'Post/Page Content', 'sanfrancisco' ),
				'value' => 'singular',
				'image' => sanfrancisco_locate_template_uri( 'library/admin/images/page-content.jpg' )
			),
			array(
				'alt' => esc_html__( 'Custom Html or Shortcode', 'sanfrancisco' ),
				'value' => 'html',
				'image' => sanfrancisco_locate_template_uri( 'library/admin/images/custom-html.jpg' )
			)
		);

		/*
		 * Page builder settings
		 */
		$pb_settings = array(
			'section_settings' => array(
				array(
					'id'      => 'layout',
					'label'   => esc_html__( 'Section Layout', 'sanfrancisco' ),
					'type'    => 'radio_select',
					'std'     => 'ws',
					'choices' => array(
						array(
							'text' => 'Full Width',
							'value' => 'full'
						),
						array(
							'text' => 'Section with Sidebar',
							'value' => 'ws'
						)
					)
				),
				array(
					'id'        => 'sidebar',
					'label'     => esc_html__( 'Sidebar', 'sanfrancisco' ),
					'desc'      => esc_html__( 'Choose any sidebar that you want to display in this section', 'sanfrancisco' ),
					'type'      => 'sidebar_select',
					'std'       => 'sanfrancisco-default-sidebar',
					'condition' => 'layout:is(ws)'
				),
				array(
					'id'        => 'sidebar_position',
					'label'     => esc_html__( 'Sidebar Position', 'sanfrancisco' ),
					'type'      => 'radio_select',
					'std'       => is_rtl() ? 'left' : 'right',
					'choices'   => array(
						array(
							'text' => esc_html__( 'Left', 'sanfrancisco' ),
							'value' => 'left'
						),
						array(
							'text' => esc_html__( 'Right', 'sanfrancisco' ),
							'value' => 'right'
						)
					),
					'condition' => 'layout:is(ws)'
				),
				array(
					'id'      => 'visibility',
					'label'   => esc_html__( 'Visibility for Devices', 'sanfrancisco' ),
					'type'    => 'checker',
					'std'     => array( 'visible-xs', 'visible-sm', 'visible-md', 'visible-lg' ),
					'choices' => $visibility_choices
				),
				array(
					'id'    => 'class_name',
					'label' => esc_html__( 'Extra Class Name', 'sanfrancisco' ),
					'desc'  => esc_html__( 'Add section class(es) seperated by space', 'sanfrancisco' ),
					'type'  => 'text'
				)
			),
			'section_modules' => array(
				array(
					'id'      => 'layout',
					'label'   => esc_html__( 'Choose Module', 'sanfrancisco' ),
					'desc'    => esc_html__( 'Choose any module to display inside the specified page section.', 'sanfrancisco' ),
					'type'    => 'radio_select',
					'std'     => 'grid_posts',
					'choices' => $pb_module_layout_choices
				),
				$pb_module_ad_select,
				array(
					'id' => 'custom_html',
					'label' => esc_html__( 'Custom Html', 'sanfrancisco' ),
					'type' => 'wp_editor',
					'args'  => array(
						'editor_height' => 240
					),
					'condition' => 'layout:is(html)'
				),
				array(
					'id'        => 'post_id',
					'label'     => 'Post/Page ID',
					'desc'      => esc_html__( 'Type any post or page id to show the content in the module', 'sanfrancisco' ),
					'type'      => 'text',
					'std'       => $post ? $post->ID : '',
					'condition' => 'layout:is(singular)'
				),
				array(
					'id'        => 'fp_posts_layout',
					'label'     => esc_html__( 'Featured Posts Layout', 'sanfrancisco' ),
					'type'      => 'radio_select',
					'std'       => 'style_a',
					'choices'   => array(
						array(
							'alt' => esc_html__( 'Style A', 'sanfrancisco' ),
							'value' => 'style_a',
							'image' => sanfrancisco_locate_template_uri( 'library/admin/images/featured-posts-style-a.jpg' )
						),
						array(
							'alt' => esc_html__( 'Style B', 'sanfrancisco' ),
							'value' => 'style_b',
							'image' => sanfrancisco_locate_template_uri( 'library/admin/images/featured-posts-style-b.jpg' )
						),
						array(
							'alt' => esc_html__( 'Style C', 'sanfrancisco' ),
							'value' => 'style_c',
							'image' => sanfrancisco_locate_template_uri( 'library/admin/images/featured-posts-style-c.jpg' )
						),
						array(
							'alt' => esc_html__( 'Style D', 'sanfrancisco' ),
							'value' => 'style_d',
							'image' => sanfrancisco_locate_template_uri( 'library/admin/images/featured-posts-style-d.jpg' )
						),
						array(
							'alt' => esc_html__( 'Style E', 'sanfrancisco' ),
							'value' => 'style_e',
							'image' => sanfrancisco_locate_template_uri( 'library/admin/images/featured-posts-style-e.jpg' )
						),
						array(
							'alt' => esc_html__( 'Style F', 'sanfrancisco' ),
							'value' => 'style_f',
							'image' => sanfrancisco_locate_template_uri( 'library/admin/images/featured-posts-style-f.jpg' )
						)
					),
					'condition' => 'layout:is(featured_posts)'
				),
				array(
					'id'        => 'fp_pagination_type',
					'label'     => esc_html__( 'Pagination Type', 'sanfrancisco' ),
					'type'      => 'select',
					'std'       => 'carousel',
					'choices'   => array(
						array(
							'label' => esc_html__( 'None', 'sanfrancisco' ),
							'value' => 'none'
						),
						array(
							'label' => esc_html__( 'Carousel', 'sanfrancisco' ),
							'value' => 'carousel'
						)
					),
					'condition' => 'layout:is(featured_posts),fp_posts_layout:not(style_a),fp_posts_layout:not(style_b)'
				),
				array(
					'id'    => 'fp_autoplay',
					'label' => esc_html__( 'Enable Autoplay', 'sanfrancisco' ),
					'type' => 'toggle',
					'std' => 'false',
					'condition' => 'layout:is(featured_posts),fp_posts_layout:not(style_a),fp_posts_layout:not(style_b),fp_pagination_type:is(carousel)'
				),
				array(
					'id' => 'fp_autoplay_timeout',
					'label' => esc_html__( 'Autoplay Timeout', 'sanfrancisco' ),
					'type' => 'range',
					'unit' => 'miliseconds',
					'minmax' => '1000,20000',
					'std' => '5000',
					'condition' => 'layout:is(featured_posts),fp_posts_layout:not(style_a),fp_posts_layout:not(style_b),fp_pagination_type:is(carousel),fp_autoplay:is(true)'
				),
				array(
					'id' => 'fp_autoplay_hover_pause',
					'label' => esc_html__( 'Pause Autoplay on Mouse Over', 'sanfrancisco' ),
					'type' => 'toggle',
					'std' => 'true',
					'condition' => 'layout:is(featured_posts),fp_posts_layout:not(style_a),fp_posts_layout:not(style_b),fp_pagination_type:is(carousel),fp_autoplay:is(true)'
				),
				array(
					'id' => 'fp_entry_body_position',
					'label' => esc_html__( 'Post Body Position', 'sanfrancisco' ),
					'desc' => esc_html__( 'Choose where post title and meta data will be placed', 'sanfrancisco' ),
					'type' => 'radio_select',
					'std' => 'bottom',
					'choices' => array(
						array(
							'text' => esc_html__( 'Bottom', 'sanfrancisco' ),
							'value' => 'bottom'
						),
						array(
							'text' => esc_html__( 'Center', 'sanfrancisco' ),
							'value' => 'center'
						)
					),
					'condition' => 'layout:is(featured_posts)'
				),
				array(
					'id' => 'fp_entry_body_visibility',
					'label' => esc_html__( 'Post Body Visibility on Desktop', 'sanfrancisco' ),
					'type' => 'radio_select',
					'std' => 'always',
					'choices' => array(
						array(
							'text' => esc_html__( 'Always', 'sanfrancisco' ),
							'value' => 'always'
						),
						array(
							'text' => esc_html__( 'Show On Hover', 'sanfrancisco' ),
							'value' => 'hover'
						),
						array(
							'text' => esc_html__( 'Hide On Hover', 'sanfrancisco' ),
							'value' => 'hide_hover'
						),
						array(
							'text' => esc_html__( 'Never', 'sanfrancisco' ),
							'value' => 'never'
						)
					),
					'condition' => 'layout:is(featured_posts)'
				),
				array(
					'id' => 'fp_entry_body_mobile_visibility',
					'label' => esc_html__( 'Post Body Visibility on Mobile', 'sanfrancisco' ),
					'type' => 'radio_select',
					'std' => 'always',
					'choices' => array(
						array(
							'text' => esc_html__( 'Always', 'sanfrancisco' ),
							'value' => 'always'
						),
						array(
							'text' => esc_html__( 'Never', 'sanfrancisco' ),
							'value' => 'never'
						)
					),
					'condition' => 'layout:is(featured_posts)'
				),
			    array(
			        'id' => 'fp_carousel_buttons_visibility',
			        'label' => esc_html__( 'Carousel Prev/Next Buttons Visibility on Desktop', 'sanfrancisco' ),
					'type' => 'radio_select',
			        'std' => 'hover',
			        'choices' => array(
			        	array(
			        		'text' => esc_html__( 'Always', 'sanfrancisco' ),
					        'value' => 'always'
				        ),
				        array(
				        	'text' => esc_html__( 'On Hover', 'sanfrancisco' ),
					        'value' => 'hover'
				        ),
				        array(
				        	'text' => esc_html__( 'Never', 'sanfrancisco' ),
					        'value' => 'never'
				        )
			        ),
			        'condition' => 'layout:is(featured_posts),fp_pagination_type:is(carousel),fp_posts_layout:not(style_a),fp_posts_layout:not(style_b)'
				),
			    array(
					'id' => 'fp_carousel_buttons_mobile_visibility',
					'label' => esc_html__( 'Carousel Prev/Next Buttons Visibility on Mobile', 'sanfrancisco' ),
					'type' => 'radio_select',
					'std' => 'always',
					'choices' => array(
						array(
							'text' => esc_html__( 'Always', 'sanfrancisco' ),
							'value' => 'always'
						),
						array(
							'text' => esc_html__( 'Never', 'sanfrancisco' ),
							'value' => 'never'
						)
					),
					'condition' => 'layout:is(featured_posts),fp_pagination_type:is(carousel),fp_posts_layout:not(style_a),fp_posts_layout:not(style_b)'
				),
				array(
					'id' => 'fp_carousel_dots_visibility',
					'label' => esc_html__( 'Carousel Dots Visibility on Desktop', 'sanfrancisco' ),
					'type' => 'radio_select',
					'std' => 'never',
					'choices' => array(
						array(
							'text' => esc_html__( 'Always', 'sanfrancisco' ),
							'value' => 'always'
						),
						array(
							'text' => esc_html__( 'Never', 'sanfrancisco' ),
							'value' => 'never'
						)
					),
					'condition' => 'layout:is(featured_posts),fp_pagination_type:is(carousel),fp_posts_layout:not(style_a),fp_posts_layout:not(style_b)'
				),
				array(
					'id' => 'fp_carousel_dots_mobile_visibility',
					'label' => esc_html__( 'Carousel Dots Visibility on Mobile', 'sanfrancisco' ),
					'type' => 'radio_select',
					'std' => 'never',
					'choices' => array(
						array(
							'text' => esc_html__( 'Always', 'sanfrancisco' ),
							'value' => 'always'
						),
						array(
							'text' => esc_html__( 'Never', 'sanfrancisco' ),
							'value' => 'never'
						)
					),
					'condition' => 'layout:is(featured_posts),fp_pagination_type:is(carousel),fp_posts_layout:not(style_a),fp_posts_layout:not(style_b)'
				),
				array(
					'id'     => 'fp_color',
					'label'  => esc_html__( 'Featured Posts Color Scheme', 'sanfrancisco' ),
					'type'   => 'colorpicker',
					'alpha'  => true,
					'labels' => array(
						'overlay_background_color'        => esc_html__( 'Overlay Color on Desktop', 'sanfrancisco' ),
						'overlay_color'                   => esc_html__( 'Text Color on Desktop', 'sanfrancisco' ),
						'overlay_hover_background_color'  => esc_html__( 'Overlay Hover Color on Desktop', 'sanfrancisco' ),
						'overlay_hover_color'             => esc_html__( 'Text Hover Color on Desktop', 'sanfrancisco' ),
						'overlay_mobile_background_color' => esc_html__( 'Overlay Color on Mobile', 'sanfrancisco' ),
						'overlay_mobile_color'            => esc_html__( 'Text Color on Mobile', 'sanfrancisco' ),
						'carousel_buttons_color'          => esc_html__( 'Carousel Prev/Next Buttons Arrow Color', 'sanfrancisco' ),
						'carousel_buttons_border_color'   => esc_html__( 'Carousel Prev/Next Buttons Background Color', 'sanfrancisco' )
					),
					'std'    => array(
						'overlay_background_color'        => 'rgba(0,0,0,0.3)',
						'overlay_color'                   => '#ffffff',
						'overlay_hover_background_color'  => 'rgba(0,0,0,0.25)',
						'overlay_hover_color'             => '#ffffff',
						'overlay_mobile_background_color' => 'rgba(0,0,0,0.3)',
						'overlay_mobile_color'            => '#ffffff',
						'carousel_buttons_color'          => '#000000',
						'carousel_buttons_border_color'   => '#ffffff'
					),
					'condition' => 'layout:is(featured_posts)'
				),
				array(
					'id'        => 'gp_posts_layout',
					'label'     => esc_html__( 'Grid Posts Layout', 'sanfrancisco' ),
					'type'      => 'radio_select',
					'std'       => 'vertical_1_col',
					'choices'   => $gp_posts_layout_choices,
					'condition' => 'layout:is(grid_posts)'
				),
				array(
					'id'        => 'gp_pagination_type',
					'label'     => esc_html__( 'Pagination Type', 'sanfrancisco' ),
					'type'      => 'select',
					'std'       => 'none',
					'choices'   => $gp_pagination_choices,
					'condition' => 'layout:is(grid_posts)'
				),
				array(
					'id'        => 'posts_per_page',
					'label'     => esc_html__( 'Number of Posts', 'sanfrancisco' ),
					'type'      => 'range',
					'minmax'     => '1,100',
					'std'       => '12',
					'operator'  => 'or',
				    'condition' => 'layout:is(grid_posts),layout:is(featured_posts)'
				),
				array(
					'id'        => 'posts_offset',
					'label'     => esc_html__( 'Posts Offset', 'sanfrancisco' ),
					'type'      => 'range',
					'minmax'     => '0,100',
					'std'       => '0',
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(featured_posts)'
				),
				array(
					'id'        => 'post_types',
					'label'     => esc_html__( 'Filter by Post Types', 'sanfrancisco' ),
					'type'      => 'post_type_checker',
					'std'       => 'all',
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(featured_posts)'
				),
				array(
					'id'        => 'post_taxonomies',
					'label'     => esc_html__( 'Filter by Taxonomies', 'sanfrancisco' ),
					'type'      => 'taxonomy_checker',
					'std'       => 'all',
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(featured_posts)'
				),
				array(
					'id'        => 'post_tags',
					'label'     => esc_html__( 'Filter by Tag Names', 'sanfrancisco' ),
					'desc'      => esc_html__( 'Add tag(s) seperated by comma. i.e. sports, cooking', 'sanfrancisco' ),
					'type'      => 'text',
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(featured_posts)'
				),
				array(
					'id'        => 'post_ids',
					'label'     => esc_html__( 'Filter by Post Id\'s', 'sanfrancisco' ),
					'desc'      => esc_html__( 'Specify post ids separated by comma. i.e. 45,73,132,19', 'sanfrancisco' ),
					'type'      => 'text',
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(featured_posts)'
				),
				array(
					'id'        => 'excluded_post_ids',
					'label'     => esc_html__( 'Excluded Post Id\'s', 'sanfrancisco' ),
					'desc'      => esc_html__( 'Specify excluded post ids separated by comma. i.e. 45,73,132,19', 'sanfrancisco' ),
					'type'      => 'text',
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(featured_posts)'
				),
				array(
					'id'        => 'orderby',
					'label'     => esc_html__( 'Order Posts by', 'sanfrancisco' ),
					'type'      => 'select',
					'std'       => 'date',
					'choices'   => $orderby_choices,
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(featured_posts)'
				),
				array(
					'id'        => 'order',
					'label'     => esc_html__( 'Order Type', 'sanfrancisco' ),
					'type'      => 'radio_select',
					'std'       => 'desc',
					'choices'   => $order_choices,
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(featured_posts)'
				),
				array(
					'id'        => 'meta_data',
					'label'     => esc_html__( 'Posts Meta Data', 'sanfrancisco' ),
					'desc'      => esc_html__( 'Check which meta data to show for the posts in this module', 'sanfrancisco' ),
					'type'      => 'checker',
					'std'       => array(
						'date',
						'excerpt',
						'views',
						'likes',
						'comments',
						'byline',
						'category',
						'trending_icon'
					),
					'choices'   => array(
						array(
							'label' => esc_html__( 'Excerpt', 'sanfrancisco' ),
							'value' => 'excerpt'
						),
						array(
							'label' => esc_html__( 'Date', 'sanfrancisco' ),
							'value' => 'date'
						),
						array(
							'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
							'value' => 'byline'
						),
						array(
							'label' => esc_html__( 'Views', 'sanfrancisco' ),
							'value' => 'views'
						),
						array(
							'label' => esc_html__( 'Likes', 'sanfrancisco' ),
							'value' => 'likes'
						),
						array(
							'label' => esc_html__( 'Comments', 'sanfrancisco' ),
							'value' => 'comments'
						),
						array(
							'label' => esc_html__( 'Category Name', 'sanfrancisco' ),
							'value' => 'category'
						),
						array(
							'label' => esc_html__( 'Trending Icon', 'sanfrancisco' ),
							'value' => 'trending_icon'
						)
					),
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(featured_posts)'
				),
				array(
					'id'        => 'excerpt_length',
					'label'     => 'Excerpt Length',
					'desc'      => esc_html__( 'Choose how long will the excerpt be display for the posts', 'sanfrancisco' ),
					'type'      => 'range',
					'minmax'     => '0,200',
					'std'       => '50',
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(featured_posts)'
				),
				array(
					'id'        => 'display_tags',
					'label'     => esc_html__( 'Display Tags', 'sanfrancisco' ),
					'desc'      => esc_html__( 'Enable this option if you want post tags to be shown in the module', 'sanfrancisco' ),
					'type'      => 'toggle',
					'std'       => 'true',
					'condition' => 'layout:is(grid_posts)'
				),
				array(
					'id'        => 'tag_limit',
					'label'     => esc_html__( 'Tag Limit', 'sanfrancisco' ),
					'desc'      => esc_html__( 'Choose maximum number of tags to display', 'sanfrancisco' ),
					'type'      => 'range',
					'std'       => 3,
					'minmax'     => '1,25',
					'condition' => 'layout:is(grid_posts),display_tags:is(true)'
				),
				array(
					'id'        => 'prevent_duplication',
					'label'     => esc_html__( 'Do not duplicate (Display only in this module)', 'sanfrancisco' ),
					'desc'      => esc_html__( 'Enable this option if you want posts in this module to be excluded from other modules so they don\'t appear twice', 'sanfrancisco' ),
					'type'      => 'toggle',
					'std'       => 'false',
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(featured_posts)'
				),
				array(
					'id'        => 'title',
					'label'     => esc_html__( 'Module Title', 'sanfrancisco' ),
					'type'      => 'text',
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(advertisement)'
				),
				array(
					'id'        => 'title_position',
					'label'     => esc_html__( 'Module Title Position', 'sanfrancisco' ),
					'desc'      => esc_html__( 'Choose horizontal position of the module title', 'sanfrancisco' ),
					'type'      => 'radio_select',
					'std'       => 'center',
					'choices'   => array(
						array(
							'text' => esc_html__( 'Left', 'sanfrancisco' ),
							'value' => 'left'
						),
						array(
							'text' => esc_html__( 'Center', 'sanfrancisco' ),
							'value' => 'center'
						),
						array(
							'text' => esc_html__( 'Right', 'sanfrancisco' ),
							'value' => 'right'
						)
					),
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(advertisement)'
				),
				array(
					'id'        => 'title_wrap_margin_bottom',
					'label'     => esc_html__( 'Module Title Bottom Spacing', 'sanfrancisco' ),
					'type'      => 'range',
					'std'       => '35',
					'minmax'    => '0,50',
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(advertisement)'
				),
				array(
					'id' => 'title_color',
					'label' => esc_html__( 'Module Title Color', 'sanfrancisco' ),
					'type' => 'colorpicker',
					'labels' => array(
						'text_color' => esc_html__( 'Title Text Color', 'sanfrancisco' ),
						'bar_background_color' => esc_html__( 'Line Color', 'sanfrancisco' )
					),
					'std' => array(
						'text_color' => '#000000',
						'bar_background_color' => '#d7d7d7'
					),
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(advertisement)'
				),
				array(
					'id' => 'title_font',
					'label' => esc_html__( 'Module Title Font', 'sanfrancisco' ),
					'type' => 'font',
					'std' => array(
						'font_family' => 'Roboto',
						'font_weight_style' => '900',
						'font_subsets' => 'latin-ext',
						'font_size' => 14
					),
					'properties' => array(
						'font_family',
						'font_weight_style',
						'font_subsets',
						'font_size'
					),
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(advertisement)'
				),
				array(
					'id'        => 'title_has_bar',
					'label'     => esc_html__( 'Display Line in Module Title', 'sanfrancisco' ),
					'type'      => 'toggle',
					'std'       => 'true',
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(advertisement)'
				),
				array(
					'id'        => 'title_bar_height',
					'label'     => esc_html__( 'Module Title Line Tickness', 'sanfrancisco' ),
					'type'      => 'range',
					'minmax'     => '1,25',
					'std'       => '1',
					'operator'  => 'or',
					'condition' => 'layout:is(grid_posts),layout:is(advertisement)'
				),
				array(
					'id'    => 'class_name',
					'label' => esc_html__( 'Extra Class Name', 'sanfrancisco' ),
					'desc'  => esc_html__( 'Add section class(es) seperated by space for the module', 'sanfrancisco' ),
					'type'  => 'text'
				)
			)
		);

		// @todo: These options will be enabled in the upcoming update
		foreach ( $pb_settings['section_modules'] as $k => $v ) {
			if ( array_key_exists( 'id', $v ) && in_array( $v['id'], $disabled_fields ) ) {
				unset( $pb_settings['section_modules'][ $k ] );
			} else if ( array_key_exists( 'id', $v ) && preg_match( '#^meta_data#', $v['id'] ) && array_key_exists( 'choices', $v ) ) {
				foreach ( $v['choices'] as $i => $j ) {
					if ( in_array( $j['value'], $disabled_meta_data ) ) {
						unset( $pb_settings['section_modules'][ $k ]['choices'][ $i ] );
					}
				}
			}
		}

		/*
		 * Allow page builder fields to be filtered before building
		 */
		$pb_settings = apply_filters( 'sanfrancisco_page_builder_settings_args', $pb_settings );

		/*
		 * Page options fields
		 */
		$pa_fields = array(
			array(
				'id'    => 'sanfrancisco_boxed_layout',
				'label' => esc_html__( 'Boxed Layout', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to be able to set background color to the full width page layout area for this page.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'        => 'sanfrancisco_boxed_layout_background_color',
				'label'     => esc_html__( 'Boxed Layout Background Color', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Set background color to the full width page layout area for this page.', 'sanfrancisco' ),
				'type'      => 'colorpicker',
				'alpha'     => true,
				'std'       => '#ffffff',
				'condition' => 'sanfrancisco_boxed_layout:is(true)'
			),
			array(
				'id'      => 'sanfrancisco_layout',
				'label'   => esc_html__( 'Layout', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'choices' => array(
					array(
						'text' => esc_html__( 'Full Width Content', 'sanfrancisco' ),
						'value' => 'full'
					),
					array(
						'text' => esc_html__( 'Content with Sidebar', 'sanfrancisco' ),
						'value' => 'ws'
					)
				)
			),
			array(
				'id'      => 'sanfrancisco_background_inheritance',
				'label'   => esc_html__( 'Background', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Use parent background settings (Theme Options &gt; Blog &gt; Page &gt; Background) or set custom background for this page', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Background', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'sanfrancisco_background',
				'label'     => esc_html__( 'Set Background', 'sanfrancisco' ),
				'type'      => 'background',
				'std'       => $background_std,
				'condition' => 'sanfrancisco_background_inheritance:is(custom)'
			),
			array(
				'id'        => 'sanfrancisco_sidebar',
				'label'     => esc_html__( 'Sidebar', 'sanfrancisco' ),
				'type'      => 'sidebar_select',
				'condition' => 'sanfrancisco_layout:is(ws)'
			),
			array(
				'id'        => 'sanfrancisco_sidebar_position',
				'label'     => esc_html__( 'Sidebar Position', 'sanfrancisco' ),
				'type'      => 'radio_select',
				'choices'   => array(
					array(
						'text' => esc_html__( 'Left', 'sanfrancisco' ),
						'value' => 'left'
					),
					array(
						'text' => esc_html__( 'Right', 'sanfrancisco' ),
						'value' => 'right'
					)
				),
				'condition' => 'sanfrancisco_layout:is(ws)'
			),
			array(
				'id'    => 'sanfrancisco_display_breadcrumb',
				'label' => esc_html__( 'Display Breadcrumb', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show breadcrumb in this page, disable this option.', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'    => 'sanfrancisco_display_title',
				'label' => esc_html__( 'Display Title', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show page title in this page, disable this option.', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'    => 'sanfrancisco_display_title_subline',
				'label' => esc_html__( 'Display Title Subline', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show page title subline in this page, disable this option.', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'    => 'sanfrancisco_display_featured_image',
				'label' => esc_html__( 'Display Featured Image', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show featured image in this page, disable this option', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			/*array(
				'id'        => 'sanfrancisco_featured_image_style',
				'label'     => esc_html__( 'Featured Image Style', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose how featured image will display in this page.', 'sanfrancisco' ),
				'type'      => 'radio_select',
				'choices'   => array(
					array(
						'text'  => esc_html__( 'Classic', 'sanfrancisco' ),
						'value' => 'cl'
					),
					array(
						'text'  => esc_html__( 'Full Width', 'sanfrancisco' ),
						'value' => 'fw'
					),
					array(
						'text'  => esc_html__( 'Screen Width', 'sanfrancisco' ),
						'value' => 'sw'
					)
				),
				'condition' => 'sanfrancisco_display_featured_image:is(true)'
			),
			array(
				'id'        => 'sanfrancisco_featured_image_has_parallax',
				'label'     => esc_html__( 'Apply Parallax to the Featured Image', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Enable this option to apply parallax feature to the featured image in this page.', 'sanfrancisco' ),
				'type'      => 'toggle',
				'condition' => 'sanfrancisco_featured_image_style:not(cl)'
			),*/
			array(
				'id'        => 'sanfrancisco_display_credit_line',
				'label'     => esc_html__( 'Display Credit Line Over Featured Image', 'sanfrancisco' ),
				'desc'      => esc_html__( 'If you don\'t want to show credit line over featured image in this page, disable this option', 'sanfrancisco' ),
				'type'      => 'toggle',
				'condition' => 'sanfrancisco_display_featured_image:is(true)'
			),
			array(
				'id'    => 'sanfrancisco_display_content',
				'label' => esc_html__( 'Display Content', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show page content in this page, disable this option.', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'    => 'sanfrancisco_dropcap',
				'label' => esc_html__( 'Apply Drop Cap', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Create a large dropped initial capital letter for the page content', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'      => 'sanfrancisco_meta_data',
				'label'   => esc_html__( 'Meta Data', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Choose which meta data to show in this page', 'sanfrancisco' ),
				'type'    => 'checker',
				'choices' => array(
					array(
						'label' => esc_html__( 'Date', 'sanfrancisco' ),
						'value' => 'date'
					),
					array(
						'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
						'value' => 'byline'
					),
					array(
						'label' => esc_html__( 'Views', 'sanfrancisco' ),
						'value' => 'views'
					),
					array(
						'label' => esc_html__( 'Likes', 'sanfrancisco' ),
						'value' => 'likes'
					),
					array(
						'label' => esc_html__( 'Comments', 'sanfrancisco' ),
						'value' => 'comments'
					)
				)
			),
			array(
				'id'    => 'sanfrancisco_display_like_button',
				'label' => esc_html__( 'Display Like Button', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show like button in this page, disable this option.', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'    => 'sanfrancisco_display_author_info',
				'label' => esc_html__( 'Display About Author Section', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show about author section in this page, disable this option.', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'    => 'sanfrancisco_display_comments',
				'label' => esc_html__( 'Display Comments', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show comments in this page, disable this option.', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'    => 'sanfrancisco_is_trending',
				'label' => esc_html__( 'Mark as Trending', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to mark this page as "trending post" manually.', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id' => 'sanfrancisco_advertisement_inheritance',
				'label' => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use global advertisement settings (Theme Options &gt; Blog &gt; Page) or select custom ads for this page.', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Ads', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'sanfrancisco_advertisement',
				'label'     => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Select ads for any ad locations.', 'sanfrancisco' ),
				'type'      => 'advertisement',
				'locations' => array_merge( array( 'post' ), $ad_locations_with_positions ),
				'condition' => 'sanfrancisco_advertisement_inheritance:is(custom)'
			),
			array(
				'id'    => 'sanfrancisco_ignore_override',
				'label' => esc_html__( 'Ignore Override', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option if you want to ignore global pages override option for this page', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			)
		);

		foreach ( $pa_fields as $i => $field ) {
			if ( ! array_key_exists( 'std', $field ) ) {
				$pa_fields[ $i ]['std'] = sanfrancisco_get_option( $field['id'] .'__page' );
			}
		}

		/*
		 * Allow page options fields to be filtered before building
		 */
		$pa_fields = apply_filters( 'sanfrancisco_page_options_fields_args', $pa_fields );

		/*
		 * Post Options Fields
		 */
		$po_fields = array(
			array(
				'id'    => 'sanfrancisco_boxed_layout',
				'label' => esc_html__( 'Boxed Layout', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to be able to set background color to the full width page layout area for this post.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'        => 'sanfrancisco_boxed_layout_background_color',
				'label'     => esc_html__( 'Boxed Layout Background Color', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Set background color to the full width page layout area for this post.', 'sanfrancisco' ),
				'type'      => 'colorpicker',
				'alpha'     => true,
				'std'       => '#ffffff',
				'condition' => 'sanfrancisco_boxed_layout:is(true)'
			),
			array(
				'id'      => 'sanfrancisco_layout',
				'label'   => esc_html__( 'Layout', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'choices' => array(
					array(
						'text' => esc_html__( 'Full Width Content', 'sanfrancisco' ),
						'value' => 'full'
					),
					array(
						'text' => esc_html__( 'Content with Sidebar', 'sanfrancisco' ),
						'value' => 'ws'
					)
				)
			),
			array(
				'id'      => 'sanfrancisco_background_inheritance',
				'label'   => esc_html__( 'Background', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Use parent background settings (Theme Options &gt; Blog &gt; Page &gt; Background) or set custom background for this post', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Background', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'sanfrancisco_background',
				'label'     => esc_html__( 'Set Background', 'sanfrancisco' ),
				'type'      => 'background',
				'std'       => $background_std,
				'condition' => 'sanfrancisco_background_inheritance:is(custom)'
			),
			array(
				'id'        => 'sanfrancisco_sidebar',
				'label'     => esc_html__( 'Sidebar', 'sanfrancisco' ),
				'type'      => 'sidebar_select',
				'condition' => 'sanfrancisco_layout:is(ws)'
			),
			array(
				'id'        => 'sanfrancisco_sidebar_position',
				'label'     => esc_html__( 'Sidebar Position', 'sanfrancisco' ),
				'type'      => 'radio_select',
				'choices'   => array(
					array(
						'text' => esc_html__( 'Left', 'sanfrancisco' ),
						'value' => 'left'
					),
					array(
						'text' => esc_html__( 'Right', 'sanfrancisco' ),
						'value' => 'right'
					)
				),
				'condition' => 'sanfrancisco_layout:is(ws)'
			),
			array(
				'id'    => 'sanfrancisco_display_breadcrumb',
				'label' => esc_html__( 'Display Breadcrumb', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show breadcrumb in this post, disable this option', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'    => 'sanfrancisco_display_title',
				'label' => esc_html__( 'Display Title', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show page title in this post, disable this option.', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'    => 'sanfrancisco_display_title_subline',
				'label' => esc_html__( 'Display Title Subline', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show page title subline in this post, disable this option', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'    => 'sanfrancisco_display_featured_image',
				'label' => esc_html__( 'Display Featured Image', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show featured image in this post, disable this option', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			/*array(
				'id'        => 'sanfrancisco_featured_image_style',
				'label'     => esc_html__( 'Featured Image Style', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose how featured image will display in this post.', 'sanfrancisco' ),
				'type'      => 'radio_select',
				'choices'   => array(
					array(
						'text'  => esc_html__( 'Classic', 'sanfrancisco' ),
						'value' => 'cl'
					),
					array(
						'text'  => esc_html__( 'Full Width', 'sanfrancisco' ),
						'value' => 'fw'
					),
					array(
						'text'  => esc_html__( 'Screen Width', 'sanfrancisco' ),
						'value' => 'sw'
					)
				),
				'condition' => 'sanfrancisco_display_featured_image:is(true)'
			),
			array(
				'id'        => 'sanfrancisco_featured_image_has_parallax',
				'label'     => esc_html__( 'Apply Parallax to the Featured Image', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Enable this option to apply parallax feature to the featured image in this post.', 'sanfrancisco' ),
				'type'      => 'toggle',
				'condition' => 'sanfrancisco_featured_image_style:not(cl)'
			),*/
			array(
				'id'        => 'sanfrancisco_display_credit_line',
				'label'     => esc_html__( 'Display Credit Line Over Featured Image', 'sanfrancisco' ),
				'desc'      => esc_html__( 'If you don\'t want to show credit line over featured image in this post, disable this option', 'sanfrancisco' ),
				'type'      => 'toggle',
				'condition' => 'sanfrancisco_display_featured_image:is(true)'
			),
			array(
				'id'    => 'sanfrancisco_display_content',
				'label' => esc_html__( 'Display Content', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show post content in this post, disable this option.', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'    => 'sanfrancisco_dropcap',
				'label' => esc_html__( 'Apply Drop Cap', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Create a large dropped initial capital letter for the post content', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'      => 'sanfrancisco_meta_data',
				'label'   => esc_html__( 'Meta Data', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Choose which meta data to show in this post', 'sanfrancisco' ),
				'type'    => 'checker',
				'choices' => array(
					array(
						'label' => esc_html__( 'Date', 'sanfrancisco' ),
						'value' => 'date'
					),
					array(
						'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
						'value' => 'byline'
					),
					array(
						'label' => esc_html__( 'Views', 'sanfrancisco' ),
						'value' => 'views'
					),
					array(
						'label' => esc_html__( 'Likes', 'sanfrancisco' ),
						'value' => 'likes'
					),
					array(
						'label' => esc_html__( 'Comments', 'sanfrancisco' ),
						'value' => 'comments'
					),
					array(
						'label' => esc_html__( 'Category Name', 'sanfrancisco' ),
						'value' => 'category'
					),
					array(
						'label' => esc_html__( 'Trending Icon', 'sanfrancisco' ),
						'value' => 'trending_icon'
					)
				)
			),
			array(
				'id' => 'sanfrancisco_display_tags',
				'label' => esc_html__( 'Display Post Tags', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show post tags in this post, disable this option.', 'sanfrancisco'  ),
				'type' => 'toggle'
			),
			array(
				'id'        => 'sanfrancisco_tag_limit',
				'label'     => esc_html__( 'Tag Limit', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose maximum number of tags to display', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'     => '1,25',
				'condition' => 'sanfrancisco_display_tags:is(true)'
			),
			array(
				'id'    => 'sanfrancisco_display_like_button',
				'label' => esc_html__( 'Display Like Button', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show like button in this post, disable this option.', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'    => 'sanfrancisco_display_related_posts',
				'label' => esc_html__( 'Display Related Posts', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show related posts in this post, disable this option.', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'        => 'sanfrancisco_related_posts_layout',
				'label'     => esc_html__( 'Related Posts Layout', 'sanfrancisco' ),
				'type'      => 'radio_select',
				'choices'   => $gp_posts_layout_choices,
				'condition' => 'sanfrancisco_display_related_posts:is(true)'
			),
			array(
				'id'        => 'sanfrancisco_related_posts_per_page',
				'label'     => esc_html__( 'Number of Related Posts', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'     => '1,100',
				'condition' => 'sanfrancisco_display_related_posts:is(true)'
			),
			array(
				'id'        => 'sanfrancisco_related_posts_excluded_post_ids',
				'label'     => esc_html__( 'Excluded Related Post Id\'s', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Specify excluded post ids separated by comma. i.e. 45,73,132,19', 'sanfrancisco' ),
				'type'      => 'text',
				'condition' => 'sanfrancisco_display_related_posts:is(true)'
			),
			array(
				'id'        => 'sanfrancisco_related_posts_orderby',
				'label'     => esc_html__( 'Order Related Posts by', 'sanfrancisco' ),
				'type'      => 'select',
				'choices'   => $orderby_choices,
				'condition' => 'sanfrancisco_display_related_posts:is(true)'
			),
			array(
				'id'        => 'sanfrancisco_related_posts_order',
				'label'     => esc_html__( 'Related Posts Order Type', 'sanfrancisco' ),
				'type'      => 'radio_select',
				'choices'   => $order_choices,
				'condition' => 'sanfrancisco_display_related_posts:is(true)'
			),
			array(
				'id'        => 'sanfrancisco_related_posts_meta_data',
				'label'     => esc_html__( 'Related Posts Meta Data', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose which meta data to show in related posts', 'sanfrancisco' ),
				'type'      => 'checker',
				'choices'   => array(
					array(
						'label' => esc_html__( 'Excerpt', 'sanfrancisco' ),
						'value' => 'excerpt'
					),
					array(
						'label' => esc_html__( 'Date', 'sanfrancisco' ),
						'value' => 'date'
					),
					array(
						'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
						'value' => 'byline'
					),
					array(
						'label' => esc_html__( 'Views', 'sanfrancisco' ),
						'value' => 'views'
					),
					array(
						'label' => esc_html__( 'Likes', 'sanfrancisco' ),
						'value' => 'likes'
					),
					array(
						'label' => esc_html__( 'Comments', 'sanfrancisco' ),
						'value' => 'comments'
					),
					array(
						'label' => esc_html__( 'Category Name', 'sanfrancisco' ),
						'value' => 'category'
					),
					array(
						'label' => esc_html__( 'Trending Icon', 'sanfrancisco' ),
						'value' => 'trending_icon'
					)
				),
				'condition' => 'sanfrancisco_display_related_posts:is(true)'
			),
			array(
				'id'        => 'sanfrancisco_related_posts_excerpt_length',
				'label'     => 'Related Posts Excerpt Length',
				'desc'      => esc_html__( 'Choose how long will the excerpt be display for the related posts', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'     => '0,200',
				'condition' => 'sanfrancisco_display_related_posts:is(true)'
			),
			array(
				'id'    => 'sanfrancisco_display_author_info',
				'label' => esc_html__( 'Display About Author Section', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show about author section in this post, disable this option', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'    => 'sanfrancisco_display_comments',
				'label' => esc_html__( 'Display Comments', 'sanfrancisco' ),
				'desc'  => esc_html__( 'If you don\'t want to show comments in this post, disable this option.', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id'    => 'sanfrancisco_is_trending',
				'label' => esc_html__( 'Mark as Trending', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to mark this post as "trending post" manually.', 'sanfrancisco' ),
				'type'  => 'toggle'
			),
			array(
				'id' => 'sanfrancisco_advertisement_inheritance',
				'label' => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use global advertisement settings (Theme Options &gt; Blog &gt; Single Post) or select custom ads for this post.', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Ads', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'sanfrancisco_advertisement',
				'label'     => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Select ads for any ad locations.', 'sanfrancisco' ),
				'type'      => 'advertisement',
				'locations' => array_merge( array( 'post' ), $ad_locations_with_positions ),
				'condition' => 'sanfrancisco_advertisement_inheritance:is(custom)'
			),
			array(
				'id'    => 'sanfrancisco_ignore_override',
				'label' => esc_html__( 'Ignore Override', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option if you want to ignore global posts override option for this post', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			)
		);

		foreach ( $po_fields as $i => $field ) {
			if ( ! array_key_exists( 'std', $field ) ) {
				$po_fields[ $i ]['std'] = sanfrancisco_get_option( $field['id'] .'__single' );
			}
		}

		/*
		 * Allow post options fields to be filtered before building
		 */
		$po_fields = apply_filters( 'sanfrancisco_post_options_fields_args', $po_fields );

		/*
		 * Video Post Options Fields
		 */
		$vi_fields = array(
			array(
				'id'      => 'sanfrancisco_video_type',
				'label'   => esc_html__( 'Video Placement Type', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'external',
				'choices' => array(
					array(
						'text'  => esc_html__( 'External', 'sanfrancisco' ),
						'value' => 'external'
					),
					array(
						'text'  => esc_html__( 'Self-Hosted', 'sanfrancisco' ),
						'value' => 'internal'
					)
				)
			),
			array(
				'id'        => 'sanfrancisco_video_embed_code',
				'label'     => esc_html__( 'Video Embed Code', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Add the embed code of the video from services like Youtube, Vimeo, or Hulu', 'sanfrancisco' ),
				'type'      => 'code',
				'editor'    => 'html',
				'condition' => 'sanfrancisco_video_type:is(external)'
			),
			array(
				'id'         => 'sanfrancisco_video_url',
				'label'      => esc_html__( 'Video Url', 'sanfrancisco' ),
				'desc'       => esc_html__( 'Put the url of the video or choose from library', 'sanfrancisco' ),
				'type'       => 'media',
				'media_type' => 'video',
				'condition'  => 'sanfrancisco_video_type:is(internal)'
			),
			array(
				'id'    => 'sanfrancisco_video_display_media_icon',
				'label' => esc_html__( 'Display Play Icon', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to display play icon over featured image in video post teaser. (E.g. in grid posts, sidebar posts)', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'true'
			),
			array(
				'id'    => 'sanfrancisco_video_override_featured_image',
				'label' => esc_html__( 'Replace Video with Featured Image', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to hide featured image in the single post and display only this video instead.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'true'
			)
		);

		/*
		 * Allow video post options fields to be filtered before building
		 */
		$vi_fields = apply_filters( 'sanfrancisco_video_post_options_fields_args', $vi_fields );

		/*
		 * Audio Post Options Fields
		 */
		$au_fields = array(
			array(
				'id'      => 'sanfrancisco_audio_type',
				'label'   => esc_html__( 'Audio Placement Type', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'external',
				'choices' => array(
					array(
						'text' => esc_html__( 'External', 'sanfrancisco' ),
						'value' => 'external'
					),
					array(
						'text' => esc_html__( 'Self-Hosted', 'sanfrancisco' ),
						'value' => 'internal'
					)
				)
			),
			array(
				'id'        => 'sanfrancisco_audio_embed_code',
				'label'     => esc_html__( 'Audio Embed Code', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Add the embed code of the audio from services like SoundCloud or Rdio', 'sanfrancisco' ),
				'type'      => 'code',
				'editor'    => 'html',
				'condition' => 'sanfrancisco_audio_type:is(external)'
			),
			array(
				'id'        => 'sanfrancisco_audio_url',
				'label'     => esc_html__( 'Audio Url', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Put the url of the audio or choose from library', 'sanfrancisco' ),
				'type'      => 'media',
				'media_type'=> 'audio',
				'condition' => 'sanfrancisco_audio_type:is(internal)'
			),
			array(
				'id'    => 'sanfrancisco_audio_display_media_icon',
				'label' => esc_html__( 'Display Play Icon', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to display play icon over featured image in audio post teaser. (E.g. in grid posts, sidebar posts)', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'true'
			),
			array(
				'id'    => 'sanfrancisco_audio_override_featured_image',
				'label' => esc_html__( 'Replace Audio with Featured Image', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to hide featured image in the single post and display only this audio instead.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'true'
			),
			/*array( // @todo: this option will be available in the upcoming updates
				'id'    => 'sanfrancisco_audio_can_play_in_teaser',
				'label' => esc_html__( 'Play Audio in Post Teaser', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to be able to play the audio immediately in post teaser. (E.g. in grid posts, sidebar posts)', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			)*/
		);

		/*
		 * Allow audio post options fields to be filtered before building
		 */
		$au_fields = apply_filters( 'sanfrancisco_video_post_options_fields_args', $au_fields );

		/*
		 * Gallery Post Options Fields
		 */
		$ga_fields = array(
			array(
				'id'     => 'sanfrancisco_gallery_images',
				'label'  => esc_html__( 'Create Gallery', 'sanfrancisco' ),
				'desc'   => esc_html__( 'Choose gallery images from library', 'sanfrancisco' ),
				'type'   => 'gallery',
				'button' => esc_html__( 'Add Images', 'sanfrancisco' )
			),
			array(
				'id'    => 'sanfrancisco_gallery_override_featured_image',
				'label' => esc_html__( 'Replace Gallery with Featured Image', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to hide featured image in the single post and display only this gallery instead.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'true'
			),
			array(
				'id'    => 'sanfrancisco_gallery_override_teaser_image',
				'label' => esc_html__( 'Replace Gallery with Post Teaser Featured Image', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to replace the gallery with featured image in post teaser. (E.g in grid posts, sidebar posts)', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'true'
			),
			array(
				'id'    => 'sanfrancisco_gallery_display_caption',
				'label' => esc_html__( 'Display Caption over Gallery Images', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to display image caption over gallery images in the single post.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			)
		);

		/*
		 * Allow gallery post options fields to be filtered before building
		 */
		$ga_fields = apply_filters( 'sanfrancisco_gallery_post_options_fields_args', $ga_fields );

		/*
		 * GIF Featured Image Meta box fields
		 */
		$gi_fields = array(
			array(
				'id'    => 'sanfrancisco_gif_featured_image',
				'label' => esc_html__( 'GIF Featured Image', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Upload a GIF image or choose from library.', 'sanfrancisco' ),
				'type'  => 'media'
			)
		);

		/*
		 * Allow GIF featured image meta box fields to be filtered before building
		 */
		$gi_fields = apply_filters( 'sanfrancisco_gif_meta_box_fields_args', $gi_fields );

		/*
		 * Category Options Fields
		 */
		$ca_fields = array(
			array(
				'id'    => 'sanfrancisco_boxed_layout',
				'label' => esc_html__( 'Boxed Layout', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to be able to set background color to the full width page layout area for this category.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'        => 'sanfrancisco_boxed_layout_background_color',
				'label'     => esc_html__( 'Boxed Layout Background Color', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Set background color to the full width page layout area for this category.', 'sanfrancisco' ),
				'type'      => 'colorpicker',
				'alpha'     => true,
				'std'       => '#ffffff',
				'condition' => 'sanfrancisco_boxed_layout:is(true)'
			),
			array(
				'id' => 'sanfrancisco_accent_color',
				'label' => esc_html__( 'Category Accent Color', 'sanfrancisco' ),
				'type' => 'colorpicker',
				'std' => '#000000'
			),
			array(
				'id'      => 'sanfrancisco_background_inheritance',
				'label'   => esc_html__( 'Background', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Use parent background settings (Theme Options &gt; Blog &gt; Page &gt; Background) or set custom background for this category', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Background', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'sanfrancisco_background',
				'label'     => esc_html__( 'Set Background', 'sanfrancisco' ),
				'type'      => 'background',
				'std'       => $background_std,
				'condition' => 'sanfrancisco_background_inheritance:is(custom)'
			),
			array(
				'id' => 'sanfrancisco_layout',
				'label' => esc_html__( 'Layout', 'sanfrancisco' ),
				'type' => 'radio_select',
				'choices' => array(
					array(
						'text' => 'Full Width Posts',
						'value' => 'full'
					),
					array(
						'text' => 'Posts with Sidebar',
						'value' => 'ws'
					)
				)
			),
			array(
				'id' => 'sanfrancisco_posts_layout',
				'label' => esc_html__( 'Posts Layout', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose any layout to show posts in this category', 'sanfrancisco' ),
				'type' => 'radio_select',
				'choices' => $gp_posts_layout_choices
			),
			array(
				'id' => 'sanfrancisco_pagination_type',
				'label' => esc_html__( 'Pagination Type', 'sanfrancisco' ),
				'type' => 'select',
				'choices' => $gp_pagination_choices
			),
			array(
				'id' => 'sanfrancisco_sidebar',
				'label' => esc_html__( 'Sidebar', 'sanfrancisco' ),
				'type' => 'sidebar_select',
				'condition' => 'sanfrancisco_layout:is(ws)'
			),
			array(
				'id' => 'sanfrancisco_sidebar_position',
				'label' => esc_html__( 'Sidebar Position', 'sanfrancisco' ),
				'type' => 'radio_select',
				'choices' => array(
					array(
						'text' => esc_html__( 'Left', 'sanfrancisco' ),
						'value' => 'left'
					),
					array(
						'text' => esc_html__( 'Right', 'sanfrancisco' ),
						'value' => 'right'
					)
				),
				'condition' => 'sanfrancisco_sidebar:is(ws)'
			),
			array(
				'id' => 'sanfrancisco_display_title',
				'label' => esc_html__( 'Display Title', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show main title in this category, disable this option.', 'sanfrancisco' ),
				'type' => 'toggle'
			),
			array(
				'id' => 'sanfrancisco_display_breadcrumb',
				'label' => esc_html__( 'Display Breadcrumb', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show breadcrumb in this category, disable this option.', 'sanfrancisco'  ),
				'type' => 'toggle'
			),
			array(
				'id' => 'sanfrancisco_meta_data',
				'label' => esc_html__( 'Meta Data', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose which meta data to show for the posts in this category', 'sanfrancisco' ),
				'type' => 'checker',
				'choices' => array(
					array(
						'label' => esc_html__( 'Excerpt', 'sanfrancisco' ),
						'value' => 'excerpt'
					),
					array(
						'label' => esc_html__( 'Date', 'sanfrancisco' ),
						'value' => 'date'
					),
					array(
						'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
						'value' => 'byline'
					),
					array(
						'label' => esc_html__( 'Views', 'sanfrancisco' ),
						'value' => 'views'
					),
					array(
						'label' => esc_html__( 'Likes', 'sanfrancisco' ),
						'value' => 'likes'
					),
					array(
						'label' => esc_html__( 'Comments', 'sanfrancisco' ),
						'value' => 'comments'
					),
					array(
						'label' => esc_html__( 'Category Name', 'sanfrancisco' ),
						'value' => 'category'
					),
					array(
						'label' => esc_html__( 'Trending Icon', 'sanfrancisco' ),
						'value' => 'trending_icon'
					)
				)
			),
			array(
				'id'        => 'sanfrancisco_excerpt_length',
				'label'     => 'Excerpt Length',
				'desc'      => esc_html__( 'Choose how long will the excerpt be display for the posts in this category', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'     => '0,200',
				'condition' => 'sanfrancisco_meta_data:has(excerpt)'
			),
			array(
				'id'        => 'sanfrancisco_display_tags',
				'label'     => esc_html__( 'Display Tags', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Enable this option if you want post tags to be shown in the posts in this category', 'sanfrancisco' ),
				'type'      => 'toggle'
			),
			array(
				'id'        => 'sanfrancisco_tag_limit',
				'label'     => esc_html__( 'Tag Limit', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose maximum number of tags to display', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'     => '1,25',
				'condition' => 'sanfrancisco_display_tags:is(true)'
			),
			array(
				'id' => 'sanfrancisco_advertisement_inheritance',
				'label' => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use global advertisement settings (Theme Options &gt; Blog &gt; Category) or select custom ads for this category.', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Ads', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'sanfrancisco_advertisement',
				'label'     => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Select ads for any ad locations.', 'sanfrancisco' ),
				'type'      => 'advertisement',
				'locations' => $ad_locations_with_positions,
				'condition' => 'sanfrancisco_advertisement_inheritance:is(custom)'
			),
			array(
				'id' => 'sanfrancisco_ignore_override',
				'label' => esc_html__( 'Ignore Override', 'sanfrancisco' ),
				'desc' => esc_html__( 'Enable this option if you want to ignore global categories override option for this category', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'false'
			)
		);

		foreach ( $ca_fields as $i => $field ) {
			if ( ! array_key_exists( 'std', $field ) ) {
				$ca_fields[ $i ]['std'] = sanfrancisco_get_option( $field['id'] .'__category' );
			}
		}

		/*
		 * Allow category options fields to be filtered before building
		 */
		$ca_fields = apply_filters( 'sanfrancisco_category_options_fields_args', $ca_fields );

		/*
		 * Tag Options Fields
		 */
		$ta_fields = array(
			array(
				'id'    => 'sanfrancisco_boxed_layout',
				'label' => esc_html__( 'Boxed Layout', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Enable this option to be able to set background color to the full width page layout area for this tag page.', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'        => 'sanfrancisco_boxed_layout_background_color',
				'label'     => esc_html__( 'Boxed Layout Background Color', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Set background color to the full width page layout area for this tag page.', 'sanfrancisco' ),
				'type'      => 'colorpicker',
				'alpha'     => true,
				'std'       => '#ffffff',
				'condition' => 'sanfrancisco_boxed_layout:is(true)'
			),
			array(
				'id'      => 'sanfrancisco_background_inheritance',
				'label'   => esc_html__( 'Background', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Use parent background settings (Theme Options &gt; Blog &gt; Page &gt; Background) or set custom background for this tag page', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Background', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'sanfrancisco_background',
				'label'     => esc_html__( 'Set Background', 'sanfrancisco' ),
				'type'      => 'background',
				'std'       => $background_std,
				'condition' => 'sanfrancisco_background_inheritance:is(custom)'
			),
			array(
				'id' => 'sanfrancisco_layout',
				'label' => esc_html__( 'Layout', 'sanfrancisco' ),
				'type' => 'radio_select',
				'choices' => array(
					array(
						'text' => 'Full Width Posts',
						'value' => 'full'
					),
					array(
						'text' => 'Posts with Sidebar',
						'value' => 'ws'
					)
				)
			),
			array(
				'id' => 'sanfrancisco_posts_layout',
				'label' => esc_html__( 'Posts Layout', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose any layout to show posts in this tag page', 'sanfrancisco' ),
				'type' => 'radio_select',
				'choices' => $gp_posts_layout_choices
			),
			array(
				'id' => 'sanfrancisco_pagination_type',
				'label' => esc_html__( 'Pagination Type', 'sanfrancisco' ),
				'type' => 'select',
				'choices' => $gp_pagination_choices
			),
			array(
				'id' => 'sanfrancisco_sidebar',
				'label' => esc_html__( 'Sidebar', 'sanfrancisco' ),
				'type' => 'sidebar_select',
				'condition' => 'sanfrancisco_layout:is(ws)'
			),
			array(
				'id' => 'sanfrancisco_sidebar_position',
				'label' => esc_html__( 'Sidebar Position', 'sanfrancisco' ),
				'type' => 'radio_select',
				'choices' => array(
					array(
						'text' => esc_html__( 'Left', 'sanfrancisco' ),
						'value' => 'left'
					),
					array(
						'text' => esc_html__( 'Right', 'sanfrancisco' ),
						'value' => 'right'
					)
				),
				'condition' => 'sanfrancisco_sidebar:is(ws)'
			),
			array(
				'id' => 'sanfrancisco_display_title',
				'label' => esc_html__( 'Display Title', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show main title in this tag page, disable this option.', 'sanfrancisco' ),
				'type' => 'toggle'
			),
			array(
				'id' => 'sanfrancisco_display_breadcrumb',
				'label' => esc_html__( 'Display Breadcrumb', 'sanfrancisco' ),
				'desc' => esc_html__( 'If you don\'t want to show breadcrumb in this tag page, disable this option.', 'sanfrancisco'  ),
				'type' => 'toggle'
			),
			array(
				'id' => 'sanfrancisco_meta_data',
				'label' => esc_html__( 'Meta Data', 'sanfrancisco' ),
				'desc' => esc_html__( 'Choose which meta data to show for the posts in this tag page', 'sanfrancisco' ),
				'type' => 'checker',
				'choices' => array(
					array(
						'label' => esc_html__( 'Excerpt', 'sanfrancisco' ),
						'value' => 'excerpt'
					),
					array(
						'label' => esc_html__( 'Date', 'sanfrancisco' ),
						'value' => 'date'
					),
					array(
						'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
						'value' => 'byline'
					),
					array(
						'label' => esc_html__( 'Views', 'sanfrancisco' ),
						'value' => 'views'
					),
					array(
						'label' => esc_html__( 'Likes', 'sanfrancisco' ),
						'value' => 'likes'
					),
					array(
						'label' => esc_html__( 'Comments', 'sanfrancisco' ),
						'value' => 'comments'
					),
					array(
						'label' => esc_html__( 'Category Name', 'sanfrancisco' ),
						'value' => 'category'
					),
					array(
						'label' => esc_html__( 'Trending Icon', 'sanfrancisco' ),
						'value' => 'trending_icon'
					)
				)
			),
			array(
				'id'        => 'sanfrancisco_excerpt_length',
				'label'     => 'Excerpt Length',
				'desc'      => esc_html__( 'Choose how long will the excerpt be display for the posts in this tag page', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'     => '0,200',
				'condition' => 'sanfrancisco_meta_data:has(excerpt)'
			),
			array(
				'id'        => 'sanfrancisco_display_tags',
				'label'     => esc_html__( 'Display Tags', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Enable this option if you want post tags to be shown in the posts in this tag page', 'sanfrancisco' ),
				'type'      => 'toggle'
			),
			array(
				'id'        => 'sanfrancisco_tag_limit',
				'label'     => esc_html__( 'Tag Limit', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose maximum number of tags to display', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'     => '1,25',
				'condition' => 'sanfrancisco_display_tags:is(true)'
			),
			array(
				'id' => 'sanfrancisco_advertisement_inheritance',
				'label' => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc' => esc_html__( 'Use global advertisement settings (Theme Options &gt; Blog &gt; Tag) or select custom ads for this category.', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'inherit',
				'choices' => array(
					array(
						'text' => esc_html__( 'Inherit (Global Settings)', 'sanfrancisco' ),
						'value' => 'inherit'
					),
					array(
						'text' => esc_html__( 'Custom Ads', 'sanfrancisco' ),
						'value' => 'custom'
					)
				)
			),
			array(
				'id'        => 'sanfrancisco_advertisement',
				'label'     => esc_html__( 'Advertisement', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Select ads for any ad locations.', 'sanfrancisco' ),
				'type'      => 'advertisement',
				'locations' => $ad_locations_with_positions,
				'condition' => 'sanfrancisco_advertisement_inheritance:is(custom)'
			),
			array(
				'id' => 'sanfrancisco_ignore_override',
				'label' => esc_html__( 'Ignore Override', 'sanfrancisco' ),
				'desc' => esc_html__( 'Enable this option if you want to ignore global categories override option for this category', 'sanfrancisco' ),
				'type' => 'toggle',
				'std' => 'false'
			)
		);

		foreach ( $ta_fields as $i => $field ) {
			if ( ! array_key_exists( 'std', $field ) ) {
				$ta_fields[ $i ]['std'] = sanfrancisco_get_option( $field['id'] .'__tag' );
			}
		}

		/*
		 * Allow tag options fields to be filtered before building
		 */
		$ta_fields = apply_filters( 'sanfrancisco_tag_options_fields_args', $ta_fields );

		/*
		 * "San Francisco - Fancy Posts" widget fields
		 */
		$widget_fields['sanfrancisco-posts'] = array(
			array(
				'id'    => 'title',
				'label' => esc_html__( 'Title', 'sanfrancisco' ),
				'type' => 'text',
				'condition' => 'posts_layout:not(style_c)'
			),
			array(
				'id'      => 'posts_layout',
				'label'   => esc_html__( 'Posts Layout', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'horizontal_1_col',
				'choices' => array(
					array(
						'alt' => esc_html__( 'One Column Vertical', 'sanfrancisco' ),
						'value' => 'vertical_1_col',
						'image' => sanfrancisco_locate_template_uri( 'library/admin/images/grid-one-column-vertical.jpg' )
					),
					array(
						'alt' => esc_html__( 'One Column Horizontal', 'sanfrancisco' ),
						'value' => 'horizontal_1_col',
						'image' => sanfrancisco_locate_template_uri( 'library/admin/images/grid-one-column-horizontal.jpg' )
					),
					array(
						'alt' => esc_html__( 'Style C', 'sanfrancisco' ),
						'value' => 'style_c',
						'image' => sanfrancisco_locate_template_uri( 'library/admin/images/featured-posts-style-c.jpg' )
					)
				)
			),
			array(
				'id'        => 'fp_pagination_type',
				'label'     => esc_html__( 'Pagination Type', 'sanfrancisco' ),
				'type'      => 'select',
				'std'       => 'carousel',
				'choices'   => array(
					array(
						'label' => esc_html__( 'None', 'sanfrancisco' ),
						'value' => 'none'
					),
					array(
						'label' => esc_html__( 'Carousel', 'sanfrancisco' ),
						'value' => 'carousel'
					)
				),
				'condition' => 'posts_layout:is(style_c)'
			),
			array(
				'id'        => 'fp_autoplay',
				'label'     => esc_html__( 'Enable Autoplay', 'sanfrancisco' ),
				'type'      => 'toggle',
				'std'       => 'false',
				'condition' => 'posts_layout:is(style_c),fp_pagination_type:is(carousel)'
			),
			array(
				'id'        => 'fp_autoplay_timeout',
				'label'     => esc_html__( 'Autoplay Timeout', 'sanfrancisco' ),
				'type'      => 'range',
				'unit'      => 'miliseconds',
				'minmax'     => '1000,20000',
				'std'       => '5000',
				'condition' => 'posts_layout:is(style_c),fp_pagination_type:is(carousel),fp_autoplay:is(true)'
			),
			array(
				'id'        => 'fp_autoplay_hover_pause',
				'label'     => esc_html__( 'Pause Autoplay on Mouse Over', 'sanfrancisco' ),
				'type'      => 'toggle',
				'std'       => 'true',
				'condition' => 'posts_layout:is(style_c),fp_pagination_type:is(carousel),fp_autoplay:is(true)'
			),
			array(
				'id'        => 'fp_entry_body_position',
				'label'     => esc_html__( 'Post Body Position', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose where post title and meta data will be placed', 'sanfrancisco' ),
				'type'      => 'radio_select',
				'std'       => 'bottom',
				'choices'   => array(
					array(
						'text' => esc_html__( 'Bottom', 'sanfrancisco' ),
						'value' => 'bottom'
					),
					array(
						'text' => esc_html__( 'Center', 'sanfrancisco' ),
						'value' => 'center'
					)
				),
				'condition' => 'posts_layout:is(style_c)'
			),
			array(
				'id'        => 'fp_entry_body_visibility',
				'label'     => esc_html__( 'Post Body Visibility on Desktop', 'sanfrancisco' ),
				'type'      => 'radio_select',
				'std'       => 'always',
				'choices'   => array(
					array(
						'text' => esc_html__( 'Always', 'sanfrancisco' ),
						'value' => 'always'
					),
					array(
						'text' => esc_html__( 'Show On Hover', 'sanfrancisco' ),
						'value' => 'hover'
					),
					array(
						'text' => esc_html__( 'Hide On Hover', 'sanfrancisco' ),
						'value' => 'hide_hover'
					),
					array(
						'text' => esc_html__( 'Never', 'sanfrancisco' ),
						'value' => 'never'
					)
				),
				'condition' => 'posts_layout:is(style_c)'
			),
			array(
				'id'        => 'fp_entry_body_mobile_visibility',
				'label'     => esc_html__( 'Post Body Visibility on Mobile', 'sanfrancisco' ),
				'type'      => 'radio_select',
				'std'       => 'always',
				'choices'   => array(
					array(
						'text' => esc_html__( 'Always', 'sanfrancisco' ),
						'value' => 'always'
					),
					array(
						'text' => esc_html__( 'Never', 'sanfrancisco' ),
						'value' => 'never'
					)
				),
				'condition' => 'posts_layout:is(style_c)'
			),
			array(
				'id'        => 'fp_carousel_buttons_visibility',
				'label'     => esc_html__( 'Carousel Prev/Next Buttons Visibility on Desktop', 'sanfrancisco' ),
				'type'      => 'radio_select',
				'std'       => 'hover',
				'choices'   => array(
					array(
						'text' => esc_html__( 'Always', 'sanfrancisco' ),
						'value' => 'always'
					),
					array(
						'text' => esc_html__( 'On Hover', 'sanfrancisco' ),
						'value' => 'hover'
					),
					array(
						'text' => esc_html__( 'Never', 'sanfrancisco' ),
						'value' => 'never'
					)
				),
				'condition' => 'posts_layout:is(style_c),fp_pagination_type:is(carousel)'
			),
			array(
				'id'        => 'fp_carousel_buttons_mobile_visibility',
				'label'     => esc_html__( 'Carousel Prev/Next Buttons Visibility on Mobile', 'sanfrancisco' ),
				'type'      => 'radio_select',
				'std'       => 'always',
				'choices'   => array(
					array(
						'text' => esc_html__( 'Always', 'sanfrancisco' ),
						'value' => 'always'
					),
					array(
						'text' => esc_html__( 'Never', 'sanfrancisco' ),
						'value' => 'never'
					)
				),
				'condition' => 'posts_layout:is(style_c),fp_pagination_type:is(carousel)'
			),
			array(
				'id'        => 'fp_carousel_dots_visibility',
				'label'     => esc_html__( 'Carousel Dots Visibility on Desktop', 'sanfrancisco' ),
				'type'      => 'radio_select',
				'std'       => 'never',
				'choices'   => array(
					array(
						'text' => esc_html__( 'Always', 'sanfrancisco' ),
						'value' => 'always'
					),
					array(
						'text' => esc_html__( 'Never', 'sanfrancisco' ),
						'value' => 'never'
					)
				),
				'condition' => 'posts_layout:is(style_c),fp_pagination_type:is(carousel)'
			),
			array(
				'id'        => 'fp_carousel_dots_mobile_visibility',
				'label'     => esc_html__( 'Carousel Dots Visibility on Mobile', 'sanfrancisco' ),
				'type'      => 'radio_select',
				'std'       => 'never',
				'choices'   => array(
					array(
						'text' => esc_html__( 'Always', 'sanfrancisco' ),
						'value' => 'always'
					),
					array(
						'text' => esc_html__( 'Never', 'sanfrancisco' ),
						'value' => 'never'
					)
				),
				'condition' => 'posts_layout:is(style_c),fp_pagination_type:is(carousel)'
			),
			array(
				'id'        => 'fp_color',
				'label'     => esc_html__( 'Featured Posts Color Scheme', 'sanfrancisco' ),
				'type'      => 'colorpicker',
				'alpha'     => true,
				'labels'    => array(
					'overlay_background_color'        => esc_html__( 'Overlay Color on Desktop', 'sanfrancisco' ),
					'overlay_color'                   => esc_html__( 'Text Color on Desktop', 'sanfrancisco' ),
					'overlay_hover_background_color'  => esc_html__( 'Overlay Hover Color on Desktop', 'sanfrancisco' ),
					'overlay_hover_color'             => esc_html__( 'Text Hover Color on Desktop', 'sanfrancisco' ),
					'overlay_mobile_background_color' => esc_html__( 'Overlay Color on Mobile', 'sanfrancisco' ),
					'overlay_mobile_color'            => esc_html__( 'Text Color on Mobile', 'sanfrancisco' ),
					'carousel_buttons_color'          => esc_html__( 'Carousel Prev/Next Buttons Arrow Color', 'sanfrancisco' ),
					'carousel_buttons_border_color'   => esc_html__( 'Carousel Prev/Next Buttons Background Color', 'sanfrancisco' )
				),
				'std'       => array(
					'overlay_background_color'        => 'rgba(0,0,0,0.3)',
					'overlay_color'                   => '#ffffff',
					'overlay_hover_background_color'  => 'rgba(0,0,0,0.25)',
					'overlay_hover_color'             => '#ffffff',
					'overlay_mobile_background_color' => 'rgba(0,0,0,0.3)',
					'overlay_mobile_color'            => '#ffffff',
					'carousel_buttons_color'          => '#000000',
					'carousel_buttons_border_color'   => '#ffffff'
				),
				'condition' => 'posts_layout:is(style_c)'
			),
			array(
				'id'    => 'posts_per_page',
				'label' => esc_html__( 'Number of Posts', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Choose how many posts will display in the widget', 'sanfrancisco' ),
				'type'  => 'range',
				'minmax' => '1,50',
				'std'   => '4'
			),
			array(
				'id'    => 'posts_offset',
				'label' => esc_html__( 'Posts Offset', 'sanfrancisco' ),
				'type'  => 'range',
				'minmax' => '0,100',
				'std'   => '0'
			),
			array(
				'id'    => 'post_types',
				'label' => esc_html__( 'Filter by Post Types', 'sanfrancisco' ),
				'type'  => 'post_type_checker',
				'std'   => 'all'
			),
			array(
				'id'    => 'post_taxonomies',
				'label' => esc_html__( 'Filter by Taxonomies', 'sanfrancisco' ),
				'type'  => 'taxonomy_checker',
				'std'   => 'all'
			),
			array(
				'id'    => 'post_tags',
				'label' => esc_html__( 'Filter by Tag Names', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Add tag(s) seperated by comma. i.e. sports, cooking', 'sanfrancisco' ),
				'type'  => 'text'
			),
			array(
				'id'    => 'post_ids',
				'label' => esc_html__( 'Filter by Post Id\'s', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Specify post ids separated by comma. i.e. 45,73,132,19', 'sanfrancisco' ),
				'type'  => 'text'
			),
			array(
				'id'    => 'excluded_post_ids',
				'label' => esc_html__( 'Excluded Post Id\'s', 'sanfrancisco' ),
				'desc'  => esc_html__( 'Specify excluded post ids separated by comma. i.e. 45,73,132,19', 'sanfrancisco' ),
				'type'  => 'text'
			),
			array(
				'id'      => 'orderby',
				'label'   => esc_html__( 'Order Posts by', 'sanfrancisco' ),
				'type'    => 'select',
				'std'     => 'date',
				'choices' => $orderby_choices
			),
			array(
				'id'      => 'order',
				'label'   => esc_html__( 'Order Type', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'desc',
				'choices' => $order_choices
			),
			array(
				'id'      => 'meta_data',
				'label'   => esc_html__( 'Posts Meta Data', 'sanfrancisco' ),
				'desc'    => esc_html__( 'Check which meta data to show for the posts in the widget', 'sanfrancisco' ),
				'type'    => 'checker',
				'std'     => array(
					'views',
					'likes',
					'comments',
					'trending_icon'
				),
				'choices' => array(
					array(
						'label' => esc_html__( 'Excerpt', 'sanfrancisco' ),
						'value' => 'excerpt'
					),
					array(
						'label' => esc_html__( 'Date', 'sanfrancisco' ),
						'value' => 'date'
					),
					array(
						'label' => esc_html__( 'Author Name', 'sanfrancisco' ),
						'value' => 'byline'
					),
					array(
						'label' => esc_html__( 'Views', 'sanfrancisco' ),
						'value' => 'views'
					),
					array(
						'label' => esc_html__( 'Likes', 'sanfrancisco' ),
						'value' => 'likes'
					),
					array(
						'label' => esc_html__( 'Comments', 'sanfrancisco' ),
						'value' => 'comments'
					),
					array(
						'label' => esc_html__( 'Category Name', 'sanfrancisco' ),
						'value' => 'category'
					),
					array(
						'label' => esc_html__( 'Trending Icon', 'sanfrancisco' ),
						'value' => 'trending_icon'
					)
				)
			),
			array(
				'id'        => 'excerpt_length',
				'label'     => 'Excerpt Length',
				'desc'      => esc_html__( 'Choose how long will the excerpt be display for the posts', 'sanfrancisco' ),
				'type'      => 'range',
				'minmax'     => '0,200',
				'std'       => '50',
				'operator'  => 'or',
				'condition' => 'meta_data:has(excerpt)'
			),
			array(
				'id'        => 'display_tags',
				'label'     => esc_html__( 'Display Tags', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Enable this option if you want post tags to be shown in the module', 'sanfrancisco' ),
				'type'      => 'toggle',
				'std'       => 'true',
				'condition' => 'posts_layout:not(style_c)'
			),
			array(
				'id'        => 'tag_limit',
				'label'     => esc_html__( 'Tag Limit', 'sanfrancisco' ),
				'desc'      => esc_html__( 'Choose maximum number of tags to display', 'sanfrancisco' ),
				'type'      => 'range',
				'std'       => 3,
				'minmax'     => '1,25',
				'condition' => 'display_tags:is(true),posts_layout:not(style_c)'
			)
		);

		/*
		 * "San Francisco - Facebook Box" widget fields
		 */
		$widget_fields['sanfrancisco-facebook-box'] = array(
			array(
				'id'    => 'title',
				'label' => esc_html__( 'Title', 'sanfrancisco' ),
				'type'  => 'text'
			),
			array(
				'id'         => 'href',
				'label'      => esc_html__( 'Facebook Page URL', 'sanfrancisco' ),
				'type'       => 'text',
				'input_type' => 'url'
			),
			array(
				'id'    => 'small_header',
				'label' => esc_html__( 'Use Small Header', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'    => 'hide_cover',
				'label' => esc_html__( 'Hide Cover Photo', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'    => 'show_posts',
				'label' => esc_html__( 'Show Page Posts', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'    => 'show_facepile',
				'label' => esc_html__( 'Show Friend\'s Faces', 'sanfrancisco' ),
				'type'  => 'toggle',
				'std'   => 'false'
			),
			array(
				'id'    => 'tabs',
				'label' => esc_html__( 'Tabs', 'sanfrancisco' ),
				'type'  => 'checker',
				'std'   => array(
					'timeline'
				),
				'choices' => array(
					array(
						'label' => esc_html__( 'Timeline', 'sanfrancisco' ),
						'value' => 'timeline'
					),
					array(
						'label' => esc_html__( 'Events', 'sanfrancisco' ),
						'value' => 'events'
					),
				    array(
					    'label' => esc_html__( 'Messages', 'sanfrancisco' ),
					    'value' => 'messages'
				    )
				)
			),
		);

		/*
		 * "San Francisco - Google+ Box" widget fields
		 */
		$widget_fields['sanfrancisco-gplus-box'] = array(
			array(
				'id'    => 'title',
				'label' => esc_html__( 'Title', 'sanfrancisco' ),
				'type'  => 'text'
			),
			array(
				'id'         => 'href',
				'label'      => esc_html__( 'Google+ URL', 'sanfrancisco' ),
				'type'       => 'text',
				'input_type' => 'url'
			),
			array(
				'id'      => 'layout',
				'label'   => esc_html__( 'Layout', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'portrait',
				'choices' => array(
					array(
						'text'  => esc_html__( 'Portrait', 'sanfrancisco' ),
						'value' => 'portrait'
					),
					array(
						'text'  => esc_html__( 'Landscape', 'sanfrancisco' ),
						'value' => 'landscape'
					)
				)
			),
			array(
				'id'      => 'theme',
				'label'   => esc_html__( 'Theme', 'sanfrancisco' ),
				'type'    => 'radio_select',
				'std'     => 'light',
				'choices' => array(
					array(
						'text'  => esc_html__( 'Light', 'sanfrancisco' ),
						'value' => 'light'
					),
					array(
						'text'  => esc_html__( 'Dark', 'sanfrancisco' ),
						'value' => 'dark'
					)
				)
			),
			array(
				'id'        => 'showcoverphoto',
				'label'     => esc_html__( 'Show Cover Photo', 'sanfrancisco' ),
				'type'      => 'toggle',
				'std'       => 'true',
				'condition' => 'layout:is(portrait)'
			),
			array(
				'id'        => 'showtagline',
				'label'     => esc_html__( 'Show Tagline', 'sanfrancisco' ),
				'type'      => 'toggle',
				'std'       => 'true',
				'condition' => 'layout:is(portrait)'
			)
		);

		/*
		 * Initialize theme options
		 */
		$theme_options = new MCO_Theme_Options( array(
			'id'       => 'sanfrancisco',
			'lib_uri'  => sanfrancisco_locate_template_uri( 'library/mco-theme-options' ),
			'lib_path' => trailingslashit( get_template_directory() ) . 'library/mco-theme-options'
		) );

		/*
		 * Register theme options page
		 */
		$theme_options->theme_options( array(
			'id'     => $to_id,
			'title'  => esc_html__( 'Theme Options', 'sanfrancisco' ),
			'fields' => $to_fields
		) );

		/*
		 * Register page builder meta box
		 */
		$theme_options->page_builder( array(
			'id'        => sanfrancisco_get_pb_id(),
			'title'     => esc_html__( 'Page Builder', 'sanfrancisco' ),
			'settings'  => $pb_settings,
			'condition' => 'page_template:is(page-sections.php)'
		) );

		/*
		 * Register page options meta box
		 */
		$theme_options->post_options( array(
			'id'         => 'sanfrancisco_pa',
			'title'      => esc_html__( 'Page Options', 'sanfrancisco' ),
			'fields'     => $pa_fields,
			'display'    => 'page'
		) );

		/*
		 * Register post options meta box
		 */
		$theme_options->post_options( array(
			'id'      => 'sanfrancisco_po',
			'title'   => esc_html__( 'Post Options', 'sanfrancisco' ),
			'fields'  => $po_fields,
			'display' => 'post'
		) );

		/*
		 * Register video post options meta box
		 */
		$theme_options->post_options( array(
			'id'        => 'sanfrancisco_vi',
			'title'     => esc_html__( 'Video Post Options', 'sanfrancisco' ),
			'fields'    => $vi_fields,
			'display'   => 'post',
			'context'   => 'advanced',
			'condition' => 'post_format:is(video)'
		) );

		/*
		 * Register audio post options meta box
		 */
		$theme_options->post_options( array(
			'id'        => 'sanfrancisco_au',
			'title'     => esc_html__( 'Audio Post Options', 'sanfrancisco' ),
			'fields'    => $au_fields,
			'display'   => 'post',
			'context'   => 'advanced',
			'condition' => 'post_format:is(audio)'
		) );

		/*
		 * Register gallery post options meta box
		 */
		$theme_options->post_options( array(
			'id'        => 'sanfrancisco_ga',
			'title'     => esc_html__( 'Gallery Post Options', 'sanfrancisco' ),
			'fields'    => $ga_fields,
			'display'   => 'post',
			'context'   => 'advanced',
			'condition' => 'post_format:is(gallery)'
		) );

		/*
		 * Register gif featured image meta box
		 */
		$theme_options->post_options( array(
			'id'       => 'sanfrancisco_gi',
			'title'    => esc_html__( 'Animated GIF Featured Image', 'sanfrancisco' ),
			'fields'   => $gi_fields,
			'display'  => array(
				'page',
				'post'
			),
			'context'  => 'side',
			'priority' => 'low'
		) );

		/*
		 * Add extra category options fields
		 */
		$theme_options->term_options( array(
			'fields'   => $ca_fields,
			'taxonomy' => 'category'
		) );

		/*
		 * Add extra category options fields
		 */
		$theme_options->term_options( array(
			'fields'   => $ta_fields,
			'taxonomy' => 'post_tag'
		) );

		/*
		 * Add extra widget options fields.
		 */
		foreach ( $widget_fields as $widget_id => $fields ) {

			/*
			 * Allow widget fields to be filtered before building
			 */
			$fields = apply_filters( $widget_id . '_widget_fields_args', $fields );

			$theme_options->widget_options( array(
				'id'     => $widget_id,
				'fields' => $fields
			) );

		}

	}
}
add_action( 'init', 'sanfrancisco_admin' );

/*
 * Enqueue Admin Scripts & Styles
 */
if ( ! function_exists( 'sanfrancisco_admin_enqueue_scripts' ) ) {
	function sanfrancisco_admin_enqueue_scripts( $hook ) {

		$hook_arr = array(
			'widgets.php',
			'edit-tags.php',
			'term.php',
			'post-new.php',
			'post.php'
		);

		if ( in_array( $hook, $hook_arr ) ) {

			if ( in_array( $hook, array( 'post.php', 'post-new.php' ) ) ) {

				/* load open sans google font */
				wp_enqueue_style( 'google-font-roboto', '//fonts.googleapis.com/css?family=Roboto:300,400,400i,500,700,900' );

			}

			wp_enqueue_media();

			wp_enqueue_script( 'sanfrancisco-admin-js', sanfrancisco_locate_template_uri( 'library/admin/js/sf-admin.js' ), array( 'jquery' ), SANFRANCISCO_THEME_VERSION, true );

			wp_enqueue_style( 'sanfrancisco-admin-css', sanfrancisco_locate_template_uri( 'library/admin/css/sf-admin.css' ), array(), SANFRANCISCO_THEME_VERSION );

			if ( is_rtl() ) {
				wp_enqueue_style( 'sanfrancisco-admin-rtl-css', sanfrancisco_locate_template_uri( 'library/admin/css/sf-admin-rtl.css' ), array(), SANFRANCISCO_THEME_VERSION );
			}

		}

	}
}
add_action( 'admin_enqueue_scripts', 'sanfrancisco_admin_enqueue_scripts', 99 );

/*
 * Add custom field for the user
 */
if ( ! function_exists( 'sanfrancisco_add_custom_user_profile_fields' ) ) {
	function sanfrancisco_add_custom_user_profile_fields( $user ) {
		?>
		<table id="user_job_field" class="form-table">
			<tr id="user_job_field_row">
				<th>
					<label for="job_field"><?php esc_html_e( 'Job', 'sanfrancisco' ); ?></label>
				</th>
				<td>
					<input type="text" name="job" id="job_field" value="<?php echo esc_attr( get_the_author_meta( 'job', $user->ID ) ); ?>" class="regular-text" />
				</td>
			</tr>
		</table>
		<?php
	}
}
add_action( 'show_user_profile', 'sanfrancisco_add_custom_user_profile_fields' );
add_action( 'edit_user_profile', 'sanfrancisco_add_custom_user_profile_fields' );

if ( ! function_exists( 'sanfrancisco_save_custom_user_profile_fields' ) ) {
	function sanfrancisco_save_custom_user_profile_fields( $user_id ) {
		update_user_meta( $user_id,'job', sanitize_text_field( $_POST['job'] ) );
	}
}
add_action( 'personal_options_update', 'sanfrancisco_save_custom_user_profile_fields' );
add_action( 'edit_user_profile_update', 'sanfrancisco_save_custom_user_profile_fields' );

if ( ! function_exists( 'sanfrancisco_user_job_field_placement_js' ) ) {
	function sanfrancisco_user_job_field_placement_js() {

		$screen = get_current_screen();
		if ( $screen->id != 'profile' && $screen->id != 'user-edit' ) {
			return;
		}

		?>
		<script type="text/javascript">
			jQuery(document).ready(function($) {
				var field = $('#user_job_field_row').remove();
				field.insertBefore('.user-description-wrap');
			});
		</script>
		<?php

	}
}
add_action( 'admin_head', 'sanfrancisco_user_job_field_placement_js' );