<?php

$sanfrancisco_search_icon = '';
if ( sanfrancisco_get_option( 'display_header_search_icon' ) == 'true' ) {
	$sanfrancisco_search_icon = '<li class="sf-item-search"><a href="' . esc_url( home_url( '/' ) ) . '" rel="nofollow" class="sf-btn-search"><span class="fa fa-search"></span></a></li>';
}

$sanfrancisco_header_style = sanfrancisco_get_option( 'header_style' );
$sanfrancisco_display_trending = ( sanfrancisco_get_option( 'display_trending_menu' ) == 'true' );

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php do_action( 'sanfrancisco_body_start' ); ?>
<nav class="<?php echo esc_attr( sanfrancisco_nav_class() ); ?>">

	<?php do_action( 'sanfrancisco_place_ad', 'header_above' ); ?>

	<div class="sf-nav-wrapper">

		<div class="container">

			<div class="navbar-header">
				<?php sanfrancisco_logo( 'header' ); ?>
				<ul class="navbar-actions">
					<?php echo 'single_row' == $sanfrancisco_header_style ? '' : $sanfrancisco_search_icon; ?>
					<li class="sf-toggle">
						<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
							<span class="sr-only"><?php esc_html_e( 'Toggle navigation', 'sanfrancisco' ); ?></span>
							<span class="fa fa-bars"></span>
						</button>
					</li>
				</ul>
			</div><!-- .navbar-header -->

			<?php if ( has_nav_menu( 'main' ) || $sanfrancisco_display_trending ): ?>
			<div id="navbar" class="navbar-collapse collapse">

				<?php

				if ( has_nav_menu( 'main' ) ) {
					wp_nav_menu( array(
						'theme_location' => 'main',
						'container'      => false,
						'menu_class'     => 'navbar-nav nav nav-menu',
					    // @todo: mega menu option will be available in the upcoming update
						// 'walker'      => new sanfrancisco_megamenu_walker
					) );
				}

				if ( $sanfrancisco_display_trending ): ?>
				<ul class="nav navbar-nav navbar-right">
					<?php echo 'single_row' == $sanfrancisco_header_style ? $sanfrancisco_search_icon : ''; ?>
					<li class="sf-item-trending active sf-mm-item">
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="nofollow">
							<span class="fa fa-bolt"></span><?php esc_html_e( 'Trending', 'sanfrancisco' ); ?>
						</a>
						<?php sanfrancisco_mega_menu( 0, 'trending_item' ); ?>
					</li><!-- .sf-item-trending -->
				</ul><!-- .navbar-right -->
				<?php endif; ?>

			</div><!-- .nav-collapse -->
			<?php endif; ?>

		</div><!-- .container -->

	</div><!-- .sf-nav-wrapper -->

</nav><!-- .navbar -->
<?php

echo '<div class="sf-sections-wrapper">';

do_action( 'sanfrancisco_place_ad', 'header_below' );