<?php

define( 'SANFRANCISCO_THEME_VERSION', '1.3.3' );
define( 'SANFRANCISCO_THEME_TITLE', esc_html_x( 'San Francisco', 'theme title', 'sanfrancisco' ) );
define( 'SANFRANCISCO_DOCS_URI', 'https://minduction.co/docs/sanfrancisco' );

/*
 * Require core functionality
 */
$sanfrancisco_core = array(
	'helpers',
	'theme-support',
	'template-tags',
	'scripts',
	'widgets',
	'filters'
);

foreach ( $sanfrancisco_core as $k ) {
	require_once trailingslashit( get_template_directory() ) . 'library/core/'. sanitize_key( $k ) .'.php';
}

/*
 * Require theme options library
 */
require_once trailingslashit( get_template_directory() ) . 'library/mco-theme-options/mco-theme-options.php';

/*
 * Require admin functionality
 */
require_once trailingslashit( get_template_directory() ) . 'library/admin/admin.php';

/*
 * Require TGM plugin activation
 */
require_once trailingslashit( get_template_directory() ) . 'library/admin/tgm.php';

/*
 * Set content width
 */
if ( ! isset( $content_width ) ) {
	$content_width = 700;
}