<?php

do_action( 'sanfrancisco_place_ad', array(
	'fixed_left',
	'fixed_right',
	'background',
	'footer_above'
) );

echo '<span class="sf-bg-fixed"></span></div><!-- .sections-wrapper -->';

$sanfrancisco_display = sanfrancisco_get_options( array(
	'display_footer',
	'display_footer_branding',
	'display_footer_sidebars',
	'display_sub_footer',
	'display_footer_nav'
) );

foreach ( $sanfrancisco_display as $k => $v ) {
	$k = str_replace( 'display_', '', $k );
	$sanfrancisco_display[ $k ] = ( $v != 'false' );
}

if ( ! $sanfrancisco_display['footer_branding'] && ! $sanfrancisco_display['footer_sidebars'] && ! $sanfrancisco_display['sub_footer'] ) {
	$sanfrancisco_display['footer'] = false;
}

$sanfrancisco_footer_class = array( 'sf-footer' );
if ( $sanfrancisco_display['footer_sidebars'] ) {
	$sanfrancisco_footer_class[] = 'sf-section-ws';
	$sanfrancisco_footer_class[] = 'sf-section-has-sidebar';
}

if ( $sanfrancisco_display['footer'] ): ?>
<footer class="<?php echo implode( ' ', $sanfrancisco_footer_class ); ?>">
	<div class="container">

		<?php if ( $sanfrancisco_display['footer_branding'] || $sanfrancisco_display['footer_sidebars'] ): ?>
		<div class="sf-footer-sidebar-wrapper clearfix">

			<?php for ( $i=1; $i<=3; $i++ ): ?>
			<div class="sf-col">

				<?php if ( $sanfrancisco_display['footer_branding'] && $i == 1 ): $sanfrancisco_footer_branding = sanfrancisco_get_option( 'footer_branding_description' );  ?>
				<div class="sf-footer-brand-box">
					<?php

					sanfrancisco_logo( 'footer' );

					if ( ! empty( $sanfrancisco_footer_branding ) ) {
						echo '<p class="sf-footer-brand-text">' . stripcslashes( esc_html( $sanfrancisco_footer_branding ) ) . '</p><hr />';
					}

					?>
				</div><!-- .sf-footer-logo-box -->
				<?php endif; ?>

				<?php if ( $sanfrancisco_display['footer_sidebars'] ): ?>
				<div class="sf-footer-sidebar sf-footer-sidebar-<?php echo sanitize_html_class( $i ); ?>">
					<?php
					$sanfrancisco_footer_sidebar = 'sanfrancisco-footer-sidebar-'. intval( $i );
					if ( is_active_sidebar( $sanfrancisco_footer_sidebar ) ) {
						dynamic_sidebar( $sanfrancisco_footer_sidebar );
					}
					?>
				</div><!-- .sf-footer-sidebar -->
				<?php endif; ?>

			</div><!-- .sf-col -->
			<?php endfor; ?>

		</div><!-- .sf-footer-sidebar-wrapper -->
		<?php endif; ?>

		<?php if ( $sanfrancisco_display['sub_footer'] ): ?>
		<div class="sf-footer-bottom row">

			<hr />

			<div class="col-md-6">
				<p class="sf-footer-copyright-text">
					<?php echo stripcslashes( esc_html( sanfrancisco_get_option( 'footer_copyright_text' ) ) ); ?>
				</p>
			</div>

			<?php if ( $sanfrancisco_display['footer_nav'] && has_nav_menu( 'footer' ) ): ?>
			<div class="col-md-6">
				<?php

				wp_nav_menu( array(
					'theme_location' => 'footer',
					'container'      => false,
					'menu_class'     => 'sf-footer-nav'
				) );

				?>
			</div>
			<?php endif; ?>

		</div><!-- .sf-footer-bottom -->
		<?php endif; ?>

	</div><!-- .container -->
</footer><!-- .sf-footer -->
<?php endif;

do_action( 'sanfrancisco_place_ad', array(
	'fixed_bottom',
	'splash',
	'footer_below'
) );

wp_footer();

?>
</body>
</html>