<?php

if ( post_password_required() || ( ! have_comments() && ! comments_open() ) ) {
	return;
}

$sanfrancisco_commenter = wp_get_current_commenter();
$sanfrancisco_user = wp_get_current_user();
$sanfrancisco_user_identity = $sanfrancisco_user->exists() ? $sanfrancisco_user->display_name : '';

$sanfrancisco_req      = get_option( 'require_name_email' );
$sanfrancisco_html_req = ( $sanfrancisco_req ? ' required="required"' : '' );
$sanfrancisco_aria_req = ( ( $sanfrancisco_req && ! empty( $sanfrancisco_html_req ) ) ? ' aria-required="true"' : '' );

$sanfrancisco_hide_avatars = ( get_option( 'show_avatars' ) == '1' ) ? '' : ' hide-avatars';

?>
<section class="sf-entry-comments" itemscope itemtype="https://schema.org/UserComments">

	<?php if ( have_comments() ): ?>

		<h2 class="sf-comments-title">
			<?php comments_number( esc_html__( 'No Comments', 'sanfrancisco' ), esc_html__( 'One Comment', 'sanfrancisco' ), esc_html( _n( '% Comment', '% Comments', number_format_i18n( get_comments_number() ), 'sanfrancisco' ) ) ); ?>
		</h2>

		<?php sanfrancisco_comments_nav( 'top' ); ?>

		<ol class="sf-comment-list<?php echo esc_attr( $sanfrancisco_hide_avatars ); ?>">
			<?php

			wp_list_comments(
				array(
					'type'          => 'comment',
					'callback'      => 'sanfrancisco_comments_cb',
					'avatar_size'   => 70,
					'style'         => 'li',
					'max_depth'     => '2'
				)
			);

			?>
		</ol>

		<?php sanfrancisco_comments_nav( 'bottom' ); ?>

	<?php endif; ?>

	<?php if ( comments_open() ): ?>
		<div class="sf-comment-respond">
			<div class="row">
			<?php

			$sanfrancisco_wp_kses_allowable_html = array(
				'a' => array(
					'href' => array(),
					'title' => array()
				)
			);

			comment_form(
				array(
					'title_reply'           => esc_html__( 'Leave a Reply', 'sanfrancisco' ),
					'title_reply_to'        => esc_html__( 'Leave a Reply to %s', 'sanfrancisco' ),
					'logged_in_as'          => '<div class="col-sm-12"><p class="comment-notes">'. sprintf( wp_kses( __( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>', 'sanfrancisco' ), $sanfrancisco_wp_kses_allowable_html ), get_edit_user_link(), $sanfrancisco_user_identity, wp_logout_url( apply_filters( 'the_permalink', get_permalink() ) ) ) .'</p></div>',
					'cancel_reply_link'     => esc_html__( 'Cancel Reply', 'sanfrancisco' ),
					'label_submit'          => esc_html__( 'Post Comment', 'sanfrancisco' ),
					'class_submit'          => 'submit sf-btn sf-btn-green',
					'comment_notes_after'   => '',
					'comment_notes_before'  => '<div class="col-sm-12"><p class="comment-notes">'. esc_html_x( 'Your email address will not be published. Required fields are marked *', 'comment notes before', 'sanfrancisco' ) .'</p></div>',
					'must_log_in'           => '<div class="col-sm-12"><p class="form-before-text alert alert-danger">' . sprintf( wp_kses( __( 'You must be <a href="%s">logged in</a> to post a comment.', 'sanfrancisco' ), $sanfrancisco_wp_kses_allowable_html ), wp_login_url( apply_filters( 'the_permalink', get_permalink() ) ) ) . '</p></div>',
					'comment_field'         => '<div class="col-sm-12"><div class="form-group comment-form-comment"><textarea id="comment" class="form-control" name="comment" cols="45" rows="8" placeholder="'. esc_html_x( 'Comment', 'noun', 'sanfrancisco' ) .' *" required="required"></textarea></div></div>',
					'submit_field'          => '<div class="col-sm-12"><div class="form-group form-submit">%1$s %2$s</div></div>',
					'submit_button'         => '<button type="submit" name="%1$s" id="%2$s" class="%3$s">%4$s</button>',
					'format'                => 'html5',
					'class_form'            => 'sf-comment-form',
					'fields' => array(
						'author'    => '<div class="col-sm-4"><div class="form-group comment-form-author"><input id="author" class="form-control" type="text" name="author" placeholder="'. esc_html__( 'Name', 'sanfrancisco' ) . ( $sanfrancisco_req ? ' *' : '' ) .'" value="' . esc_attr( $sanfrancisco_commenter['comment_author'] ) . '" size="30"'. $sanfrancisco_aria_req . $sanfrancisco_html_req .'></div></div>',
						'email'     => '<div class="col-sm-4"><div class="form-group comment-form-email"><input id="email" class="form-control" type="email" name="email" placeholder="'. esc_html__( 'Email', 'sanfrancisco' ) . ( $sanfrancisco_req ? ' *' : '' ) .'" value="' . esc_attr( $sanfrancisco_commenter['comment_author_email'] ) . '" size="30"'. $sanfrancisco_aria_req . $sanfrancisco_html_req .'></div></div>',
						'url'       => '<div class="col-sm-4"><div class="form-group comment-form-url"><input id="url" class="form-control" type="url" name="url" placeholder="'. esc_html__( 'Website', 'sanfrancisco' ) .'" value="' . esc_attr( $sanfrancisco_commenter['comment_author_url'] ) . '" size="30"></div></div>'
					)
				)
			);

			?>
			</div>
		</div>
	<?php endif; ?>

</section>